/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen;

import com.github.ysbbbbbb.kaleidoscopecookery.loot.AdditionLootModifier;
import java.util.Optional;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.data.GlobalLootModifierProvider;
import net.minecraftforge.common.loot.IGlobalLootModifier;

public class GlobalLootModifier
extends GlobalLootModifierProvider {
    private static final ResourceLocation ENTITY = new ResourceLocation("entity");
    private static final ResourceLocation BLOCK = new ResourceLocation("block");

    public GlobalLootModifier(PackOutput output) {
        super(output, "kaleidoscope_cookery");
    }

    public void start() {
        this.addEntityLootModifier("pig", EntityType.f_20510_);
        this.addEntityLootModifier("zombified_piglin", EntityType.f_20531_);
        this.addEntityLootModifier("piglin", EntityType.f_20511_);
        this.addEntityLootModifier("piglin_brute", EntityType.f_20512_);
        this.addEntityLootModifier("hoglin", EntityType.f_20456_);
        this.addEntityLootModifier("zoglin", EntityType.f_20500_);
        this.addEntityLootModifier("donkey", EntityType.f_20560_);
        this.addBlockLootModifier("straw_hat_seed_drop", Blocks.f_50034_);
    }

    private void addEntityLootModifier(String name, EntityType<?> type) {
        LootItemCondition[] conditions = new LootItemCondition[]{};
        this.add(name, (IGlobalLootModifier)new AdditionLootModifier(conditions, ENTITY, Optional.of(type.m_20677_()), this.modLoc(name)));
    }

    private void addBlockLootModifier(String name, Block block) {
        LootItemCondition[] conditions = new LootItemCondition[]{};
        this.add(name, (IGlobalLootModifier)new AdditionLootModifier(conditions, BLOCK, Optional.of(block.m_60589_()), this.modLoc(name)));
    }

    public ResourceLocation modLoc(String name) {
        return new ResourceLocation("kaleidoscope_cookery", name);
    }
}

