/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.item;

import com.github.ysbbbbbb.kaleidoscopecookery.api.event.RecipeItemEvent;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.PotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.PotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.StockpotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import com.github.ysbbbbbb.kaleidoscopecookery.inventory.tooltip.RecipeItemTooltip;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.wrapper.PlayerMainInvWrapper;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecipeItem
extends BlockItem {
    public static final ResourceLocation HAS_RECIPE_PROPERTY = new ResourceLocation("kaleidoscope_cookery", "has_recipe");
    public static final ResourceLocation POT = new ResourceLocation("kaleidoscope_cookery", "pot");
    public static final ResourceLocation STOCKPOT = new ResourceLocation("kaleidoscope_cookery", "stockpot");
    public static final String RECIPE_TAG = "RecipeRecord";
    public static final String INPUT = "input";
    public static final String OUTPUT = "output";
    public static final String TYPE = "type";
    private static final int NO_RECIPE = 0;
    private static final int HAS_RECIPE = 1;

    public RecipeItem() {
        super((Block)ModBlocks.RECIPE_BLOCK.get(), new Item.Properties());
    }

    public static void setRecipe(ItemStack stack, RecipeRecord record) {
        CompoundTag root = new CompoundTag();
        ListTag ingredients = new ListTag();
        for (ItemStack s : record.input()) {
            ingredients.add((Object)s.m_41739_(new CompoundTag()));
        }
        root.m_128365_(INPUT, (Tag)ingredients);
        root.m_128365_(OUTPUT, (Tag)record.output().m_41739_(new CompoundTag()));
        root.m_128359_(TYPE, record.type().toString());
        stack.m_41784_().m_128365_(RECIPE_TAG, (Tag)root);
    }

    @Nullable
    public static RecipeRecord getRecipe(ItemStack stack) {
        if (stack.m_41619_() || !(stack.m_41720_() instanceof RecipeItem)) {
            return null;
        }
        CompoundTag root = stack.m_41737_(RECIPE_TAG);
        if (root == null) {
            return null;
        }
        ArrayList inputs = Lists.newArrayList();
        ListTag list = root.m_128437_(INPUT, 10);
        for (int i = 0; i < list.size(); ++i) {
            inputs.add(ItemStack.m_41712_((CompoundTag)list.m_128728_(i)));
        }
        ItemStack output = ItemStack.m_41712_((CompoundTag)root.m_128469_(OUTPUT));
        ResourceLocation type = new ResourceLocation(root.m_128461_(TYPE));
        return new RecipeRecord(inputs, output, type);
    }

    public static boolean hasRecipe(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        return tag != null && tag.m_128441_(RECIPE_TAG);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getTexture(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        if (RecipeItem.hasRecipe(stack)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public Component m_7626_(ItemStack pStack) {
        RecipeRecord recipe;
        if (RecipeItem.hasRecipe(pStack) && (recipe = RecipeItem.getRecipe(pStack)) != null) {
            Component result = recipe.output().m_41786_();
            MutableComponent type = recipe.type().equals((Object)POT) ? Component.m_237115_((String)"block.kaleidoscope_cookery.pot") : (recipe.type().equals((Object)STOCKPOT) ? Component.m_237115_((String)"block.kaleidoscope_cookery.stockpot") : Component.m_237119_());
            return Component.m_237110_((String)"block.kaleidoscope_cookery.recipe_block.has_record", (Object[])new Object[]{result, type});
        }
        return super.m_7626_(pStack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack itemInHand = context.m_43722_();
        BlockPos clickedPos = context.m_8083_();
        BlockEntity blockEntity = context.m_43725_().m_7702_(clickedPos);
        RecipeManager recipeManager = context.m_43725_().m_7465_();
        if (blockEntity == null) {
            return super.m_6225_(context);
        }
        Player player = context.m_43723_();
        if (player == null) {
            return super.m_6225_(context);
        }
        if (RecipeItem.hasRecipe(itemInHand)) {
            return this.onPutRecipe(blockEntity, player, itemInHand);
        }
        InteractionHand hand = context.m_43724_();
        return this.onRecordRecipe(context.m_43725_(), player, blockEntity, recipeManager, itemInHand, hand);
    }

    private InteractionResult onPutRecipe(BlockEntity blockEntity, Player player, ItemStack itemInHand) {
        StockpotBlockEntity stockpot;
        PotBlockEntity pot;
        RecipeRecord record = RecipeItem.getRecipe(itemInHand);
        if (record == null) {
            return InteractionResult.PASS;
        }
        if (blockEntity instanceof PotBlockEntity && (pot = (PotBlockEntity)blockEntity).getStatus() == 0 && ((Boolean)pot.m_58900_().m_61143_((Property)PotBlock.HAS_OIL)).booleanValue() && record.type().equals((Object)POT)) {
            List<ItemStack> inputs = pot.getInputs().stream().filter(s -> !s.m_41619_()).toList();
            if (!inputs.isEmpty()) {
                return InteractionResult.PASS;
            }
            return this.handlePutRecipe(player, record, () -> pot.addAllIngredients(record.input(), (LivingEntity)player));
        }
        if (blockEntity instanceof StockpotBlockEntity && (stockpot = (StockpotBlockEntity)blockEntity).getStatus() == 1 && record.type().equals((Object)STOCKPOT)) {
            List<ItemStack> inputs = stockpot.getInputs().stream().filter(s -> !s.m_41619_()).toList();
            if (!inputs.isEmpty()) {
                return InteractionResult.PASS;
            }
            return this.handlePutRecipe(player, record, () -> stockpot.addAllIngredients(record.input(), (LivingEntity)player));
        }
        return InteractionResult.PASS;
    }

    @NotNull
    private InteractionResult handlePutRecipe(Player player, RecipeRecord record, Runnable success) {
        Reference2IntOpenHashMap need = new Reference2IntOpenHashMap();
        for (ItemStack s : record.input()) {
            if (s.m_41619_()) continue;
            Item item = s.m_41720_();
            need.put((Object)item, need.getInt((Object)item) + 1);
        }
        PlayerMainInvWrapper inventory = new PlayerMainInvWrapper(player.m_150109_());
        Reference2IntOpenHashMap supply = new Reference2IntOpenHashMap();
        for (int slot = 0; slot < inventory.getSlots(); ++slot) {
            ItemStack s = inventory.getStackInSlot(slot);
            if (s.m_41619_()) continue;
            RecipeItemEvent.CheckItem event = new RecipeItemEvent.CheckItem(s, (Reference2IntMap<Item>)supply);
            MinecraftForge.EVENT_BUS.post((Event)event);
            Item item = s.m_41720_();
            supply.put((Object)item, supply.getInt((Object)item) + s.m_41613_());
        }
        Reference2IntOpenHashMap missing = new Reference2IntOpenHashMap();
        for (Item item : need.keySet()) {
            if (supply.getInt((Object)item) >= need.getInt((Object)item)) continue;
            missing.put((Object)item, need.getInt((Object)item) - supply.getInt((Object)item));
        }
        if (!missing.isEmpty()) {
            MutableComponent component = Component.m_237115_((String)"tooltip.kaleidoscope_cookery.recipe_item.missing");
            int i = 0;
            for (Item s : missing.keySet()) {
                Component hoverName = s.m_7968_().m_41786_();
                MutableComponent count = Component.m_237113_((String)"\u00d7%d".formatted(missing.getInt((Object)s)));
                if (i != 0) {
                    component = component.m_7220_(CommonComponents.f_263701_);
                }
                component.m_7220_(CommonComponents.f_263701_).m_7220_(hoverName).m_7220_((Component)count);
                ++i;
            }
            if (!player.m_9236_().m_5776_()) {
                player.m_213846_((Component)component);
            }
            return InteractionResult.FAIL;
        }
        block4: for (Item item : need.keySet()) {
            int needCount = need.getInt((Object)item);
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack inSlot = inventory.getStackInSlot(i);
                if (inSlot.m_41619_()) continue;
                RecipeItemEvent.DeductItem event = new RecipeItemEvent.DeductItem(inSlot, item, new int[]{needCount});
                MinecraftForge.EVENT_BUS.post((Event)event);
                needCount = event.getNeedCount();
                if (needCount <= 0) continue block4;
                if (!inSlot.m_150930_(item)) continue;
                int extracted = Math.min(needCount, inSlot.m_41613_());
                inventory.extractItem(i, extracted, false);
                if ((needCount -= extracted) <= 0) continue block4;
            }
        }
        success.run();
        return InteractionResult.SUCCESS;
    }

    private InteractionResult onRecordRecipe(Level level, Player player, BlockEntity blockEntity, RecipeManager recipeManager, ItemStack itemInHand, InteractionHand hand) {
        StockpotBlockEntity stockpot;
        PotBlockEntity pot;
        if (blockEntity instanceof PotBlockEntity && (pot = (PotBlockEntity)blockEntity).getStatus() == 0) {
            List<ItemStack> inputs = pot.getInputs().stream().filter(s -> !s.m_41619_()).toList();
            if (inputs.isEmpty()) {
                return InteractionResult.PASS;
            }
            ItemStack recordStack = itemInHand.m_255036_(1);
            int count = itemInHand.m_41613_();
            if (count > 1) {
                ItemStack returnStack = itemInHand.m_255036_(count - 1);
                ItemUtils.getItemToLivingEntity((LivingEntity)player, returnStack);
            }
            recipeManager.m_44015_(ModRecipes.POT_RECIPE, (Container)pot.getContainer(), level).ifPresentOrElse(recipe -> {
                ItemStack resultItem = recipe.m_8043_(level.m_9598_());
                RecipeItem.setRecipe(recordStack, new RecipeRecord(inputs, resultItem, POT));
            }, () -> {
                ItemStack instance = FoodBiteRegistry.getItem(FoodBiteRegistry.SUSPICIOUS_STIR_FRY).m_7968_();
                RecipeItem.setRecipe(recordStack, new RecipeRecord(inputs, instance, POT));
            });
            player.m_21008_(hand, recordStack);
            return InteractionResult.SUCCESS;
        }
        if (blockEntity instanceof StockpotBlockEntity && (stockpot = (StockpotBlockEntity)blockEntity).getStatus() == 1) {
            List<ItemStack> inputs = stockpot.getInputs().stream().filter(s -> !s.m_41619_()).toList();
            if (inputs.isEmpty()) {
                return InteractionResult.PASS;
            }
            ItemStack recordStack = itemInHand.m_255036_(1);
            int count = itemInHand.m_41613_();
            if (count > 1) {
                ItemStack returnStack = itemInHand.m_255036_(count - 1);
                ItemUtils.getItemToLivingEntity((LivingEntity)player, returnStack);
            }
            recipeManager.m_44015_(ModRecipes.STOCKPOT_RECIPE, (Container)stockpot.getContainer(), level).ifPresentOrElse(recipe -> {
                ItemStack resultItem = recipe.m_8043_(level.m_9598_());
                RecipeItem.setRecipe(recordStack, new RecipeRecord(inputs, resultItem, STOCKPOT));
            }, () -> {
                ItemStack instance = Items.f_42718_.m_7968_();
                RecipeItem.setRecipe(recordStack, new RecipeRecord(inputs, instance, STOCKPOT));
            });
            player.m_21008_(hand, recordStack);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        if (RecipeItem.hasRecipe(stack)) {
            RecipeRecord recipe = RecipeItem.getRecipe(stack);
            if (recipe == null) {
                return Optional.empty();
            }
            return Optional.of(new RecipeItemTooltip(recipe));
        }
        return Optional.empty();
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.kaleidoscope_cookery.recipe_item").m_130940_(ChatFormatting.GRAY));
    }

    public record RecipeRecord(List<ItemStack> input, ItemStack output, ResourceLocation type) {
        public static RecipeRecord pot(ItemLike output, ItemLike ... input) {
            List<ItemStack> inputList = Arrays.stream(input).map(ItemStack::new).toList();
            return new RecipeRecord(inputList, new ItemStack(output), POT);
        }

        @SafeVarargs
        public static RecipeRecord pot(RegistryObject<Item> output, RegistryObject<Item> ... input) {
            List<ItemStack> inputList = Arrays.stream(input).map(s -> new ItemStack((ItemLike)s.get())).toList();
            return new RecipeRecord(inputList, new ItemStack((ItemLike)output.get()), POT);
        }

        public static RecipeRecord stockpot(ItemLike output, ItemLike ... input) {
            List<ItemStack> inputList = Arrays.stream(input).map(ItemStack::new).toList();
            return new RecipeRecord(inputList, new ItemStack(output), STOCKPOT);
        }

        @SafeVarargs
        public static RecipeRecord stockpot(RegistryObject<Item> output, RegistryObject<Item> ... input) {
            List<ItemStack> inputList = Arrays.stream(input).map(s -> new ItemStack((ItemLike)s.get())).toList();
            return new RecipeRecord(inputList, new ItemStack((ItemLike)output.get()), STOCKPOT);
        }
    }
}

