/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.item;

import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.decoration.FruitBasketBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.inventory.tooltip.ItemContainerTooltip;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TransmutationLunchBagItem
extends Item {
    public static final ResourceLocation HAS_ITEMS_PROPERTY = new ResourceLocation("kaleidoscope_cookery", "has_items");
    public static final int NO_ITEMS = 0;
    public static final int HAS_ITEMS = 1;
    private static final int MAX_SIZE = 16;
    private static final String TAG_ITEMS = "Items";

    public TransmutationLunchBagItem() {
        super(new Item.Properties().m_41487_(1));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getTexture(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        if (!TransmutationLunchBagItem.hasItems(stack)) {
            return 0.0f;
        }
        return 1.0f;
    }

    public static boolean hasItems(ItemStack bag) {
        CompoundTag tag = bag.m_41783_();
        return tag != null && tag.m_128425_(TAG_ITEMS, 10);
    }

    public static ItemStackHandler getItems(ItemStack bag) {
        ItemStackHandler handler = new ItemStackHandler(16);
        CompoundTag tag = bag.m_41784_();
        if (tag.m_128425_(TAG_ITEMS, 10)) {
            handler.deserializeNBT(tag.m_128469_(TAG_ITEMS));
        }
        return handler;
    }

    public static void setItems(ItemStack bag, ItemStackHandler items) {
        boolean allEmpty = true;
        for (int i = 0; i < items.getSlots(); ++i) {
            if (items.getStackInSlot(i).m_41619_()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            bag.m_41749_(TAG_ITEMS);
        } else {
            CompoundTag tag = bag.m_41784_();
            tag.m_128365_(TAG_ITEMS, (Tag)items.serializeNBT());
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        int i;
        BlockEntity blockEntity = context.m_43725_().m_7702_(context.m_8083_());
        if (!(blockEntity instanceof FruitBasketBlockEntity)) {
            return super.m_6225_(context);
        }
        FruitBasketBlockEntity fruitBasket = (FruitBasketBlockEntity)blockEntity;
        Player player = context.m_43723_();
        if (player == null) {
            return super.m_6225_(context);
        }
        ItemStack bag = context.m_43722_();
        ItemStackHandler bagItems = TransmutationLunchBagItem.getItems(bag);
        ItemStackHandler fruitBasketItems = fruitBasket.getItems();
        boolean basketEmpty = true;
        for (i = 0; i < fruitBasketItems.getSlots(); ++i) {
            if (fruitBasketItems.getStackInSlot(i).m_41619_()) continue;
            basketEmpty = false;
            break;
        }
        if (TransmutationLunchBagItem.hasItems(bag) && basketEmpty) {
            for (i = 0; i < bagItems.getSlots(); ++i) {
                ItemStack stack = bagItems.getStackInSlot(i);
                if (stack.m_41619_() || !stack.m_41720_().m_142095_()) continue;
                ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)fruitBasketItems, (ItemStack)stack, (boolean)false);
                bagItems.extractItem(i, stack.m_41613_() - remaining.m_41613_(), false);
            }
            TransmutationLunchBagItem.setItems(bag, bagItems);
            fruitBasket.refresh();
            this.playRemoveOneSound((Entity)player);
            return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
        }
        for (i = 0; i < fruitBasketItems.getSlots(); ++i) {
            ItemStack stack = fruitBasketItems.getStackInSlot(i);
            if (stack.m_41619_() || !TransmutationLunchBagItem.canAdd(stack)) continue;
            ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)bagItems, (ItemStack)stack, (boolean)false);
            fruitBasketItems.extractItem(i, stack.m_41613_() - remaining.m_41613_(), false);
        }
        TransmutationLunchBagItem.setItems(bag, bagItems);
        fruitBasket.refresh();
        this.playDropContentsSound((Entity)player);
        return InteractionResult.m_19078_((boolean)context.m_43725_().f_46443_);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).m_36341_() && TransmutationLunchBagItem.dropContents(stack, player)) {
            this.playDropContentsSound((Entity)player);
            return true;
        }
        return super.onEntitySwing(stack, entity);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        if (TransmutationLunchBagItem.hasItems(itemInHand)) {
            boolean hasFood = false;
            ItemStackHandler items = TransmutationLunchBagItem.getItems(itemInHand);
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack stackInSlot = items.getStackInSlot(i);
                if (stackInSlot.m_41619_()) continue;
                hasFood = true;
                break;
            }
            if (hasFood) {
                player.m_6672_(hand);
                return InteractionResultHolder.m_19096_((Object)itemInHand);
            }
        }
        return InteractionResultHolder.m_19100_((Object)itemInHand);
    }

    public ItemStack m_5922_(ItemStack bag, Level level, LivingEntity entity) {
        block14: {
            ItemStackHandler items;
            ArrayList effects;
            block17: {
                Item containerItem;
                block15: {
                    ItemStack returnStack;
                    block16: {
                        if (!TransmutationLunchBagItem.hasItems(bag)) {
                            return bag;
                        }
                        ItemStack food = ItemStack.f_41583_;
                        effects = Lists.newArrayList();
                        items = TransmutationLunchBagItem.getItems(bag);
                        for (int i = 0; i < items.getSlots(); ++i) {
                            ItemStack stackInSlot = items.getStackInSlot(i);
                            if (stackInSlot.m_41619_()) continue;
                            FoodProperties foodProperties = stackInSlot.m_41720_().getFoodProperties(stackInSlot, null);
                            if (foodProperties != null) {
                                if (!food.m_41619_()) {
                                    List foodEffects = foodProperties.m_38749_();
                                    effects.add(foodEffects);
                                    continue;
                                }
                                food = items.extractItem(i, 1, false);
                                continue;
                            }
                            if (!stackInSlot.m_150930_(Items.f_42589_)) continue;
                            if (!food.m_41619_()) {
                                ArrayList potionEffects = Lists.newArrayList();
                                PotionUtils.m_43547_((ItemStack)stackInSlot).forEach(e -> potionEffects.add(Pair.of((Object)e, (Object)Float.valueOf(1.0f))));
                                effects.add(potionEffects);
                                continue;
                            }
                            food = items.extractItem(i, 1, false);
                        }
                        if (food.m_41619_()) break block14;
                        returnStack = food.m_41671_(level, entity);
                        containerItem = ItemUtils.getContainerItem(food);
                        if (returnStack.m_41619_()) break block15;
                        if (!(entity instanceof Player)) break block16;
                        Player player = (Player)entity;
                        if (player.m_150110_().f_35937_) break block17;
                    }
                    ItemUtils.getItemToLivingEntity(entity, returnStack);
                    break block17;
                }
                if (containerItem != Items.f_41852_) {
                    ItemUtils.getItemToLivingEntity(entity, containerItem.m_7968_());
                }
            }
            boolean hasExtraEffects = false;
            Collections.shuffle(effects, new Random());
            int effectsToApply = Math.min(3, effects.size());
            for (int i = 0; i < effectsToApply; ++i) {
                List selected = (List)effects.get(i);
                for (Pair effect : selected) {
                    if (level.f_46443_ || ((Float)effect.getSecond()).floatValue() <= 0.0f || level.f_46441_.m_188501_() >= ((Float)effect.getSecond()).floatValue()) continue;
                    entity.m_7292_(new MobEffectInstance((MobEffectInstance)effect.getFirst()));
                    hasExtraEffects = true;
                }
            }
            if (hasExtraEffects) {
                IntArrayList foodSlots = new IntArrayList();
                for (int i = 0; i < items.getSlots(); ++i) {
                    ItemStack stackInSlot = items.getStackInSlot(i);
                    if (stackInSlot.m_41619_()) continue;
                    foodSlots.add(i);
                }
                if (!foodSlots.isEmpty()) {
                    int randomIndex = level.f_46441_.m_188503_(foodSlots.size());
                    int slotToExtract = foodSlots.getInt(randomIndex);
                    items.extractItem(slotToExtract, 1, false);
                }
            }
            if (entity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)entity;
                ModTrigger.EVENT.trigger((LivingEntity)player, "use_transmutation_lunch_bag");
            }
            TransmutationLunchBagItem.setItems(bag, items);
            return bag;
        }
        return bag;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return TransmutationLunchBagItem.hasItems(stack) ? UseAnim.EAT : UseAnim.NONE;
    }

    public int m_8105_(ItemStack stack) {
        return 32;
    }

    public boolean m_142207_(ItemStack bag, Slot slot, ClickAction action, Player player) {
        int addCount;
        if (bag.m_41613_() != 1 || action != ClickAction.SECONDARY) {
            return false;
        }
        ItemStack clickItem = slot.m_7993_();
        if (clickItem.m_41619_()) {
            this.playRemoveOneSound((Entity)player);
            TransmutationLunchBagItem.removeOne(bag).ifPresent(stack -> TransmutationLunchBagItem.add(bag, slot.m_150659_(stack)));
        } else if (clickItem.m_41720_().m_142095_() && TransmutationLunchBagItem.canAdd(clickItem) && (addCount = TransmutationLunchBagItem.add(bag, clickItem, true)) > 0) {
            ItemStack takeout = slot.m_150647_(clickItem.m_41613_(), addCount, player);
            if (!takeout.m_41619_()) {
                TransmutationLunchBagItem.add(bag, takeout);
            }
            this.playInsertSound((Entity)player);
        }
        return true;
    }

    public boolean m_142305_(ItemStack bag, ItemStack other, Slot slot, ClickAction action, Player player, SlotAccess access) {
        if (bag.m_41613_() != 1) {
            return false;
        }
        if (action != ClickAction.SECONDARY || !slot.m_150651_(player)) {
            return false;
        }
        if (other.m_41619_()) {
            TransmutationLunchBagItem.removeOne(bag).ifPresent(stack -> {
                this.playRemoveOneSound((Entity)player);
                access.m_142104_(stack);
            });
        } else {
            int added = TransmutationLunchBagItem.add(bag, other);
            if (added > 0) {
                this.playInsertSound((Entity)player);
                other.m_41774_(added);
            }
        }
        return true;
    }

    public static boolean canAdd(ItemStack food) {
        if (food.m_41619_()) {
            return false;
        }
        if (!food.m_41720_().m_142095_()) {
            return false;
        }
        return food.m_41720_().m_41472_() || food.m_150930_(Items.f_42589_);
    }

    private static Optional<ItemStack> removeOne(ItemStack bag) {
        if (!TransmutationLunchBagItem.hasItems(bag)) {
            return Optional.empty();
        }
        ItemStackHandler items = TransmutationLunchBagItem.getItems(bag);
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack extractItem = items.extractItem(i, items.getSlotLimit(i), false);
            if (extractItem.m_41619_()) continue;
            TransmutationLunchBagItem.setItems(bag, items);
            return Optional.of(extractItem);
        }
        return Optional.empty();
    }

    private static int add(ItemStack bag, ItemStack food) {
        return TransmutationLunchBagItem.add(bag, food, false);
    }

    private static int add(ItemStack bag, ItemStack food, boolean simulate) {
        if (food.m_41619_() || !food.m_41720_().m_142095_() || !TransmutationLunchBagItem.canAdd(food)) {
            return 0;
        }
        int totalCount = food.m_41613_();
        ItemStackHandler items = TransmutationLunchBagItem.getItems(bag);
        ItemStack remaining = ItemHandlerHelper.insertItemStacked((IItemHandler)items, (ItemStack)food, (boolean)simulate);
        int addCount = totalCount - (remaining.m_41619_() ? 0 : remaining.m_41613_());
        if (!simulate && addCount > 0) {
            TransmutationLunchBagItem.setItems(bag, items);
        }
        return addCount;
    }

    private static boolean dropContents(ItemStack bag, Player player) {
        if (!TransmutationLunchBagItem.hasItems(bag)) {
            return false;
        }
        boolean result = false;
        ItemStackHandler items = TransmutationLunchBagItem.getItems(bag);
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack stack = items.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack);
            result = true;
        }
        if (result) {
            items = new ItemStackHandler(16);
            TransmutationLunchBagItem.setItems(bag, items);
        }
        return result;
    }

    private void playRemoveOneSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playInsertSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    private void playDropContentsSound(Entity pEntity) {
        pEntity.m_5496_(SoundEvents.f_184214_, 0.8f, 0.8f + pEntity.m_9236_().m_213780_().m_188501_() * 0.4f);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack stack) {
        if (!TransmutationLunchBagItem.hasItems(stack)) {
            return Optional.empty();
        }
        ItemStackHandler items = TransmutationLunchBagItem.getItems(stack);
        return Optional.of(new ItemContainerTooltip((IItemHandler)items));
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.kaleidoscope_cookery.transmutation_lunch_bag").m_130940_(ChatFormatting.GRAY));
    }
}

