/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.mixin;

import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.SteamerBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.SteamerBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FallingBlockEntity.class})
public class FallingBlockEntityMixin {
    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/item/FallingBlockEntity;spawnAtLocation(Lnet/minecraft/world/level/ItemLike;)Lnet/minecraft/world/entity/item/ItemEntity;")}, cancellable=true)
    private void onSpawnAtLocation(CallbackInfo ci) {
        FallingBlockEntity self = (FallingBlockEntity)this;
        BlockState blockState = self.m_31980_();
        if (blockState.m_60713_((Block)ModBlocks.STEAMER.get())) {
            ci.cancel();
            List<ItemStack> drops = this.dropAsItem(blockState, self.f_31944_);
            for (ItemStack drop : drops) {
                self.m_19983_(drop);
            }
        }
    }

    public List<ItemStack> dropAsItem(BlockState blockState, @Nullable CompoundTag steamerTag) {
        NonNullList items = NonNullList.m_122780_((int)8, (Object)ItemStack.f_41583_);
        int[] cookingProgress = new int[8];
        int[] cookingTime = new int[8];
        if (steamerTag != null) {
            if (steamerTag.m_128425_("Items", 9)) {
                ContainerHelper.m_18980_((CompoundTag)steamerTag, (NonNullList)items);
            }
            if (steamerTag.m_128425_("CookingProgress", 11)) {
                cookingProgress = steamerTag.m_128465_("CookingProgress");
            }
            if (steamerTag.m_128425_("CookingTime", 11)) {
                cookingTime = steamerTag.m_128465_("CookingTime");
            }
        }
        ArrayList drops = Lists.newArrayList();
        boolean half = (Boolean)blockState.m_61143_((Property)SteamerBlock.HALF);
        ItemStack first = ((Item)ModItems.STEAMER.get()).m_7968_();
        if (items.stream().allMatch(ItemStack::m_41619_)) {
            drops.add(first);
            if (!half) {
                drops.add(((Item)ModItems.STEAMER.get()).m_7968_());
            }
            return drops;
        }
        CompoundTag tag1 = new CompoundTag();
        CompoundTag tag2 = new CompoundTag();
        SteamerBlockEntity.saveSplit(tag1, tag2, (NonNullList<ItemStack>)items, cookingProgress, cookingTime);
        BlockItem.m_186338_((ItemStack)first, (BlockEntityType)((BlockEntityType)ModBlocks.STEAMER_BE.get()), (CompoundTag)tag1);
        drops.add(first);
        if (!half) {
            ItemStack second = ((Item)ModItems.STEAMER.get()).m_7968_();
            BlockItem.m_186338_((ItemStack)second, (BlockEntityType)((BlockEntityType)ModBlocks.STEAMER_BE.get()), (CompoundTag)tag2);
            drops.add(second);
        }
        return drops;
    }
}

