/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.network.message;

import com.github.ysbbbbbb.kaleidoscopecookery.entity.ThrowableBaoziEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModEffects;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSounds;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public record SimpleC2SModMessage(int index) {
    public static final int FLATULENCE = 0;
    public static final int THROW_BAOZI = 1;

    public static void encode(SimpleC2SModMessage message, FriendlyByteBuf buf) {
        buf.m_130130_(message.index);
    }

    public static SimpleC2SModMessage decode(FriendlyByteBuf buf) {
        return new SimpleC2SModMessage(buf.m_130242_());
    }

    public static void handle(SimpleC2SModMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        if (context.getDirection().getReceptionSide().isServer()) {
            context.enqueueWork(() -> SimpleC2SModMessage.onHandle(context, message.index));
        }
        context.setPacketHandled(true);
    }

    private static void onHandle(NetworkEvent.Context context, int index) {
        if (index == 0) {
            SimpleC2SModMessage.handleFlatulenceEffect(context);
        }
        if (index == 1) {
            SimpleC2SModMessage.handleBaozi(context);
        }
    }

    private static void handleFlatulenceEffect(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player != null && player.m_21023_((MobEffect)ModEffects.FLATULENCE.get())) {
            ServerLevel serverLevel = player.m_284548_();
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, player.m_20185_(), player.m_20186_() + 0.25, player.m_20189_(), 10, 0.25, 0.25, 0.25, 0.1);
            serverLevel.m_5594_(null, player.m_20183_(), (SoundEvent)ModSounds.ENTITY_FART.get(), SoundSource.PLAYERS, 1.0f, 0.8f + (float)Math.random() * 0.4f);
        }
    }

    private static void handleBaozi(NetworkEvent.Context context) {
        ServerPlayer player = context.getSender();
        if (player == null || !player.m_21205_().m_150930_((Item)ModItems.BAOZI.get()) || !player.m_36341_()) {
            return;
        }
        ItemStack stack = player.m_21205_();
        Level level = player.m_9236_();
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12473_, SoundSource.NEUTRAL, 0.5f, 0.4f / (level.m_213780_().m_188501_() * 0.4f + 0.8f));
        ThrowableBaoziEntity baozi = new ThrowableBaoziEntity(level, (LivingEntity)player);
        baozi.m_37446_(stack.m_255036_(1));
        baozi.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
        level.m_7967_((Entity)baozi);
        stack.m_41774_(1);
    }
}

