package com.github.ysbbbbbb.kaleidoscopecookery.datagen.tag;

import com.github.ysbbbbbb.kaleidoscopecookery.KaleidoscopeCookery;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagCommon;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.Nullable;

import java.util.concurrent.CompletableFuture;

import static com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagCommon.FD_KNIVES;
import static com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod.*;
import static net.minecraft.tags.ItemTags.VILLAGER_PLANTABLE_SEEDS;
import static net.minecraft.world.item.Items.*;

public class TagItem extends ItemTagsProvider {
    public TagItem(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pLookupProvider,
                   CompletableFuture<TagLookup<Block>> pBlockTags, @Nullable ExistingFileHelper existingFileHelper) {
        super(pOutput, pLookupProvider, pBlockTags, KaleidoscopeCookery.MOD_ID, existingFileHelper);
    }

    @Override
    protected void addTags(HolderLookup.Provider provider) {
        // 模组 tag
        tag(OIL).add(ModItems.OIL.get());
        tag(LIT_STOVE).add(FLINT_AND_STEEL, FIRE_CHARGE);
        tag(STRAW_HAT).add(ModItems.STRAW_HAT.get(),
                ModItems.STRAW_HAT_FLOWER.get());

        tag(KITCHEN_KNIFE).add(ModItems.IRON_KITCHEN_KNIFE.get(),
                        ModItems.GOLD_KITCHEN_KNIFE.get(),
                        ModItems.DIAMOND_KITCHEN_KNIFE.get(),
                        ModItems.NETHERITE_KITCHEN_KNIFE.get())
                .addOptionalTag(ResourceLocation.parse("farmersdelight:tools/knives"));

        tag(KITCHEN_SHOVEL).add(ModItems.KITCHEN_SHOVEL.get());

        // 农夫乐事
        tag(FD_KNIVES).add(ModItems.IRON_KITCHEN_KNIFE.get(),
                ModItems.GOLD_KITCHEN_KNIFE.get(),
                ModItems.DIAMOND_KITCHEN_KNIFE.get(),
                ModItems.NETHERITE_KITCHEN_KNIFE.get());

        tag(FARMER_ARMOR).add(ModItems.FARMER_CHEST_PLATE.get(),
                        ModItems.FARMER_LEGGINGS.get(),
                        ModItems.FARMER_BOOTS.get())
                .addTag(STRAW_HAT);
        this.tag(TagMod.STRAW_BALE).add(HAY_BLOCK, ModItems.STRAW_BLOCK.get());

        this.tag(COOKERY_MOD_SEEDS).add(
                ModItems.TOMATO_SEED.get(), ModItems.CHILI_SEED.get(),
                ModItems.WILD_RICE_SEED.get(), ModItems.LETTUCE_SEED.get()
        );

        this.tag(INGREDIENT_CONTAINER).add(BUCKET, BOWL, GLASS_BOTTLE);
        this.tag(GLASS_BOTTLE_CONTAINER).add(HONEY_BOTTLE);
        this.tag(BUCKET_CONTAINER).add(WATER_BUCKET, LAVA_BUCKET, MILK_BUCKET,
                SALMON_BUCKET, COD_BUCKET, TROPICAL_FISH_BUCKET, PUFFERFISH_BUCKET,
                AXOLOTL_BUCKET, TADPOLE_BUCKET, POWDER_SNOW_BUCKET);
        this.tag(MILLSTONE_DOUGH_CONTAINER).add(WATER_BUCKET);

        this.addModItems();
        this.addPotIngredient();

        // 原版兼容
        tag(ItemTags.SHOVELS).add(ModItems.KITCHEN_SHOVEL.get());
        tag(ItemTags.SWORDS).addTag(KITCHEN_KNIFE);
        tag(EXTINGUISH_STOVE).addTag(ItemTags.SHOVELS);
        tag(VILLAGER_PLANTABLE_SEEDS).add(ModItems.TOMATO_SEED.get(),
                ModItems.CHILI_SEED.get(), ModItems.LETTUCE_SEED.get()
        );
        tag(Tags.Items.SEEDS).add(ModItems.TOMATO_SEED.get(), ModItems.CHILI_SEED.get(),
                ModItems.LETTUCE_SEED.get());

        // 社区兼容
        tag(TagCommon.CROPS_CHILI_PEPPER).add(ModItems.RED_CHILI.get(), ModItems.GREEN_CHILI.get());
        tag(TagCommon.CROPS_TOMATO).add(ModItems.TOMATO.get());
        tag(TagCommon.CROPS_LETTUCE).add(ModItems.LETTUCE.get());
        tag(TagCommon.CROPS_RICE).add(ModItems.RICE_SEED.get());
        tag(TagCommon.CROPS).addTag(TagCommon.CROPS_CHILI_PEPPER)
                .addTag(TagCommon.CROPS_TOMATO)
                .addTag(TagCommon.CROPS_LETTUCE)
                .addTag(TagCommon.CROPS_RICE);

        tag(TagCommon.VEGETABLES_CHILI_PEPPER).add(ModItems.RED_CHILI.get(), ModItems.GREEN_CHILI.get());
        tag(TagCommon.VEGETABLES_TOMATO).add(ModItems.TOMATO.get());
        tag(TagCommon.VEGETABLES_LETTUCE).add(ModItems.LETTUCE.get());
        tag(TagCommon.VEGETABLES).addTag(TagCommon.VEGETABLES_CHILI_PEPPER)
                .addTag(TagCommon.VEGETABLES_TOMATO)
                .addTag(TagCommon.VEGETABLES_LETTUCE);

        tag(TagCommon.SEEDS_CHILI_PEPPER).add(ModItems.CHILI_SEED.get());
        tag(TagCommon.SEEDS_TOMATO).add(ModItems.TOMATO_SEED.get());
        tag(TagCommon.SEEDS_LETTUCE).add(ModItems.LETTUCE_SEED.get());
        tag(TagCommon.SEEDS_RICE).add(ModItems.RICE_SEED.get());

        tag(TagCommon.GRAIN_RICE).add(ModItems.RICE_SEED.get());

        tag(TagCommon.COOKED_BEEF).add(ModItems.COOKED_COW_OFFAL.get(), COOKED_BEEF);
        tag(TagCommon.COOKED_PORK).add(ModItems.COOKED_PORK_BELLY.get(), COOKED_PORKCHOP);
        tag(TagCommon.COOKED_MUTTON).add(ModItems.COOKED_LAMB_CHOPS.get(), COOKED_MUTTON);
        tag(TagCommon.COOKED_EGGS).add(ModItems.FRIED_EGG.get());
        tag(TagCommon.COOKED_RICE).add(ModItems.COOKED_RICE.get());

        tag(TagCommon.RAW_BEEF).add(ModItems.RAW_COW_OFFAL.get(), BEEF);
        tag(TagCommon.RAW_CHICKEN).add(CHICKEN);
        tag(TagCommon.RAW_PORK).add(ModItems.RAW_PORK_BELLY.get(), PORKCHOP);
        tag(TagCommon.RAW_MUTTON).add(ModItems.RAW_LAMB_CHOPS.get(), MUTTON);
        tag(Tags.Items.EGGS).add(EGG, TURTLE_EGG);
        tag(TagCommon.RAW_FISHES_TROPICAL).add(ModItems.SASHIMI.get());
        tag(TagCommon.RAW_FISHES_COD).add(COD);
        tag(TagCommon.RAW_FISHES_SALMON).add(SALMON);

        tag(TagCommon.RAW_MEATS).addTag(TagCommon.RAW_BEEF)
                .addTag(TagCommon.RAW_CHICKEN)
                .addTag(TagCommon.RAW_PORK)
                .addTag(TagCommon.RAW_MUTTON)
                .addTag(TagCommon.RAW_FISHES_COD)
                .addTag(TagCommon.RAW_FISHES_SALMON)
                .addTag(TagCommon.RAW_FISHES_TROPICAL);

        tag(TagCommon.DOUGH).add(ModItems.RAW_DOUGH.get());

        // 均衡饮食兼容
        tag(TagCommon.GRAINS).add(ModItems.RICE_SEED.get(), ModItems.RICE_PANICLE.get());
        tag(TagCommon.PROTEINS).add(ModItems.CATERPILLAR.get());
        tag(TagCommon.DIET_VEGETABLES).addTag(TagCommon.VEGETABLES);

        // 兼容静谧四季
        tag(TagCommon.SPRING_CROPS).add(ModItems.LETTUCE_SEED.get());
        tag(TagCommon.SUMMER_CROPS).add(ModItems.TOMATO_SEED.get(), ModItems.CHILI_SEED.get(), ModItems.RICE_SEED.get(), ModItems.WILD_RICE_SEED.get());
        tag(TagCommon.AUTUMN_CROPS).add(ModItems.TOMATO_SEED.get(), ModItems.CHILI_SEED.get(), ModItems.LETTUCE_SEED.get(), ModItems.RICE_SEED.get(), ModItems.WILD_RICE_SEED.get());
    }

    private void addModItems() {
        IntrinsicTagAppender<Item> modTags = tag(COOKERY_MOD_ITEMS);
        for (Item item : BuiltInRegistries.ITEM) {
            ResourceLocation itemId = BuiltInRegistries.ITEM.getKey(item);
            if (itemId.getNamespace().equals(KaleidoscopeCookery.MOD_ID)) {
                modTags.add(item);
            }
        }
    }

    private void addPotIngredient() {
        tag(POT_INGREDIENT)
                .addTags(
                        TagCommon.GRAIN_RICE,
                        TagCommon.CROPS_CHILI_PEPPER,
                        TagCommon.CROPS_TOMATO,
                        TagCommon.CROPS_LETTUCE,
                        TagCommon.CROPS_RICE,
                        TagCommon.VEGETABLES_CHILI_PEPPER,
                        TagCommon.VEGETABLES_TOMATO,
                        TagCommon.VEGETABLES_LETTUCE,
                        TagCommon.SEEDS_CHILI_PEPPER,
                        TagCommon.SEEDS_TOMATO,
                        TagCommon.SEEDS_LETTUCE,
                        TagCommon.SEEDS_RICE,
                        Tags.Items.EGGS
                ).add(
                        ModItems.RAW_DOUGH.get(),
                        ModItems.RAW_NOODLES.get(),
                        ModItems.STUFFED_DOUGH_FOOD.get()
                ).add(
                        STONE,
                        GRANITE,
                        POLISHED_GRANITE,
                        DIORITE,
                        POLISHED_DIORITE,
                        ANDESITE,
                        POLISHED_ANDESITE,
                        DEEPSLATE,
                        COBBLED_DEEPSLATE,
                        POLISHED_DEEPSLATE,
                        CALCITE,
                        TUFF,
                        DRIPSTONE_BLOCK,
                        GRASS_BLOCK,
                        DIRT,
                        COARSE_DIRT,
                        PODZOL,
                        ROOTED_DIRT,
                        MUD,
                        CRIMSON_NYLIUM,
                        WARPED_NYLIUM,
                        COBBLESTONE,
                        OAK_PLANKS,
                        SPRUCE_PLANKS,
                        BIRCH_PLANKS,
                        JUNGLE_PLANKS,
                        ACACIA_PLANKS,
                        CHERRY_PLANKS,
                        DARK_OAK_PLANKS,
                        MANGROVE_PLANKS,
                        BAMBOO_PLANKS,
                        CRIMSON_PLANKS,
                        WARPED_PLANKS,
                        BAMBOO_MOSAIC,
                        OAK_SAPLING,
                        SPRUCE_SAPLING,
                        BIRCH_SAPLING,
                        JUNGLE_SAPLING,
                        ACACIA_SAPLING,
                        CHERRY_SAPLING,
                        DARK_OAK_SAPLING,
                        MANGROVE_PROPAGULE,
                        SAND,
                        SUSPICIOUS_SAND,
                        SUSPICIOUS_GRAVEL,
                        RED_SAND,
                        GRAVEL,
                        COAL_ORE,
                        DEEPSLATE_COAL_ORE,
                        IRON_ORE,
                        DEEPSLATE_IRON_ORE,
                        COPPER_ORE,
                        DEEPSLATE_COPPER_ORE,
                        GOLD_ORE,
                        DEEPSLATE_GOLD_ORE,
                        REDSTONE_ORE,
                        DEEPSLATE_REDSTONE_ORE,
                        EMERALD_ORE,
                        DEEPSLATE_EMERALD_ORE,
                        LAPIS_ORE,
                        DEEPSLATE_LAPIS_ORE,
                        DIAMOND_ORE,
                        DEEPSLATE_DIAMOND_ORE,
                        NETHER_GOLD_ORE,
                        NETHER_QUARTZ_ORE,
                        ANCIENT_DEBRIS,
                        COAL_BLOCK,
                        RAW_IRON_BLOCK,
                        RAW_COPPER_BLOCK,
                        RAW_GOLD_BLOCK,
                        AMETHYST_BLOCK,
                        BUDDING_AMETHYST,
                        IRON_BLOCK,
                        COPPER_BLOCK,
                        GOLD_BLOCK,
                        DIAMOND_BLOCK,
                        NETHERITE_BLOCK,
                        EXPOSED_COPPER,
                        WEATHERED_COPPER,
                        OXIDIZED_COPPER,
                        CUT_COPPER,
                        EXPOSED_CUT_COPPER,
                        WEATHERED_CUT_COPPER,
                        OXIDIZED_CUT_COPPER,
                        CUT_COPPER_STAIRS,
                        EXPOSED_CUT_COPPER_STAIRS,
                        WEATHERED_CUT_COPPER_STAIRS,
                        OXIDIZED_CUT_COPPER_STAIRS,
                        CUT_COPPER_SLAB,
                        EXPOSED_CUT_COPPER_SLAB,
                        WEATHERED_CUT_COPPER_SLAB,
                        OXIDIZED_CUT_COPPER_SLAB,
                        WAXED_COPPER_BLOCK,
                        WAXED_EXPOSED_COPPER,
                        WAXED_WEATHERED_COPPER,
                        WAXED_OXIDIZED_COPPER,
                        WAXED_CUT_COPPER,
                        WAXED_EXPOSED_CUT_COPPER,
                        WAXED_WEATHERED_CUT_COPPER,
                        WAXED_OXIDIZED_CUT_COPPER,
                        WAXED_CUT_COPPER_STAIRS,
                        WAXED_EXPOSED_CUT_COPPER_STAIRS,
                        WAXED_WEATHERED_CUT_COPPER_STAIRS,
                        WAXED_OXIDIZED_CUT_COPPER_STAIRS,
                        WAXED_CUT_COPPER_SLAB,
                        WAXED_EXPOSED_CUT_COPPER_SLAB,
                        WAXED_WEATHERED_CUT_COPPER_SLAB,
                        WAXED_OXIDIZED_CUT_COPPER_SLAB,
                        OAK_LOG,
                        SPRUCE_LOG,
                        BIRCH_LOG,
                        JUNGLE_LOG,
                        ACACIA_LOG,
                        CHERRY_LOG,
                        DARK_OAK_LOG,
                        MANGROVE_LOG,
                        MANGROVE_ROOTS,
                        MUDDY_MANGROVE_ROOTS,
                        CRIMSON_STEM,
                        WARPED_STEM,
                        BAMBOO_BLOCK,
                        STRIPPED_OAK_LOG,
                        STRIPPED_SPRUCE_LOG,
                        STRIPPED_BIRCH_LOG,
                        STRIPPED_JUNGLE_LOG,
                        STRIPPED_ACACIA_LOG,
                        STRIPPED_CHERRY_LOG,
                        STRIPPED_DARK_OAK_LOG,
                        STRIPPED_MANGROVE_LOG,
                        STRIPPED_CRIMSON_STEM,
                        STRIPPED_WARPED_STEM,
                        STRIPPED_OAK_WOOD,
                        STRIPPED_SPRUCE_WOOD,
                        STRIPPED_BIRCH_WOOD,
                        STRIPPED_JUNGLE_WOOD,
                        STRIPPED_ACACIA_WOOD,
                        STRIPPED_CHERRY_WOOD,
                        STRIPPED_DARK_OAK_WOOD,
                        STRIPPED_MANGROVE_WOOD,
                        STRIPPED_CRIMSON_HYPHAE,
                        STRIPPED_WARPED_HYPHAE,
                        STRIPPED_BAMBOO_BLOCK,
                        OAK_WOOD,
                        SPRUCE_WOOD,
                        BIRCH_WOOD,
                        JUNGLE_WOOD,
                        ACACIA_WOOD,
                        CHERRY_WOOD,
                        DARK_OAK_WOOD,
                        MANGROVE_WOOD,
                        CRIMSON_HYPHAE,
                        WARPED_HYPHAE,
                        OAK_LEAVES,
                        SPRUCE_LEAVES,
                        BIRCH_LEAVES,
                        JUNGLE_LEAVES,
                        ACACIA_LEAVES,
                        CHERRY_LEAVES,
                        DARK_OAK_LEAVES,
                        MANGROVE_LEAVES,
                        AZALEA_LEAVES,
                        FLOWERING_AZALEA_LEAVES,
                        SPONGE,
                        WET_SPONGE,
                        GLASS,
                        TINTED_GLASS,
                        LAPIS_BLOCK,
                        SANDSTONE,
                        CHISELED_SANDSTONE,
                        CUT_SANDSTONE,
                        COBWEB,
                        SHORT_GRASS,
                        FERN,
                        AZALEA,
                        FLOWERING_AZALEA,
                        DEAD_BUSH,
                        SEAGRASS,
                        SEA_PICKLE,
                        WHITE_WOOL,
                        ORANGE_WOOL,
                        MAGENTA_WOOL,
                        LIGHT_BLUE_WOOL,
                        YELLOW_WOOL,
                        LIME_WOOL,
                        PINK_WOOL,
                        GRAY_WOOL,
                        LIGHT_GRAY_WOOL,
                        CYAN_WOOL,
                        PURPLE_WOOL,
                        BLUE_WOOL,
                        BROWN_WOOL,
                        GREEN_WOOL,
                        RED_WOOL,
                        BLACK_WOOL,
                        DANDELION,
                        POPPY,
                        BLUE_ORCHID,
                        ALLIUM,
                        AZURE_BLUET,
                        RED_TULIP,
                        ORANGE_TULIP,
                        WHITE_TULIP,
                        PINK_TULIP,
                        OXEYE_DAISY,
                        CORNFLOWER,
                        LILY_OF_THE_VALLEY,
                        WITHER_ROSE,
                        TORCHFLOWER,
                        PITCHER_PLANT,
                        SPORE_BLOSSOM,
                        BROWN_MUSHROOM,
                        RED_MUSHROOM,
                        CRIMSON_FUNGUS,
                        WARPED_FUNGUS,
                        CRIMSON_ROOTS,
                        WARPED_ROOTS,
                        NETHER_SPROUTS,
                        WEEPING_VINES,
                        TWISTING_VINES,
                        SUGAR_CANE,
                        KELP,
                        MOSS_CARPET,
                        PINK_PETALS,
                        MOSS_BLOCK,
                        HANGING_ROOTS,
                        BIG_DRIPLEAF,
                        SMALL_DRIPLEAF,
                        BAMBOO,
                        OAK_SLAB,
                        SPRUCE_SLAB,
                        BIRCH_SLAB,
                        JUNGLE_SLAB,
                        ACACIA_SLAB,
                        CHERRY_SLAB,
                        DARK_OAK_SLAB,
                        MANGROVE_SLAB,
                        BAMBOO_SLAB,
                        BAMBOO_MOSAIC_SLAB,
                        CRIMSON_SLAB,
                        WARPED_SLAB,
                        STONE_SLAB,
                        SMOOTH_STONE_SLAB,
                        SANDSTONE_SLAB,
                        CUT_STANDSTONE_SLAB,
                        PETRIFIED_OAK_SLAB,
                        COBBLESTONE_SLAB,
                        BRICK_SLAB,
                        STONE_BRICK_SLAB,
                        MUD_BRICK_SLAB,
                        NETHER_BRICK_SLAB,
                        QUARTZ_SLAB,
                        RED_SANDSTONE_SLAB,
                        CUT_RED_SANDSTONE_SLAB,
                        PURPUR_SLAB,
                        PRISMARINE_SLAB,
                        PRISMARINE_BRICK_SLAB,
                        DARK_PRISMARINE_SLAB,
                        SMOOTH_QUARTZ,
                        SMOOTH_RED_SANDSTONE,
                        SMOOTH_SANDSTONE,
                        SMOOTH_STONE,
                        BRICKS,
                        BOOKSHELF,
                        CHISELED_BOOKSHELF,
                        DECORATED_POT,
                        MOSSY_COBBLESTONE,
                        OBSIDIAN,
                        TORCH,
                        END_ROD,
                        CHORUS_PLANT,
                        CHORUS_FLOWER,
                        PURPUR_BLOCK,
                        PURPUR_PILLAR,
                        PURPUR_STAIRS,
                        SPAWNER,
                        CHEST,
                        CRAFTING_TABLE,
                        FARMLAND,
                        FURNACE,
                        LADDER,
                        COBBLESTONE_STAIRS,
                        SNOW,
                        ICE,
                        SNOW_BLOCK,
                        CACTUS,
                        CLAY,
                        JUKEBOX,
                        OAK_FENCE,
                        SPRUCE_FENCE,
                        BIRCH_FENCE,
                        JUNGLE_FENCE,
                        ACACIA_FENCE,
                        CHERRY_FENCE,
                        DARK_OAK_FENCE,
                        MANGROVE_FENCE,
                        BAMBOO_FENCE,
                        CRIMSON_FENCE,
                        WARPED_FENCE,
                        PUMPKIN,
                        CARVED_PUMPKIN,
                        JACK_O_LANTERN,
                        NETHERRACK,
                        SOUL_SAND,
                        SOUL_SOIL,
                        BASALT,
                        POLISHED_BASALT,
                        SMOOTH_BASALT,
                        SOUL_TORCH,
                        GLOWSTONE,
                        INFESTED_STONE,
                        INFESTED_COBBLESTONE,
                        INFESTED_STONE_BRICKS,
                        INFESTED_MOSSY_STONE_BRICKS,
                        INFESTED_CRACKED_STONE_BRICKS,
                        INFESTED_CHISELED_STONE_BRICKS,
                        INFESTED_DEEPSLATE,
                        STONE_BRICKS,
                        MOSSY_STONE_BRICKS,
                        CRACKED_STONE_BRICKS,
                        CHISELED_STONE_BRICKS,
                        PACKED_MUD,
                        MUD_BRICKS,
                        DEEPSLATE_BRICKS,
                        CRACKED_DEEPSLATE_BRICKS,
                        DEEPSLATE_TILES,
                        CRACKED_DEEPSLATE_TILES,
                        CHISELED_DEEPSLATE,
                        REINFORCED_DEEPSLATE,
                        BROWN_MUSHROOM_BLOCK,
                        RED_MUSHROOM_BLOCK,
                        MUSHROOM_STEM,
                        IRON_BARS,
                        CHAIN,
                        GLASS_PANE,
                        MELON,
                        VINE,
                        GLOW_LICHEN,
                        BRICK_STAIRS,
                        STONE_BRICK_STAIRS,
                        MUD_BRICK_STAIRS,
                        MYCELIUM,
                        LILY_PAD,
                        NETHER_BRICKS,
                        CRACKED_NETHER_BRICKS,
                        CHISELED_NETHER_BRICKS,
                        NETHER_BRICK_FENCE,
                        NETHER_BRICK_STAIRS,
                        SCULK,
                        SCULK_VEIN,
                        SCULK_CATALYST,
                        SCULK_SHRIEKER,
                        ENCHANTING_TABLE,
                        END_PORTAL_FRAME,
                        END_STONE,
                        END_STONE_BRICKS,
                        DRAGON_EGG,
                        SANDSTONE_STAIRS,
                        ENDER_CHEST,
                        EMERALD_BLOCK,
                        OAK_STAIRS,
                        SPRUCE_STAIRS,
                        BIRCH_STAIRS,
                        JUNGLE_STAIRS,
                        ACACIA_STAIRS,
                        CHERRY_STAIRS,
                        DARK_OAK_STAIRS,
                        MANGROVE_STAIRS,
                        BAMBOO_STAIRS,
                        BAMBOO_MOSAIC_STAIRS,
                        CRIMSON_STAIRS,
                        WARPED_STAIRS,
                        BEACON,
                        COBBLESTONE_WALL,
                        MOSSY_COBBLESTONE_WALL,
                        BRICK_WALL,
                        PRISMARINE_WALL,
                        RED_SANDSTONE_WALL,
                        MOSSY_STONE_BRICK_WALL,
                        GRANITE_WALL,
                        STONE_BRICK_WALL,
                        MUD_BRICK_WALL,
                        NETHER_BRICK_WALL,
                        ANDESITE_WALL,
                        RED_NETHER_BRICK_WALL,
                        SANDSTONE_WALL,
                        END_STONE_BRICK_WALL,
                        DIORITE_WALL,
                        BLACKSTONE_WALL,
                        POLISHED_BLACKSTONE_WALL,
                        POLISHED_BLACKSTONE_BRICK_WALL,
                        COBBLED_DEEPSLATE_WALL,
                        POLISHED_DEEPSLATE_WALL,
                        DEEPSLATE_BRICK_WALL,
                        DEEPSLATE_TILE_WALL,
                        ANVIL,
                        CHIPPED_ANVIL,
                        DAMAGED_ANVIL,
                        CHISELED_QUARTZ_BLOCK,
                        QUARTZ_BLOCK,
                        QUARTZ_BRICKS,
                        QUARTZ_PILLAR,
                        QUARTZ_STAIRS,
                        WHITE_TERRACOTTA,
                        ORANGE_TERRACOTTA,
                        MAGENTA_TERRACOTTA,
                        LIGHT_BLUE_TERRACOTTA,
                        YELLOW_TERRACOTTA,
                        LIME_TERRACOTTA,
                        PINK_TERRACOTTA,
                        GRAY_TERRACOTTA,
                        LIGHT_GRAY_TERRACOTTA,
                        CYAN_TERRACOTTA,
                        PURPLE_TERRACOTTA,
                        BLUE_TERRACOTTA,
                        BROWN_TERRACOTTA,
                        GREEN_TERRACOTTA,
                        RED_TERRACOTTA,
                        BLACK_TERRACOTTA,
                        HAY_BLOCK,
                        WHITE_CARPET,
                        ORANGE_CARPET,
                        MAGENTA_CARPET,
                        LIGHT_BLUE_CARPET,
                        YELLOW_CARPET,
                        LIME_CARPET,
                        PINK_CARPET,
                        GRAY_CARPET,
                        LIGHT_GRAY_CARPET,
                        CYAN_CARPET,
                        PURPLE_CARPET,
                        BLUE_CARPET,
                        BROWN_CARPET,
                        GREEN_CARPET,
                        RED_CARPET,
                        BLACK_CARPET,
                        TERRACOTTA,
                        PACKED_ICE,
                        DIRT_PATH,
                        SUNFLOWER,
                        LILAC,
                        ROSE_BUSH,
                        PEONY,
                        TALL_GRASS,
                        LARGE_FERN,
                        WHITE_STAINED_GLASS,
                        ORANGE_STAINED_GLASS,
                        MAGENTA_STAINED_GLASS,
                        LIGHT_BLUE_STAINED_GLASS,
                        YELLOW_STAINED_GLASS,
                        LIME_STAINED_GLASS,
                        PINK_STAINED_GLASS,
                        GRAY_STAINED_GLASS,
                        LIGHT_GRAY_STAINED_GLASS,
                        CYAN_STAINED_GLASS,
                        PURPLE_STAINED_GLASS,
                        BLUE_STAINED_GLASS,
                        BROWN_STAINED_GLASS,
                        GREEN_STAINED_GLASS,
                        RED_STAINED_GLASS,
                        BLACK_STAINED_GLASS,
                        WHITE_STAINED_GLASS_PANE,
                        ORANGE_STAINED_GLASS_PANE,
                        MAGENTA_STAINED_GLASS_PANE,
                        LIGHT_BLUE_STAINED_GLASS_PANE,
                        YELLOW_STAINED_GLASS_PANE,
                        LIME_STAINED_GLASS_PANE,
                        PINK_STAINED_GLASS_PANE,
                        GRAY_STAINED_GLASS_PANE,
                        LIGHT_GRAY_STAINED_GLASS_PANE,
                        CYAN_STAINED_GLASS_PANE,
                        PURPLE_STAINED_GLASS_PANE,
                        BLUE_STAINED_GLASS_PANE,
                        BROWN_STAINED_GLASS_PANE,
                        GREEN_STAINED_GLASS_PANE,
                        RED_STAINED_GLASS_PANE,
                        BLACK_STAINED_GLASS_PANE,
                        PRISMARINE,
                        PRISMARINE_BRICKS,
                        DARK_PRISMARINE,
                        PRISMARINE_STAIRS,
                        PRISMARINE_BRICK_STAIRS,
                        DARK_PRISMARINE_STAIRS,
                        SEA_LANTERN,
                        RED_SANDSTONE,
                        CHISELED_RED_SANDSTONE,
                        CUT_RED_SANDSTONE,
                        RED_SANDSTONE_STAIRS,
                        MAGMA_BLOCK,
                        NETHER_WART_BLOCK,
                        WARPED_WART_BLOCK,
                        RED_NETHER_BRICKS,
                        BONE_BLOCK,
                        WHITE_GLAZED_TERRACOTTA,
                        ORANGE_GLAZED_TERRACOTTA,
                        MAGENTA_GLAZED_TERRACOTTA,
                        LIGHT_BLUE_GLAZED_TERRACOTTA,
                        YELLOW_GLAZED_TERRACOTTA,
                        LIME_GLAZED_TERRACOTTA,
                        PINK_GLAZED_TERRACOTTA,
                        GRAY_GLAZED_TERRACOTTA,
                        LIGHT_GRAY_GLAZED_TERRACOTTA,
                        CYAN_GLAZED_TERRACOTTA,
                        PURPLE_GLAZED_TERRACOTTA,
                        BLUE_GLAZED_TERRACOTTA,
                        BROWN_GLAZED_TERRACOTTA,
                        GREEN_GLAZED_TERRACOTTA,
                        RED_GLAZED_TERRACOTTA,
                        BLACK_GLAZED_TERRACOTTA,
                        WHITE_CONCRETE,
                        ORANGE_CONCRETE,
                        MAGENTA_CONCRETE,
                        LIGHT_BLUE_CONCRETE,
                        YELLOW_CONCRETE,
                        LIME_CONCRETE,
                        PINK_CONCRETE,
                        GRAY_CONCRETE,
                        LIGHT_GRAY_CONCRETE,
                        CYAN_CONCRETE,
                        PURPLE_CONCRETE,
                        BLUE_CONCRETE,
                        BROWN_CONCRETE,
                        GREEN_CONCRETE,
                        RED_CONCRETE,
                        BLACK_CONCRETE,
                        WHITE_CONCRETE_POWDER,
                        ORANGE_CONCRETE_POWDER,
                        MAGENTA_CONCRETE_POWDER,
                        LIGHT_BLUE_CONCRETE_POWDER,
                        YELLOW_CONCRETE_POWDER,
                        LIME_CONCRETE_POWDER,
                        PINK_CONCRETE_POWDER,
                        GRAY_CONCRETE_POWDER,
                        LIGHT_GRAY_CONCRETE_POWDER,
                        CYAN_CONCRETE_POWDER,
                        PURPLE_CONCRETE_POWDER,
                        BLUE_CONCRETE_POWDER,
                        BROWN_CONCRETE_POWDER,
                        GREEN_CONCRETE_POWDER,
                        RED_CONCRETE_POWDER,
                        BLACK_CONCRETE_POWDER,
                        TURTLE_EGG,
                        SNIFFER_EGG,
                        DEAD_TUBE_CORAL_BLOCK,
                        DEAD_BRAIN_CORAL_BLOCK,
                        DEAD_BUBBLE_CORAL_BLOCK,
                        DEAD_FIRE_CORAL_BLOCK,
                        DEAD_HORN_CORAL_BLOCK,
                        TUBE_CORAL_BLOCK,
                        BRAIN_CORAL_BLOCK,
                        BUBBLE_CORAL_BLOCK,
                        FIRE_CORAL_BLOCK,
                        HORN_CORAL_BLOCK,
                        TUBE_CORAL,
                        BRAIN_CORAL,
                        BUBBLE_CORAL,
                        FIRE_CORAL,
                        HORN_CORAL,
                        DEAD_BRAIN_CORAL,
                        DEAD_BUBBLE_CORAL,
                        DEAD_FIRE_CORAL,
                        DEAD_HORN_CORAL,
                        DEAD_TUBE_CORAL,
                        TUBE_CORAL_FAN,
                        BRAIN_CORAL_FAN,
                        BUBBLE_CORAL_FAN,
                        FIRE_CORAL_FAN,
                        HORN_CORAL_FAN,
                        DEAD_TUBE_CORAL_FAN,
                        DEAD_BRAIN_CORAL_FAN,
                        DEAD_BUBBLE_CORAL_FAN,
                        DEAD_FIRE_CORAL_FAN,
                        DEAD_HORN_CORAL_FAN,
                        BLUE_ICE,
                        CONDUIT,
                        POLISHED_GRANITE_STAIRS,
                        SMOOTH_RED_SANDSTONE_STAIRS,
                        MOSSY_STONE_BRICK_STAIRS,
                        POLISHED_DIORITE_STAIRS,
                        MOSSY_COBBLESTONE_STAIRS,
                        END_STONE_BRICK_STAIRS,
                        STONE_STAIRS,
                        SMOOTH_SANDSTONE_STAIRS,
                        SMOOTH_QUARTZ_STAIRS,
                        GRANITE_STAIRS,
                        ANDESITE_STAIRS,
                        RED_NETHER_BRICK_STAIRS,
                        POLISHED_ANDESITE_STAIRS,
                        DIORITE_STAIRS,
                        COBBLED_DEEPSLATE_STAIRS,
                        POLISHED_DEEPSLATE_STAIRS,
                        DEEPSLATE_BRICK_STAIRS,
                        DEEPSLATE_TILE_STAIRS,
                        POLISHED_GRANITE_SLAB,
                        SMOOTH_RED_SANDSTONE_SLAB,
                        MOSSY_STONE_BRICK_SLAB,
                        POLISHED_DIORITE_SLAB,
                        MOSSY_COBBLESTONE_SLAB,
                        END_STONE_BRICK_SLAB,
                        SMOOTH_SANDSTONE_SLAB,
                        SMOOTH_QUARTZ_SLAB,
                        GRANITE_SLAB,
                        ANDESITE_SLAB,
                        RED_NETHER_BRICK_SLAB,
                        POLISHED_ANDESITE_SLAB,
                        DIORITE_SLAB,
                        COBBLED_DEEPSLATE_SLAB,
                        POLISHED_DEEPSLATE_SLAB,
                        DEEPSLATE_BRICK_SLAB,
                        DEEPSLATE_TILE_SLAB,
                        SCAFFOLDING,
                        REDSTONE,
                        REDSTONE_TORCH,
                        REDSTONE_BLOCK,
                        REPEATER,
                        COMPARATOR,
                        PISTON,
                        STICKY_PISTON,
                        SLIME_BLOCK,
                        HONEY_BLOCK,
                        OBSERVER,
                        HOPPER,
                        DISPENSER,
                        DROPPER,
                        LECTERN,
                        TARGET,
                        LEVER,
                        LIGHTNING_ROD,
                        DAYLIGHT_DETECTOR,
                        SCULK_SENSOR,
                        CALIBRATED_SCULK_SENSOR,
                        TRIPWIRE_HOOK,
                        TRAPPED_CHEST,
                        TNT,
                        REDSTONE_LAMP,
                        NOTE_BLOCK,
                        STONE_BUTTON,
                        POLISHED_BLACKSTONE_BUTTON,
                        OAK_BUTTON,
                        SPRUCE_BUTTON,
                        BIRCH_BUTTON,
                        JUNGLE_BUTTON,
                        ACACIA_BUTTON,
                        CHERRY_BUTTON,
                        DARK_OAK_BUTTON,
                        MANGROVE_BUTTON,
                        BAMBOO_BUTTON,
                        CRIMSON_BUTTON,
                        WARPED_BUTTON,
                        STONE_PRESSURE_PLATE,
                        POLISHED_BLACKSTONE_PRESSURE_PLATE,
                        LIGHT_WEIGHTED_PRESSURE_PLATE,
                        HEAVY_WEIGHTED_PRESSURE_PLATE,
                        OAK_PRESSURE_PLATE,
                        SPRUCE_PRESSURE_PLATE,
                        BIRCH_PRESSURE_PLATE,
                        JUNGLE_PRESSURE_PLATE,
                        ACACIA_PRESSURE_PLATE,
                        CHERRY_PRESSURE_PLATE,
                        DARK_OAK_PRESSURE_PLATE,
                        MANGROVE_PRESSURE_PLATE,
                        BAMBOO_PRESSURE_PLATE,
                        CRIMSON_PRESSURE_PLATE,
                        WARPED_PRESSURE_PLATE,
                        IRON_DOOR,
                        OAK_DOOR,
                        SPRUCE_DOOR,
                        BIRCH_DOOR,
                        JUNGLE_DOOR,
                        ACACIA_DOOR,
                        CHERRY_DOOR,
                        DARK_OAK_DOOR,
                        MANGROVE_DOOR,
                        BAMBOO_DOOR,
                        CRIMSON_DOOR,
                        WARPED_DOOR,
                        IRON_TRAPDOOR,
                        OAK_TRAPDOOR,
                        SPRUCE_TRAPDOOR,
                        BIRCH_TRAPDOOR,
                        JUNGLE_TRAPDOOR,
                        ACACIA_TRAPDOOR,
                        CHERRY_TRAPDOOR,
                        DARK_OAK_TRAPDOOR,
                        MANGROVE_TRAPDOOR,
                        BAMBOO_TRAPDOOR,
                        CRIMSON_TRAPDOOR,
                        WARPED_TRAPDOOR,
                        OAK_FENCE_GATE,
                        SPRUCE_FENCE_GATE,
                        BIRCH_FENCE_GATE,
                        JUNGLE_FENCE_GATE,
                        ACACIA_FENCE_GATE,
                        CHERRY_FENCE_GATE,
                        DARK_OAK_FENCE_GATE,
                        MANGROVE_FENCE_GATE,
                        BAMBOO_FENCE_GATE,
                        CRIMSON_FENCE_GATE,
                        WARPED_FENCE_GATE,
                        POWERED_RAIL,
                        DETECTOR_RAIL,
                        RAIL,
                        ACTIVATOR_RAIL,
                        SADDLE,
                        MINECART,
                        CHEST_MINECART,
                        FURNACE_MINECART,
                        TNT_MINECART,
                        HOPPER_MINECART,
                        CARROT_ON_A_STICK,
                        WARPED_FUNGUS_ON_A_STICK,
                        OAK_BOAT,
                        OAK_CHEST_BOAT,
                        SPRUCE_BOAT,
                        SPRUCE_CHEST_BOAT,
                        BIRCH_BOAT,
                        BIRCH_CHEST_BOAT,
                        JUNGLE_BOAT,
                        JUNGLE_CHEST_BOAT,
                        ACACIA_BOAT,
                        ACACIA_CHEST_BOAT,
                        CHERRY_BOAT,
                        CHERRY_CHEST_BOAT,
                        DARK_OAK_BOAT,
                        DARK_OAK_CHEST_BOAT,
                        MANGROVE_BOAT,
                        MANGROVE_CHEST_BOAT,
                        BAMBOO_RAFT,
                        BAMBOO_CHEST_RAFT,
                        JIGSAW,
                        TURTLE_HELMET,
                        TURTLE_SCUTE,
                        FLINT_AND_STEEL,
                        APPLE,
                        ARROW,
                        COAL,
                        CHARCOAL,
                        DIAMOND,
                        EMERALD,
                        LAPIS_LAZULI,
                        QUARTZ,
                        AMETHYST_SHARD,
                        RAW_IRON,
                        IRON_INGOT,
                        RAW_COPPER,
                        COPPER_INGOT,
                        RAW_GOLD,
                        GOLD_INGOT,
                        NETHERITE_INGOT,
                        NETHERITE_SCRAP,
                        STICK,
                        MUSHROOM_STEW,
                        STRING,
                        FEATHER,
                        GUNPOWDER,
                        WHEAT_SEEDS,
                        WHEAT,
                        BREAD,
                        FLINT,
                        PORKCHOP,
                        COOKED_PORKCHOP,
                        PAINTING,
                        GOLDEN_APPLE,
                        ENCHANTED_GOLDEN_APPLE,
                        OAK_SIGN,
                        SPRUCE_SIGN,
                        BIRCH_SIGN,
                        JUNGLE_SIGN,
                        ACACIA_SIGN,
                        CHERRY_SIGN,
                        DARK_OAK_SIGN,
                        MANGROVE_SIGN,
                        BAMBOO_SIGN,
                        CRIMSON_SIGN,
                        WARPED_SIGN,
                        OAK_HANGING_SIGN,
                        SPRUCE_HANGING_SIGN,
                        BIRCH_HANGING_SIGN,
                        JUNGLE_HANGING_SIGN,
                        ACACIA_HANGING_SIGN,
                        CHERRY_HANGING_SIGN,
                        DARK_OAK_HANGING_SIGN,
                        MANGROVE_HANGING_SIGN,
                        BAMBOO_HANGING_SIGN,
                        CRIMSON_HANGING_SIGN,
                        WARPED_HANGING_SIGN,
                        WATER_BUCKET,
                        LAVA_BUCKET,
                        POWDER_SNOW_BUCKET,
                        SNOWBALL,
                        LEATHER,
                        MILK_BUCKET,
                        PUFFERFISH_BUCKET,
                        SALMON_BUCKET,
                        COD_BUCKET,
                        TROPICAL_FISH_BUCKET,
                        TADPOLE_BUCKET,
                        BRICK,
                        CLAY_BALL,
                        DRIED_KELP_BLOCK,
                        PAPER,
                        BOOK,
                        SLIME_BALL,
                        EGG,
                        COMPASS,
                        RECOVERY_COMPASS,
                        BUNDLE,
                        CLOCK,
                        SPYGLASS,
                        GLOWSTONE_DUST,
                        COD,
                        SALMON,
                        TROPICAL_FISH,
                        PUFFERFISH,
                        COOKED_COD,
                        COOKED_SALMON,
                        INK_SAC,
                        GLOW_INK_SAC,
                        COCOA_BEANS,
                        WHITE_DYE,
                        ORANGE_DYE,
                        MAGENTA_DYE,
                        LIGHT_BLUE_DYE,
                        YELLOW_DYE,
                        LIME_DYE,
                        PINK_DYE,
                        GRAY_DYE,
                        LIGHT_GRAY_DYE,
                        CYAN_DYE,
                        PURPLE_DYE,
                        BLUE_DYE,
                        BROWN_DYE,
                        GREEN_DYE,
                        RED_DYE,
                        BLACK_DYE,
                        BONE_MEAL,
                        BONE,
                        SUGAR,
                        CAKE,
                        WHITE_BED,
                        ORANGE_BED,
                        MAGENTA_BED,
                        LIGHT_BLUE_BED,
                        YELLOW_BED,
                        LIME_BED,
                        PINK_BED,
                        GRAY_BED,
                        LIGHT_GRAY_BED,
                        CYAN_BED,
                        PURPLE_BED,
                        BLUE_BED,
                        BROWN_BED,
                        GREEN_BED,
                        RED_BED,
                        BLACK_BED,
                        COOKIE,
                        FILLED_MAP,
                        MELON_SLICE,
                        DRIED_KELP,
                        PUMPKIN_SEEDS,
                        MELON_SEEDS,
                        BEEF,
                        COOKED_BEEF,
                        CHICKEN,
                        COOKED_CHICKEN,
                        ROTTEN_FLESH,
                        ENDER_PEARL,
                        BLAZE_ROD,
                        GHAST_TEAR,
                        GOLD_NUGGET,
                        NETHER_WART,
                        POTION,
                        SPIDER_EYE,
                        FERMENTED_SPIDER_EYE,
                        BLAZE_POWDER,
                        MAGMA_CREAM,
                        BREWING_STAND,
                        CAULDRON,
                        ENDER_EYE,
                        GLISTERING_MELON_SLICE,
                        EXPERIENCE_BOTTLE,
                        FIRE_CHARGE,
                        ITEM_FRAME,
                        GLOW_ITEM_FRAME,
                        FLOWER_POT,
                        CARROT,
                        POTATO,
                        BAKED_POTATO,
                        POISONOUS_POTATO,
                        MAP,
                        GOLDEN_CARROT,
                        SKELETON_SKULL,
                        WITHER_SKELETON_SKULL,
                        PLAYER_HEAD,
                        ZOMBIE_HEAD,
                        CREEPER_HEAD,
                        DRAGON_HEAD,
                        PIGLIN_HEAD,
                        NETHER_STAR,
                        PUMPKIN_PIE,
                        FIREWORK_ROCKET,
                        FIREWORK_STAR,
                        ENCHANTED_BOOK,
                        NETHER_BRICK,
                        PRISMARINE_SHARD,
                        PRISMARINE_CRYSTALS,
                        RABBIT,
                        COOKED_RABBIT,
                        RABBIT_STEW,
                        RABBIT_FOOT,
                        RABBIT_HIDE,
                        ARMOR_STAND,
                        LEAD,
                        NAME_TAG,
                        MUTTON,
                        COOKED_MUTTON,
                        WHITE_BANNER,
                        ORANGE_BANNER,
                        MAGENTA_BANNER,
                        LIGHT_BLUE_BANNER,
                        YELLOW_BANNER,
                        LIME_BANNER,
                        PINK_BANNER,
                        GRAY_BANNER,
                        LIGHT_GRAY_BANNER,
                        CYAN_BANNER,
                        PURPLE_BANNER,
                        BLUE_BANNER,
                        BROWN_BANNER,
                        GREEN_BANNER,
                        RED_BANNER,
                        BLACK_BANNER,
                        END_CRYSTAL,
                        CHORUS_FRUIT,
                        POPPED_CHORUS_FRUIT,
                        TORCHFLOWER_SEEDS,
                        PITCHER_POD,
                        BEETROOT,
                        BEETROOT_SEEDS,
                        BEETROOT_SOUP,
                        DRAGON_BREATH,
                        SPLASH_POTION,
                        SPECTRAL_ARROW,
                        TIPPED_ARROW,
                        LINGERING_POTION,
                        TOTEM_OF_UNDYING,
                        SHULKER_SHELL,
                        IRON_NUGGET,
                        MUSIC_DISC_13,
                        MUSIC_DISC_CAT,
                        MUSIC_DISC_BLOCKS,
                        MUSIC_DISC_CHIRP,
                        MUSIC_DISC_FAR,
                        MUSIC_DISC_MALL,
                        MUSIC_DISC_MELLOHI,
                        MUSIC_DISC_STAL,
                        MUSIC_DISC_STRAD,
                        MUSIC_DISC_WARD,
                        MUSIC_DISC_11,
                        MUSIC_DISC_WAIT,
                        MUSIC_DISC_OTHERSIDE,
                        MUSIC_DISC_RELIC,
                        MUSIC_DISC_5,
                        MUSIC_DISC_PIGSTEP,
                        DISC_FRAGMENT_5,
                        PHANTOM_MEMBRANE,
                        NAUTILUS_SHELL,
                        HEART_OF_THE_SEA,
                        SUSPICIOUS_STEW,
                        LOOM,
                        FLOWER_BANNER_PATTERN,
                        CREEPER_BANNER_PATTERN,
                        SKULL_BANNER_PATTERN,
                        MOJANG_BANNER_PATTERN,
                        GLOBE_BANNER_PATTERN,
                        PIGLIN_BANNER_PATTERN,
                        GOAT_HORN,
                        COMPOSTER,
                        BARREL,
                        SMOKER,
                        BLAST_FURNACE,
                        CARTOGRAPHY_TABLE,
                        FLETCHING_TABLE,
                        GRINDSTONE,
                        SMITHING_TABLE,
                        STONECUTTER,
                        BELL,
                        LANTERN,
                        SOUL_LANTERN,
                        SWEET_BERRIES,
                        GLOW_BERRIES,
                        CAMPFIRE,
                        SOUL_CAMPFIRE,
                        SHROOMLIGHT,
                        HONEYCOMB,
                        BEE_NEST,
                        BEEHIVE,
                        HONEY_BOTTLE,
                        HONEYCOMB_BLOCK,
                        LODESTONE,
                        CRYING_OBSIDIAN,
                        BLACKSTONE,
                        BLACKSTONE_SLAB,
                        BLACKSTONE_STAIRS,
                        GILDED_BLACKSTONE,
                        POLISHED_BLACKSTONE,
                        POLISHED_BLACKSTONE_SLAB,
                        POLISHED_BLACKSTONE_STAIRS,
                        CHISELED_POLISHED_BLACKSTONE,
                        POLISHED_BLACKSTONE_BRICKS,
                        POLISHED_BLACKSTONE_BRICK_SLAB,
                        POLISHED_BLACKSTONE_BRICK_STAIRS,
                        CRACKED_POLISHED_BLACKSTONE_BRICKS,
                        RESPAWN_ANCHOR,
                        CANDLE,
                        WHITE_CANDLE,
                        ORANGE_CANDLE,
                        MAGENTA_CANDLE,
                        LIGHT_BLUE_CANDLE,
                        YELLOW_CANDLE,
                        LIME_CANDLE,
                        PINK_CANDLE,
                        GRAY_CANDLE,
                        LIGHT_GRAY_CANDLE,
                        CYAN_CANDLE,
                        PURPLE_CANDLE,
                        BLUE_CANDLE,
                        BROWN_CANDLE,
                        GREEN_CANDLE,
                        RED_CANDLE,
                        BLACK_CANDLE,
                        SMALL_AMETHYST_BUD,
                        MEDIUM_AMETHYST_BUD,
                        LARGE_AMETHYST_BUD,
                        AMETHYST_CLUSTER,
                        POINTED_DRIPSTONE,
                        OCHRE_FROGLIGHT,
                        VERDANT_FROGLIGHT,
                        PEARLESCENT_FROGLIGHT,
                        FROGSPAWN,
                        ECHO_SHARD,
                        BRUSH
                );
    }
}
