package com.github.ysbbbbbb.kaleidoscopecookery.event;

import com.github.ysbbbbbb.kaleidoscopecookery.KaleidoscopeCookery;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

import java.util.List;


@EventBusSubscriber(modid = KaleidoscopeCookery.MOD_ID)
public class AddVillageStructuresEvent {
    private static final ResourceKey<StructureProcessorList> CROP_REPLACE_PROCESSOR_LIST_KEY = ResourceKey.create(
            Registries.PROCESSOR_LIST, ResourceLocation.fromNamespaceAndPath(KaleidoscopeCookery.MOD_ID, "crop_replace"));

    private static final ResourceLocation PLAINS = ResourceLocation.parse("minecraft:village/plains/houses");
    private static final ResourceLocation SNOWY = ResourceLocation.parse("minecraft:village/snowy/houses");
    private static final ResourceLocation SAVANNA = ResourceLocation.parse("minecraft:village/savanna/houses");
    private static final ResourceLocation DESERT = ResourceLocation.parse("minecraft:village/desert/houses");
    private static final ResourceLocation TAIGA = ResourceLocation.parse("minecraft:village/taiga/houses");

    @SubscribeEvent
    public static void addVillageStructures(ServerAboutToStartEvent event) {
        var registryAccess = event.getServer().registryAccess();

        addBuildingToPool(registryAccess, PLAINS, "village/houses/plains_kitchen", 4);
        addBuildingToPool(registryAccess, SNOWY, "village/houses/snowy_kitchen", 4);
        addBuildingToPool(registryAccess, SAVANNA, "village/houses/savanna_kitchen", 4);
        addBuildingToPool(registryAccess, DESERT, "village/houses/desert_kitchen", 4);
        addBuildingToPool(registryAccess, TAIGA, "village/houses/taiga_kitchen", 4);
    }

    /**
     * 参考自：<a href="https://gist.github.com/TelepathicGrunt/4fdbc445ebcbcbeb43ac748f4b18f342">GitHub TelepathicGrunt</a>
     */
    public static void addBuildingToPool(RegistryAccess registryAccess, ResourceLocation poolId, String structId, int weight) {
        var templatePools = registryAccess.registry(Registries.TEMPLATE_POOL);
        if (templatePools.isEmpty()) {
            return;
        }
        var processorLists = registryAccess.registry(Registries.PROCESSOR_LIST);
        if (processorLists.isEmpty()) {
            return;
        }
        StructureTemplatePool pool = templatePools.get().get(poolId);
        if (pool == null) {
            return;
        }
        Holder<StructureProcessorList> holder = processorLists.get().getHolderOrThrow(CROP_REPLACE_PROCESSOR_LIST_KEY);
        ResourceLocation structLocation = ResourceLocation.fromNamespaceAndPath(KaleidoscopeCookery.MOD_ID, structId);
        SinglePoolElement piece = SinglePoolElement.legacy(structLocation.toString(), holder).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; i++) {
            pool.templates.add(piece);
        }
        List<Pair<StructurePoolElement, Integer>> newRawTemplates = Lists.newArrayList(pool.rawTemplates);
        newRawTemplates.add(Pair.of(piece, weight));
        pool.rawTemplates = newRawTemplates;
    }
}
