/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.crop;

import com.github.ysbbbbbb.kaleidoscopecookery.block.crop.BaseCropBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSounds;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.CommonHooks;

public class RiceCropBlock
extends BaseCropBlock
implements SimpleWaterloggedBlock {
    public static final int DOWN = 0;
    public static final int MIDDLE = 1;
    public static final int UP = 2;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final IntegerProperty LOCATION = IntegerProperty.create((String)"location", (int)0, (int)2);
    private static final Predicate<LivingEntity> RICE_GROWTH_BOOSTER = e -> e.isAlive() && e.getType().is(TagMod.RICE_GROWTH_BOOSTER);
    private static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape EMPTY_SHAPE = Shapes.empty();
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)8.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)0.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)6.0, (double)14.0)};

    public RiceCropBlock() {
        super(ModItems.RICE_PANICLE, ModItems.RICE_SEED);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)LOCATION, (Comparable)Integer.valueOf(0)));
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (facing == Direction.DOWN) {
            if (state.canSurvive((LevelReader)level, currentPos)) {
                return facingState.is((Block)this) ? (BlockState)state.setValue((Property)AGE, (Comparable)((Integer)facingState.getValue((Property)AGE))) : state;
            }
            return Blocks.AIR.defaultBlockState();
        }
        if (facing == Direction.UP) {
            int location = (Integer)state.getValue((Property)LOCATION);
            if (location == 0) {
                if (facingState.is((Block)this) && (Integer)facingState.getValue((Property)LOCATION) == 1) {
                    return (BlockState)state.setValue((Property)AGE, (Comparable)((Integer)facingState.getValue((Property)AGE)));
                }
                return Blocks.AIR.defaultBlockState();
            }
            if (location == 1) {
                if (facingState.is((Block)this) && (Integer)facingState.getValue((Property)LOCATION) == 2) {
                    return (BlockState)state.setValue((Property)AGE, (Comparable)((Integer)facingState.getValue((Property)AGE)));
                }
                return Blocks.AIR.defaultBlockState();
            }
        }
        return state;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos blockPos = context.getClickedPos();
        Level level = context.getLevel();
        boolean isWaterlogged = level.getFluidState(blockPos).is(FluidTags.WATER);
        boolean aboveMatches = level.getBlockState(blockPos.above(1)).isAir();
        boolean above2Matches = level.getBlockState(blockPos.above(2)).isAir();
        if (blockPos.getY() < level.getMaxBuildHeight() - 2 && isWaterlogged && aboveMatches && above2Matches) {
            return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        level.setBlock(pos.above(1), (BlockState)this.getStateForAge(0).setValue((Property)LOCATION, (Comparable)Integer.valueOf(1)), 3);
        level.setBlock(pos.above(2), (BlockState)this.getStateForAge(0).setValue((Property)LOCATION, (Comparable)Integer.valueOf(2)), 3);
    }

    public boolean canSurvive(BlockState state, LevelReader levelReader, BlockPos pos) {
        if (levelReader.getRawBrightness(pos, 0) < 8 && !levelReader.canSeeSky(pos)) {
            return false;
        }
        int location = (Integer)state.getValue((Property)LOCATION);
        if (location == 0) {
            BlockPos basePos = pos.below();
            BlockState baseState = levelReader.getBlockState(basePos);
            return this.mayPlaceOn(baseState, (BlockGetter)levelReader, basePos) && state.getFluidState().is(FluidTags.WATER);
        }
        if (location == 1) {
            BlockPos downPos = pos.below();
            BlockState downState = levelReader.getBlockState(downPos);
            return downState.is((Block)this) && (Integer)downState.getValue((Property)LOCATION) == 0;
        }
        if (location == 2) {
            BlockPos middlePos = pos.below();
            BlockState middleState = levelReader.getBlockState(middlePos);
            return middleState.is((Block)this) && (Integer)middleState.getValue((Property)LOCATION) == 1;
        }
        return false;
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        if (!this.isThreeBlock(state) && (Integer)state.getValue((Property)LOCATION) == 1) {
            return SHAPE_BY_AGE[(Integer)state.getValue((Property)AGE)];
        }
        if ((Integer)state.getValue((Property)LOCATION) == 2) {
            if (this.isThreeBlock(state)) {
                return SHAPE_BY_AGE[(Integer)state.getValue((Property)AGE)];
            }
            return EMPTY_SHAPE;
        }
        return BASE_SHAPE;
    }

    private boolean isThreeBlock(BlockState state) {
        return state.is((Block)this) && (Integer)state.getValue((Property)AGE) > 3;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return super.isRandomlyTicking(state) && (Integer)state.getValue((Property)LOCATION) == 0;
    }

    public void randomTick(BlockState state, ServerLevel serverLevel, BlockPos pos, RandomSource random) {
        if (!serverLevel.isAreaLoaded(pos, 1)) {
            return;
        }
        if ((Integer)state.getValue((Property)LOCATION) != 0) {
            return;
        }
        if (serverLevel.isNight()) {
            serverLevel.playSound(null, pos.above(), (SoundEvent)ModSounds.BLOCK_PADDY.get(), SoundSource.BLOCKS, serverLevel.getRandom().nextFloat() * 0.2f + 0.2f, serverLevel.getRandom().nextFloat() * 0.1f + 0.9f);
        }
        if (serverLevel.getRawBrightness(pos, 0) >= 9) {
            int age = this.getAge(state);
            if (age >= this.getMaxAge()) {
                return;
            }
            float speed = RiceCropBlock.getGrowthSpeed((BlockState)state, (BlockGetter)serverLevel, (BlockPos)pos) / 2.0f;
            List fish = serverLevel.getEntitiesOfClass(LivingEntity.class, new AABB(pos).inflate(1.0, 0.0, 1.0), RICE_GROWTH_BOOSTER);
            if (!fish.isEmpty()) {
                float size = (float)(Math.log(fish.size()) / Math.log(2.0));
                speed += speed * size;
            }
            if (CommonHooks.canCropGrow((Level)serverLevel, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / speed) + 1) == 0 ? 1 : 0) != 0)) {
                this.setCropState((Level)serverLevel, pos, age + 1);
                CommonHooks.fireCropGrowPost((Level)serverLevel, (BlockPos)pos, (BlockState)state);
            }
        }
    }

    private void setCropState(Level level, BlockPos startPos, int age) {
        level.setBlock(startPos, (BlockState)this.getStateForAge(age).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 2);
    }

    public void growCrops(Level level, BlockPos pos, BlockState state) {
        int maxAge;
        int boneAge = this.getAge(state) + this.getBonemealAgeIncrease(level);
        if (boneAge > (maxAge = this.getMaxAge())) {
            boneAge = maxAge;
        }
        this.setCropState(level, pos.below(((Integer)state.getValue((Property)LOCATION)).intValue()), boneAge);
    }

    protected int getBonemealAgeIncrease(Level level) {
        return Mth.nextInt((RandomSource)level.random, (int)1, (int)2);
    }

    @Override
    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        return InteractionResult.PASS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AGE, LOCATION, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder lootParamsBuilder) {
        if ((Integer)state.getValue((Property)LOCATION) != 0) {
            return Collections.emptyList();
        }
        return super.getDrops(state, lootParamsBuilder);
    }

    public ItemStack pickupBlock(Player player, LevelAccessor levelAccessor, BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            levelAccessor.setBlock(pos, (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            if ((Integer)state.getValue((Property)LOCATION) == 0) {
                levelAccessor.destroyBlock(pos, true);
            }
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        return ItemStack.EMPTY;
    }
}

