/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.decoration;

import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.decoration.ChairBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.entity.SitEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.util.BlockDrop;
import com.github.ysbbbbbb.kaleidoscopecookery.util.CarpetColor;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChairBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final MapCodec<ChairBlock> CODEC = ChairBlock.simpleCodec(p -> new ChairBlock());
    public static final BooleanProperty HAS_CARPET = BooleanProperty.create((String)"has_carpet");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape BASE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
    private static final VoxelShape NORTH = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)2.0, (double)0.0, (double)12.0, (double)14.0, (double)19.0, (double)14.0));
    private static final VoxelShape SOUTH = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)19.0, (double)4.0));
    private static final VoxelShape WEST = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)12.0, (double)0.0, (double)2.0, (double)14.0, (double)19.0, (double)14.0));
    private static final VoxelShape EAST = Shapes.or((VoxelShape)BASE, (VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)4.0, (double)19.0, (double)14.0));

    public ChairBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).noOcclusion().ignitedByLava());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)HAS_CARPET, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(state, direction, neighborState, levelAccessor, pos, neighborPos);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (hand == InteractionHand.MAIN_HAND && itemInHand.is(ItemTags.WOOL_CARPETS)) {
            return this.useWithCarpets(state, level, pos, player, itemInHand);
        }
        return this.tryToSitOn(state, level, pos, player);
    }

    @NotNull
    private ItemInteractionResult tryToSitOn(BlockState state, Level level, BlockPos pos, Player player) {
        List entities = level.getEntitiesOfClass(SitEntity.class, new AABB(pos));
        if (entities.isEmpty()) {
            SitEntity entitySit = new SitEntity(level, pos, 0.5125);
            entitySit.setYRot(((Direction)state.getValue((Property)FACING)).toYRot());
            level.addFreshEntity((Entity)entitySit);
            player.startRiding((Entity)entitySit, true);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    private ItemInteractionResult useWithCarpets(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemInHand) {
        ChairBlockEntity chairBlockEntity;
        BlockEntity blockEntity;
        @Nullable DyeColor dyeColor = CarpetColor.getColorByCarpet(itemInHand.getItem());
        boolean hasCarpet = (Boolean)state.getValue((Property)HAS_CARPET);
        if (dyeColor == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!hasCarpet) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_CARPET, (Comparable)Boolean.valueOf(true)));
            blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ChairBlockEntity) {
                ChairBlockEntity chairBlockEntity2 = (ChairBlockEntity)blockEntity;
                level.playSound(null, pos, SoundType.WOOL.getPlaceSound(), player.getSoundSource(), 1.0f, 1.0f);
                chairBlockEntity2.setColor(dyeColor);
                chairBlockEntity2.refresh();
                itemInHand.shrink(1);
                return ItemInteractionResult.SUCCESS;
            }
        }
        if (hasCarpet && (blockEntity = level.getBlockEntity(pos)) instanceof ChairBlockEntity && (chairBlockEntity = (ChairBlockEntity)blockEntity).getColor() != dyeColor) {
            DyeColor originalColor = chairBlockEntity.getColor();
            ItemStack carpetItem = CarpetColor.getCarpetByColor(originalColor).getDefaultInstance();
            BlockDrop.popResource(level, pos, 0.25, carpetItem);
            level.playSound(null, pos, SoundType.WOOL.getPlaceSound(), player.getSoundSource(), 1.0f, 1.0f);
            chairBlockEntity.setColor(dyeColor);
            chairBlockEntity.refresh();
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_CARPET, (Comparable)Boolean.valueOf(true)));
            itemInHand.shrink(1);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void destroy(LevelAccessor levelAccessor, BlockPos pos, BlockState state) {
        levelAccessor.getEntitiesOfClass(SitEntity.class, new AABB(pos)).forEach(Entity::discard);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder lootParamsBuilder) {
        List drops = super.getDrops(state, lootParamsBuilder);
        BlockEntity parameter = (BlockEntity)lootParamsBuilder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (((Boolean)state.getValue((Property)HAS_CARPET)).booleanValue() && parameter instanceof ChairBlockEntity) {
            ChairBlockEntity chairBlockEntity = (ChairBlockEntity)parameter;
            Item carpet = CarpetColor.getCarpetByColor(chairBlockEntity.getColor());
            drops.add(new ItemStack((ItemLike)carpet));
        }
        return drops;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HAS_CARPET, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (((Boolean)state.getValue((Property)HAS_CARPET)).booleanValue()) {
            return new ChairBlockEntity(pos, state);
        }
        return null;
    }
}

