/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.item.KitchenShovelItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnamelBasinBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final int MAX_OIL_COUNT = 12;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty HAS_LID = BooleanProperty.create((String)"has_lid");
    public static final IntegerProperty OIL_COUNT = IntegerProperty.create((String)"oil_count", (int)0, (int)12);
    private static final VoxelShape AABB_NO_LID = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)5.0, (double)13.0);
    private static final VoxelShape AABB = Shapes.or((VoxelShape)AABB_NO_LID, (VoxelShape[])new VoxelShape[]{Block.box((double)2.5, (double)5.0, (double)2.5, (double)13.5, (double)6.0, (double)13.5), Block.box((double)7.0, (double)6.0, (double)7.0, (double)9.0, (double)7.0, (double)9.0)});

    public EnamelBasinBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BELL).strength(1.0f, 1.5f).sound(SoundType.LANTERN));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_LID, (Comparable)Boolean.valueOf(true))).setValue((Property)OIL_COUNT, (Comparable)Integer.valueOf(12)));
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(state, direction, neighborState, levelAccessor, pos, neighborPos);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack mainHandItem;
        if (hand != InteractionHand.MAIN_HAND) {
            super.useItemOn(stack, state, level, pos, player, hand, hitResult);
        }
        if ((mainHandItem = player.getMainHandItem()).is(Items.STICK)) {
            float pitch = 0.6f + (float)Math.random() * 0.2f;
            level.playSound(player, pos, SoundEvents.LANTERN_BREAK, SoundSource.BLOCKS, 2.0f, pitch);
            return ItemInteractionResult.SUCCESS;
        }
        boolean hasLid = (Boolean)state.getValue((Property)HAS_LID);
        if (hasLid) {
            level.playSound(player, pos, SoundEvents.LANTERN_BREAK, SoundSource.BLOCKS, 0.8f, 0.8f);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_LID, (Comparable)Boolean.valueOf(false)));
            return ItemInteractionResult.SUCCESS;
        }
        if (mainHandItem.isEmpty()) {
            level.playSound(player, pos, SoundEvents.LANTERN_BREAK, SoundSource.BLOCKS, 0.8f, 0.4f);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_LID, (Comparable)Boolean.valueOf(true)));
            return ItemInteractionResult.SUCCESS;
        }
        if (mainHandItem.is((Item)ModItems.OIL.get())) {
            int value = (Integer)state.getValue((Property)OIL_COUNT);
            if (value >= 12) {
                return ItemInteractionResult.FAIL;
            }
            int needCount = 12 - value;
            int consumeCount = Math.min(needCount, mainHandItem.getCount());
            level.playSound(player, pos, SoundEvents.HONEY_BLOCK_BREAK, SoundSource.BLOCKS, 0.8f, 0.8f);
            mainHandItem.shrink(consumeCount);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OIL_COUNT, (Comparable)Integer.valueOf(value + consumeCount)));
            return ItemInteractionResult.SUCCESS;
        }
        if (mainHandItem.is((Item)ModItems.KITCHEN_SHOVEL.get())) {
            return this.onShovelClick(state, level, pos, player, mainHandItem);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @NotNull
    private ItemInteractionResult onShovelClick(BlockState state, Level level, BlockPos pos, Player player, ItemStack mainHandItem) {
        int value = (Integer)state.getValue((Property)OIL_COUNT);
        boolean shovelHasOil = KitchenShovelItem.hasOil(mainHandItem);
        if (shovelHasOil) {
            if (value >= 12) {
                return ItemInteractionResult.FAIL;
            }
            level.playSound(player, pos, SoundEvents.HONEY_BLOCK_BREAK, SoundSource.BLOCKS, 0.8f, 0.8f);
            KitchenShovelItem.setHasOil(mainHandItem, false);
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OIL_COUNT, (Comparable)Integer.valueOf(value + 1)));
            return ItemInteractionResult.SUCCESS;
        }
        if (value == 0) {
            level.destroyBlock(pos, true, (Entity)player);
            return ItemInteractionResult.SUCCESS;
        }
        level.playSound(player, pos, SoundEvents.HONEY_BLOCK_BREAK, SoundSource.BLOCKS, 0.8f, 1.2f);
        KitchenShovelItem.setHasOil(mainHandItem, true);
        level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)OIL_COUNT, (Comparable)Integer.valueOf(value - 1)));
        return ItemInteractionResult.SUCCESS;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATERLOGGED, HAS_LID, OIL_COUNT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return (Boolean)state.getValue((Property)HAS_LID) != false ? AABB : AABB_NO_LID;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return (Integer)state.getValue((Property)OIL_COUNT);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.enamel_basin").withStyle(ChatFormatting.GRAY));
    }
}

