/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IKitchenwareRacks;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.KitchenwareRacksBlockEntity;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class KitchenwareRacksBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final MapCodec<KitchenwareRacksBlock> CODEC = KitchenwareRacksBlock.simpleCodec(p -> new KitchenwareRacksBlock());
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape NORTH = Block.box((double)1.0, (double)9.0, (double)14.0, (double)15.0, (double)14.0, (double)16.0);
    private static final VoxelShape SOUTH = Block.box((double)1.0, (double)9.0, (double)0.0, (double)15.0, (double)14.0, (double)2.0);
    private static final VoxelShape EAST = Block.box((double)0.0, (double)9.0, (double)1.0, (double)2.0, (double)14.0, (double)15.0);
    private static final VoxelShape WEST = Block.box((double)14.0, (double)9.0, (double)1.0, (double)16.0, (double)14.0, (double)15.0);

    public KitchenwareRacksBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).ignitedByLava());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(state, direction, neighborState, levelAccessor, pos, neighborPos);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        IKitchenwareRacks racks;
        if (hand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        double yRotDeg = ((Direction)state.getValue((Property)FACING)).getOpposite().toYRot();
        float yRotRad = (float)Math.toRadians(yRotDeg);
        Vec3 location = hitResult.getLocation().subtract(Vec3.atCenterOf((Vec3i)pos)).yRot(yRotRad);
        boolean isLeftClick = location.x > 0.0;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IKitchenwareRacks && (racks = (IKitchenwareRacks)blockEntity).onClick((LivingEntity)player, mainHandItem, isLeftClick)) {
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> SOUTH;
            case Direction.EAST -> EAST;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new KitchenwareRacksBlockEntity(pos, state);
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide && player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof KitchenwareRacksBlockEntity) {
            KitchenwareRacksBlockEntity racks = (KitchenwareRacksBlockEntity)blockEntity;
            if (!racks.getItemLeft().isEmpty()) {
                KitchenwareRacksBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)racks.getItemLeft());
                racks.setItemLeft(ItemStack.EMPTY);
            }
            if (!racks.getItemRight().isEmpty()) {
                KitchenwareRacksBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)racks.getItemRight());
                racks.setItemRight(ItemStack.EMPTY);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder lootParamsBuilder) {
        List drops = super.getDrops(state, lootParamsBuilder);
        BlockEntity parameter = (BlockEntity)lootParamsBuilder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (parameter instanceof KitchenwareRacksBlockEntity) {
            KitchenwareRacksBlockEntity racks = (KitchenwareRacksBlockEntity)parameter;
            if (!racks.getItemLeft().isEmpty()) {
                drops.add(racks.getItemLeft());
            }
            if (!racks.getItemRight().isEmpty()) {
                drops.add(racks.getItemRight());
            }
        }
        return drops;
    }
}

