/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.advancements.critereon.ModEventTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IPot;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.PotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoundType;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PotBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<PotBlock> CODEC = PotBlock.simpleCodec(p -> new PotBlock());
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty HAS_OIL = BooleanProperty.create((String)"has_oil");
    public static final BooleanProperty SHOW_OIL = BooleanProperty.create((String)"show_oil");
    public static final BooleanProperty HAS_BASE = BooleanProperty.create((String)"has_base");
    private static final VoxelShape AABB = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.0, (double)14.0);
    private static final double DURABILITY_COST_PROBABILITY = 0.25;

    public PotBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(ModSoundType.POT).noOcclusion().strength(1.5f, 6.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)HAS_OIL, (Comparable)Boolean.valueOf(false))).setValue((Property)SHOW_OIL, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_BASE, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        if (direction == Direction.DOWN) {
            return (BlockState)state.setValue((Property)HAS_BASE, (Comparable)Boolean.valueOf(!neighborState.isFaceSturdy((BlockGetter)levelAccessor, neighborPos, Direction.UP)));
        }
        return super.updateShape(state, direction, neighborState, levelAccessor, pos, neighborPos);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            IPot pot;
            Player player = (Player)placer;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof IPot && (pot = (IPot)blockEntity).hasHeatSource(level)) {
                ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger((LivingEntity)player, "place_pot_on_heat_source");
            }
        }
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand == InteractionHand.OFF_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof IPot)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        IPot pot = (IPot)blockEntity;
        ItemStack itemInHand = player.getItemInHand(hand);
        RandomSource random = level.random;
        if ((itemInHand.isEmpty() || itemInHand.is(TagMod.INGREDIENT_CONTAINER)) && pot.removeIngredient(level, (LivingEntity)player)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (pot.takeOutProduct(level, (LivingEntity)player, player.getMainHandItem())) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!pot.hasHeatSource(level)) {
            this.sendBarMessage(player, "tip.kaleidoscope_cookery.pot.need_lit_stove");
            return ItemInteractionResult.FAIL;
        }
        if (!((Boolean)state.getValue((Property)HAS_OIL)).booleanValue()) {
            if (pot.onPlaceOil(level, (LivingEntity)player, itemInHand)) {
                return ItemInteractionResult.SUCCESS;
            }
            this.sendBarMessage(player, "tip.kaleidoscope_cookery.pot.need_oil");
            return ItemInteractionResult.FAIL;
        }
        if (itemInHand.is(TagMod.KITCHEN_SHOVEL)) {
            if (level.random.nextDouble() < 0.25) {
                itemInHand.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
            pot.onShovelHit(level, (LivingEntity)player, itemInHand);
            level.playSound(player, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 1.0f + (random.nextFloat() - random.nextFloat()) * 0.8f);
            return ItemInteractionResult.SUCCESS;
        }
        if (pot.addIngredient(level, (LivingEntity)player, itemInHand)) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    private void sendBarMessage(Player player, String key) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            MutableComponent message = Component.translatable((String)key);
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PotBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return null;
        }
        if (!((Boolean)state.getValue((Property)HAS_OIL)).booleanValue()) {
            return null;
        }
        return PotBlock.createTickerHelper(blockEntityType, ModBlocks.POT_BE.get(), (levelIn, pos, stateIn, pot) -> pot.tick(levelIn));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        BlockState belowState = context.getLevel().getBlockState(context.getClickedPos().below());
        if (!belowState.isFaceSturdy((BlockGetter)context.getLevel(), context.getClickedPos().below(), Direction.UP)) {
            return (BlockState)blockState.setValue((Property)HAS_BASE, (Comparable)Boolean.valueOf(true));
        }
        return blockState;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HAS_OIL, SHOW_OIL, HAS_BASE, FACING, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return AABB;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.pot").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.pot.fail").withStyle(ChatFormatting.GRAY));
    }
}

