/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IKitchenwareRacks;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.Tags;

public class KitchenwareRacksBlockEntity
extends BaseBlockEntity
implements IKitchenwareRacks {
    private static final String LEFT_ITEM = "LeftItem";
    private static final String RIGHT_ITEM = "RightItem";
    private ItemStack itemLeft = ItemStack.EMPTY;
    private ItemStack itemRight = ItemStack.EMPTY;

    public KitchenwareRacksBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlocks.KITCHENWARE_RACKS_BE.get(), pPos, pBlockState);
    }

    @Override
    public boolean onClick(LivingEntity user, ItemStack stack, boolean isLeft) {
        ItemStack stackInRacks;
        ItemStack itemStack = stackInRacks = isLeft ? this.itemLeft : this.itemRight;
        if (stack.isEmpty() && !stackInRacks.isEmpty()) {
            ItemUtils.getItemToLivingEntity(user, stackInRacks);
            if (isLeft) {
                this.itemLeft = ItemStack.EMPTY;
            } else {
                this.itemRight = ItemStack.EMPTY;
            }
            user.playSound(SoundEvents.ITEM_FRAME_REMOVE_ITEM, 1.0f, 1.0f);
            this.refresh();
            return true;
        }
        if (stack.is(Tags.Items.TOOLS) && stackInRacks.isEmpty()) {
            if (isLeft) {
                this.itemLeft = stack.split(1);
            } else {
                this.itemRight = stack.split(1);
            }
            user.playSound(SoundEvents.ITEM_FRAME_ADD_ITEM, 1.0f, 1.0f);
            this.refresh();
            return true;
        }
        return false;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put(LEFT_ITEM, this.itemLeft.saveOptional(registries));
        tag.put(RIGHT_ITEM, this.itemRight.saveOptional(registries));
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemLeft = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(LEFT_ITEM));
        this.itemRight = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(RIGHT_ITEM));
    }

    @Override
    public ItemStack getItemLeft() {
        return this.itemLeft;
    }

    @Override
    public ItemStack getItemRight() {
        return this.itemRight;
    }

    public void setItemLeft(ItemStack itemLeft) {
        this.itemLeft = itemLeft;
    }

    public void setItemRight(ItemStack itemRight) {
        this.itemRight = itemRight;
    }
}

