/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IMillstone;
import com.github.ysbbbbbb.kaleidoscopecookery.api.event.MillstoneFinishEvent;
import com.github.ysbbbbbb.kaleidoscopecookery.api.event.MillstoneTakeItemEvent;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.MillstoneRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.datamap.MillstoneBindableData;
import com.github.ysbbbbbb.kaleidoscopecookery.datamap.resources.MillstoneBindableDataReloadListener;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSounds;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.inventory.itemhandler.MillstoneOutputHandler;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class MillstoneBlockEntity
extends BaseBlockEntity
implements IMillstone {
    public static final int MAX_INPUT_COUNT = 8;
    private static final String ENTITY_ID_KEY = "EntityId";
    private static final String CACHE_ROT_KEY = "CacheRot";
    private static final String ROT_SPEED_TICK_KEY = "RotSpeedTick";
    private static final String LIFT_ANGLE_KEY = "LiftAngle";
    private static final String INPUT_ITEM_KEY = "InputItem";
    private static final String OUTPUT_ITEM_KEY = "OutputItem";
    private static final String CARRIER_INGREDIENT_KEY = "CarrierIngredient";
    private static final String PROGRESS_KEY = "Progress";
    private final RecipeManager.CachedCheck<SingleRecipeInput, MillstoneRecipe> quickCheck = RecipeManager.createCheck(ModRecipes.MILLSTONE_RECIPE);
    private UUID entityId = Util.NIL_UUID;
    private float cacheRot = 0.0f;
    private float rotSpeedTick = 200.0f;
    private float liftAngle = 5.0f;
    private ItemStack input = ItemStack.EMPTY;
    private ItemStack output = ItemStack.EMPTY;
    private Ingredient carrier = Ingredient.EMPTY;
    private int progress = 0;
    @Nullable
    private Mob bindEntity;
    private Vec3 offset = Vec3.ZERO;

    public MillstoneBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.MILLSTONE_BE.get(), pos, state);
    }

    public float getRotation(Level level, float partialTick) {
        float degPerTick = 360.0f / Math.max(this.rotSpeedTick, 1.0f);
        float gameTime = (float)level.getGameTime() + partialTick;
        return (this.cacheRot + gameTime * degPerTick) % 360.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void tick(Level level) {
        IItemHandler handler;
        Vec3 center;
        float rot;
        ServerLevel serverLevel;
        block17: {
            Level level2 = this.level;
            if (!(level2 instanceof ServerLevel)) {
                return;
            }
            serverLevel = (ServerLevel)level2;
            if (Util.NIL_UUID.equals(this.entityId)) {
                return;
            }
            if (serverLevel.getGameTime() % 20L == 0L && this.input.isEmpty() && !this.output.isEmpty()) {
                NeoForge.EVENT_BUS.post((Event)new MillstoneFinishEvent(this, this.bindEntity));
            }
            rot = this.getRotation(level, 0.0f);
            center = Vec3.atBottomCenterOf((Vec3i)this.getBlockPos());
            double maxDistanceSqr = 25.0;
            if (this.bindEntity == null) {
                Mob mob;
                Entity entity = serverLevel.getEntity(this.entityId);
                if (entity instanceof Mob && (mob = (Mob)entity).isAlive() && mob.distanceToSqr(center) < maxDistanceSqr && this.canBindEntity(mob)) {
                    this.bindEntity(mob);
                    break block17;
                } else {
                    this.entityId = Util.NIL_UUID;
                    this.cacheRot = 0.0f;
                    this.liftAngle = 0.0f;
                    this.refresh();
                    return;
                }
            }
            if (!this.bindEntity.isAlive() || this.bindEntity.distanceToSqr(center) >= maxDistanceSqr || this.bindEntity.fallDistance > 0.5f || this.bindEntity.isInWall() || this.saddleEntityIsControlling(this.bindEntity)) {
                this.entityId = Util.NIL_UUID;
                this.bindEntity = null;
                this.cacheRot = rot;
                this.liftAngle = 0.0f;
                this.refresh();
                return;
            }
        }
        Vec3 pos = new Vec3(0.0, 0.0, 2.0).add(this.offset).yRot(rot * ((float)Math.PI / 180)).add(center);
        this.bindEntity.moveTo(pos.x, pos.y, pos.z, -rot - 90.0f, 0.0f);
        if (this.bindEntity.tickCount % 10 == 0 && this.output.isEmpty() && this.input.isEmpty() && this.progress <= 0 && (handler = (IItemHandler)this.bindEntity.getCapability(Capabilities.ItemHandler.ENTITY)) != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack;
                ItemStack stackInSlot = handler.getStackInSlot(i);
                if (stackInSlot.isEmpty() || !this.onPutItem(level, stack = handler.extractItem(i, 8, true))) continue;
                handler.extractItem(i, 8, false);
                return;
            }
        }
        if (serverLevel.getGameTime() % 5L == 2L) {
            Item item;
            Item item2 = !this.output.isEmpty() ? this.output.getItem() : (item = !this.input.isEmpty() ? this.input.getItem() : Items.AIR);
            if (item != Items.AIR) {
                Vec3 particlePos = new Vec3(0.0, 1.0, 1.0).yRot(rot * ((float)Math.PI / 180)).add(center);
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    BlockState block = blockItem.getBlock().defaultBlockState();
                    BlockParticleOption option = new BlockParticleOption(ParticleTypes.BLOCK, block);
                    serverLevel.sendParticles((ParticleOptions)option, particlePos.x, particlePos.y, particlePos.z, 5, 0.1, 0.1, 0.1, 0.05);
                } else {
                    ItemParticleOption option = new ItemParticleOption(ParticleTypes.ITEM, item.getDefaultInstance());
                    serverLevel.sendParticles((ParticleOptions)option, particlePos.x, particlePos.y, particlePos.z, 5, 0.1, 0.1, 0.1, 0.05);
                }
            }
        }
        if (serverLevel.getGameTime() % 25L == 0L) {
            float pitch = level.random.nextFloat() * 0.2f + 0.9f;
            serverLevel.playSound(null, this.worldPosition, (SoundEvent)ModSounds.BLOCK_MILLSTONE.get(), SoundSource.BLOCKS, 0.5f, pitch);
        }
        if (this.progress > 0 && this.output.isEmpty()) {
            --this.progress;
            if (this.progress % 10 == 0) {
                this.refresh();
            }
        }
        if (this.progress <= 0 && !this.input.isEmpty() && this.output.isEmpty()) {
            SingleRecipeInput container = new SingleRecipeInput(this.input);
            this.quickCheck.getRecipeFor((RecipeInput)container, level).ifPresentOrElse(recipe -> {
                this.output = ((MillstoneRecipe)recipe.value()).assemble(container, (HolderLookup.Provider)level.registryAccess());
                this.output.setCount(this.output.getCount() * this.input.getCount());
                this.input = ItemStack.EMPTY;
                this.carrier = ((MillstoneRecipe)recipe.value()).getCarrier();
                this.refresh();
            }, () -> {
                this.output = this.input.copyAndClear();
                this.input = ItemStack.EMPTY;
                this.carrier = Ingredient.EMPTY;
                this.refresh();
            });
            NeoForge.EVENT_BUS.post((Event)new MillstoneFinishEvent(this, this.bindEntity));
        }
    }

    @Override
    public boolean onPutItem(Level level, ItemStack putOnItem) {
        if (!this.output.isEmpty()) {
            return false;
        }
        if (this.progress > 0 && !this.input.isEmpty()) {
            return false;
        }
        SingleRecipeInput container = new SingleRecipeInput(putOnItem);
        return this.quickCheck.getRecipeFor((RecipeInput)container, level).map(recipe -> {
            this.input = putOnItem.split(8);
            this.progress = Math.max(Math.round(this.rotSpeedTick), 1);
            this.refresh();
            level.playSound(null, this.worldPosition, SoundEvents.STONE_HIT, SoundSource.BLOCKS, 0.8f, level.random.nextFloat() * 0.2f + 0.9f);
            return true;
        }).orElse(false);
    }

    @Override
    public boolean onTakeItem(LivingEntity user, ItemStack heldItem) {
        if (!this.output.isEmpty()) {
            Item containerItem;
            MillstoneTakeItemEvent event = new MillstoneTakeItemEvent(user, heldItem, this);
            if (((MillstoneTakeItemEvent)NeoForge.EVENT_BUS.post((Event)event)).isCanceled()) {
                return event.isSuccess();
            }
            if (!this.carrier.isEmpty() && !this.carrier.test(heldItem)) {
                Component carrierName = this.carrier.getItems()[0].getHoverName();
                this.sendActionBarMessage(user, "tip.kaleidoscope_cookery.pot.need_carrier", carrierName);
                return false;
            }
            int consumeCount = this.output.getCount();
            if (!this.carrier.isEmpty() && (containerItem = ItemUtils.getContainerItem(heldItem.split(consumeCount = Math.min(consumeCount, heldItem.getCount())))) != Items.AIR) {
                ItemUtils.getItemToLivingEntity(user, containerItem.getDefaultInstance());
            }
            ItemUtils.getItemToLivingEntity(user, this.output.split(consumeCount));
            if (this.output.isEmpty()) {
                this.resetWhenTakeout();
            }
            return true;
        }
        if (!this.input.isEmpty()) {
            ItemUtils.getItemToLivingEntity(user, this.input.copyAndClear());
            this.input = ItemStack.EMPTY;
            this.progress = 0;
            this.refresh();
            return true;
        }
        return false;
    }

    public void resetWhenTakeout() {
        this.output = ItemStack.EMPTY;
        this.carrier = Ingredient.EMPTY;
        this.progress = 0;
        this.refresh();
    }

    public boolean saddleEntityIsControlling(Mob mob) {
        if (!(mob instanceof Saddleable)) {
            return false;
        }
        Saddleable saddleable = (Saddleable)mob;
        return saddleable.isSaddled() && mob.getControllingPassenger() != null;
    }

    public boolean canBindEntity(Mob mob) {
        if (!mob.getType().is(TagMod.MILLSTONE_BINDABLE)) {
            return false;
        }
        if (mob.getVehicle() != null) {
            return false;
        }
        if (mob.isBaby()) {
            return false;
        }
        if (this.saddleEntityIsControlling(mob)) {
            return false;
        }
        if (mob instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)mob;
            return horse.isTamed();
        }
        if (mob instanceof TamableAnimal) {
            TamableAnimal tamableAnimal = (TamableAnimal)mob;
            return tamableAnimal.isTame();
        }
        if (mob instanceof OwnableEntity) {
            OwnableEntity ownable = (OwnableEntity)mob;
            return ownable.getOwnerUUID() != null;
        }
        return true;
    }

    public void bindEntity(Mob mob) {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        if (!mob.isAlive()) {
            return;
        }
        this.entityId = mob.getUUID();
        this.bindEntity = mob;
        float rot = this.getRotation(this.level, 0.0f);
        this.cacheRot -= rot - this.cacheRot;
        MillstoneBindableData data = MillstoneBindableDataReloadListener.INSTANCE.getOrDefault(mob.getType(), MillstoneBindableData.DEFAULT);
        this.rotSpeedTick = data.rotSpeedTick();
        this.liftAngle = data.liftAngle();
        this.offset = data.offset();
        this.refresh();
    }

    public void sendActionBarMessage(LivingEntity user, String key, Object ... args) {
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            MutableComponent message = Component.translatable((String)key, (Object[])args);
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putUUID(ENTITY_ID_KEY, this.entityId);
        tag.putFloat(CACHE_ROT_KEY, this.cacheRot);
        tag.putFloat(ROT_SPEED_TICK_KEY, this.rotSpeedTick);
        tag.putFloat(LIFT_ANGLE_KEY, this.liftAngle);
        if (!this.input.isEmpty()) {
            tag.put(INPUT_ITEM_KEY, this.input.save(registries));
        } else {
            tag.put(INPUT_ITEM_KEY, (Tag)new CompoundTag());
        }
        if (!this.output.isEmpty()) {
            tag.put(OUTPUT_ITEM_KEY, this.output.save(registries));
        } else {
            tag.put(OUTPUT_ITEM_KEY, (Tag)new CompoundTag());
        }
        tag.put(CARRIER_INGREDIENT_KEY, (Tag)Ingredient.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.carrier).getOrThrow());
        tag.putInt(PROGRESS_KEY, this.progress);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.entityId = tag.getUUID(ENTITY_ID_KEY);
        this.cacheRot = tag.getFloat(CACHE_ROT_KEY);
        this.rotSpeedTick = tag.getFloat(ROT_SPEED_TICK_KEY);
        this.liftAngle = tag.getFloat(LIFT_ANGLE_KEY);
        this.input = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(INPUT_ITEM_KEY));
        this.output = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(OUTPUT_ITEM_KEY));
        if (tag.contains(CARRIER_INGREDIENT_KEY, 10)) {
            CompoundTag compound = tag.getCompound(CARRIER_INGREDIENT_KEY);
            this.carrier = (Ingredient)((Pair)Ingredient.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)compound).getOrThrow()).getFirst();
        } else {
            this.carrier = Ingredient.EMPTY;
        }
        this.progress = tag.getInt(PROGRESS_KEY);
    }

    @Nullable
    public IItemHandler createHandler() {
        BlockState state = this.getBlockState();
        if (state.is(ModBlocks.MILLSTONE)) {
            return new MillstoneOutputHandler(this);
        }
        return null;
    }

    public boolean hasEntity() {
        return !Util.NIL_UUID.equals(this.entityId);
    }

    public float getCacheRot() {
        return this.cacheRot;
    }

    public float getLiftAngle() {
        return this.liftAngle;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public Ingredient getCarrier() {
        return this.carrier;
    }

    public float getProgressPercent() {
        float total = Math.max(this.rotSpeedTick, 1.0f);
        return (total - (float)this.progress) / total;
    }
}

