/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.render.block;

import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.ChoppingBoardBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.ChoppingBoardBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;

public class ChoppingBoardBlockEntityRender
implements BlockEntityRenderer<ChoppingBoardBlockEntity> {
    private final ItemRenderer itemRenderer;

    public ChoppingBoardBlockEntityRender(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
    }

    public void render(ChoppingBoardBlockEntity choppingBoard, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ResourceLocation modelId = choppingBoard.getModelId();
        if (modelId == null) {
            return;
        }
        if (choppingBoard.previousModel == null || !modelId.equals((Object)choppingBoard.previousModel.id())) {
            choppingBoard.previousModel = ModelResourceLocation.standalone((ResourceLocation)modelId);
            choppingBoard.cacheModels = new ModelResourceLocation[choppingBoard.getMaxCutCount() + 1];
            for (int i = 0; i <= choppingBoard.getMaxCutCount(); ++i) {
                ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)modelId.getNamespace(), (String)("chopping_board/" + modelId.getPath() + "/" + i));
                choppingBoard.cacheModels[i] = ModelResourceLocation.standalone((ResourceLocation)location);
            }
        }
        if (choppingBoard.cacheModels == null) {
            return;
        }
        int index = Math.min(choppingBoard.getCurrentCutCount(), choppingBoard.cacheModels.length - 1);
        ModelResourceLocation cacheModel = choppingBoard.cacheModels[index];
        poseStack.pushPose();
        int rotation = ((Direction)choppingBoard.getBlockState().getValue((Property)ChoppingBoardBlock.FACING)).get2DDataValue();
        poseStack.translate(0.5, 0.0, 0.5);
        poseStack.mulPose(Axis.YP.rotationDegrees((float)(rotation * 90)));
        poseStack.translate(-0.5, 0.125, -0.5);
        BakedModel model = this.itemRenderer.getItemModelShaper().getModelManager().getModel(cacheModel);
        RenderType renderType = Sheets.cutoutBlockSheet();
        VertexConsumer vertexConsumer = ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (boolean)false);
        this.itemRenderer.renderModelLists(model, ItemStack.EMPTY, packedLight, packedOverlay, poseStack, vertexConsumer);
        poseStack.popPose();
    }
}

