/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.render.entity;

import com.github.ysbbbbbb.kaleidoscopecookery.client.model.ScarecrowModel;
import com.github.ysbbbbbb.kaleidoscopecookery.client.render.entity.layer.ScarecrowHandLayer;
import com.github.ysbbbbbb.kaleidoscopecookery.client.render.entity.layer.ScarecrowParrotOnShoulderLayer;
import com.github.ysbbbbbb.kaleidoscopecookery.entity.ScarecrowEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ScarecrowRender
extends LivingEntityRenderer<ScarecrowEntity, ScarecrowModel> {
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"textures/entity/scarecrow.png");

    public ScarecrowRender(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ScarecrowModel(context.bakeLayer(ScarecrowModel.LAYER_LOCATION)), 0.0f);
        this.addLayer((RenderLayer)new ScarecrowHandLayer(this, context.getItemInHandRenderer(), context.getBlockRenderDispatcher()));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
        this.addLayer(new ScarecrowParrotOnShoulderLayer((RenderLayerParent<ScarecrowEntity, ScarecrowModel>)this, context.getModelSet()));
    }

    protected void setupRotations(ScarecrowEntity scarecrow, PoseStack poseStack, float bob, float yBodyRot, float partialTick, float scale) {
        poseStack.mulPose(Axis.YP.rotationDegrees(180.0f - yBodyRot));
        float time = (float)(scarecrow.level().getGameTime() - scarecrow.lastHit) + partialTick;
        if (time < 5.0f) {
            poseStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(time / 1.5f * (float)Math.PI)) * 3.0f));
        }
    }

    protected boolean shouldShowName(ScarecrowEntity scarecrow) {
        double distance = this.entityRenderDispatcher.distanceToSqr((Entity)scarecrow);
        return distance < 4096.0 && scarecrow.isCustomNameVisible();
    }

    public ResourceLocation getTextureLocation(ScarecrowEntity pEntity) {
        return TEXTURE;
    }
}

