/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.tooltip;

import com.github.ysbbbbbb.kaleidoscopecookery.inventory.tooltip.RecipeItemTooltip;
import com.github.ysbbbbbb.kaleidoscopecookery.item.RecipeItem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class ClientRecipeItemTooltip
implements ClientTooltipComponent {
    private final RecipeItem.RecipeRecord recipeRecord;
    private final MutableComponent ingredientsText;
    private final MutableComponent outputText;

    public ClientRecipeItemTooltip(RecipeItemTooltip containerTooltip) {
        this.recipeRecord = containerTooltip.record();
        this.ingredientsText = Component.translatable((String)"tooltip.kaleidoscope_cookery.recipe_item.ingredient");
        this.outputText = Component.translatable((String)"tooltip.kaleidoscope_cookery.recipe_item.output");
    }

    public int getHeight() {
        return 28;
    }

    public int getWidth(Font font) {
        int ingredientsSize = this.recipeRecord.input().size() * 12 + font.width((FormattedText)this.ingredientsText) + 2;
        int outputSize = font.width((FormattedText)this.outputText) + 20;
        return Math.max(ingredientsSize, outputSize);
    }

    public void renderImage(Font font, int pX, int pY, GuiGraphics guiGraphics) {
        int ingredientsWidth = font.width((FormattedText)this.ingredientsText);
        int outputWidth = font.width((FormattedText)this.outputText);
        guiGraphics.drawString(font, (Component)this.ingredientsText, pX, pY + 4, ChatFormatting.GRAY.getColor().intValue());
        int i = 0;
        for (ItemStack stack : this.recipeRecord.input()) {
            int xOffset = pX + ingredientsWidth + i * 12;
            guiGraphics.renderFakeItem(stack, xOffset, pY);
            ++i;
        }
        int xOffset = pX + outputWidth;
        int yOffset = pY + 12;
        guiGraphics.drawString(font, (Component)this.outputText, pX, yOffset + 4, ChatFormatting.GRAY.getColor().intValue());
        ItemStack stack = this.recipeRecord.output();
        guiGraphics.renderFakeItem(stack, xOffset, yOffset);
        guiGraphics.renderItemDecorations(font, stack, xOffset, yOffset);
    }
}

