/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.compat.jade.block;

import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.ShawarmaSpitBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.ShawarmaSpitBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.compat.jade.ModPlugin;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ITextElement;

public enum ShawarmaSpitComponentProvider implements IBlockComponentProvider
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig pluginConfig) {
        BlockEntity blockEntity;
        BlockEntity blockEntity2 = accessor.getBlockEntity();
        if (!(blockEntity2 instanceof ShawarmaSpitBlockEntity)) {
            return;
        }
        ShawarmaSpitBlockEntity shawarmaSpitFirst = (ShawarmaSpitBlockEntity)blockEntity2;
        Level level = accessor.getLevel();
        BlockPos pos = accessor.getPosition();
        DoubleBlockHalf value = (DoubleBlockHalf)accessor.getBlockState().getValue(ShawarmaSpitBlock.HALF);
        if (value == DoubleBlockHalf.LOWER && (blockEntity = level.getBlockEntity(pos.above())) instanceof ShawarmaSpitBlockEntity) {
            ShawarmaSpitBlockEntity shawarmaSpitSecond = (ShawarmaSpitBlockEntity)blockEntity;
            this.addItemInfo(tooltip, shawarmaSpitSecond);
            this.addItemInfo(tooltip, shawarmaSpitFirst);
            return;
        }
        if (value == DoubleBlockHalf.UPPER && (blockEntity = level.getBlockEntity(pos.below())) instanceof ShawarmaSpitBlockEntity) {
            ShawarmaSpitBlockEntity shawarmaSpitSecond = (ShawarmaSpitBlockEntity)blockEntity;
            this.addItemInfo(tooltip, shawarmaSpitFirst);
            this.addItemInfo(tooltip, shawarmaSpitSecond);
        }
    }

    private void addItemInfo(ITooltip tooltip, ShawarmaSpitBlockEntity shawarmaSpit) {
        ItemStack showItem;
        IElementHelper helper = IElementHelper.get();
        ItemStack itemStack = showItem = shawarmaSpit.cookingItem.isEmpty() ? shawarmaSpit.cookedItem : shawarmaSpit.cookingItem;
        if (!showItem.isEmpty()) {
            IElement icon = helper.smallItem(showItem.copyWithCount(1));
            MutableComponent stackName = IDisplayHelper.get().stripColor(showItem.getHoverName());
            ITextElement text = helper.text((Component)Component.literal((String)"%d\u00d7".formatted(showItem.getCount())).append((Component)stackName).withStyle(ChatFormatting.GRAY));
            tooltip.add(icon);
            tooltip.append(helper.spacer(3, 1));
            tooltip.append((IElement)text);
            if (shawarmaSpit.cookTime > 0) {
                tooltip.append(helper.spacer(3, 1));
                tooltip.append((Component)IThemeHelper.get().seconds(shawarmaSpit.cookTime, 20.0f).withStyle(ChatFormatting.GRAY));
            }
        }
    }

    public ResourceLocation getUid() {
        return ModPlugin.SHAWARMA_SPIT;
    }
}

