/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen;

import com.github.ysbbbbbb.kaleidoscopecookery.datagen.AdvancementGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.DataMapGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.GlobalLootModifier;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.LootTableGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.ModRecipeGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.ParticleDescriptionGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.SoundDefinitionsGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.model.BlockModelGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.model.BlockStateGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.model.ItemModelGenerator;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.tag.TagBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.tag.TagDamage;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.tag.TagEntityType;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.tag.TagItem;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.tag.TagPoiType;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        CompletableFuture registries = event.getLookupProvider();
        DataGenerator.PackGenerator vanillaPack = generator.getVanillaPack(true);
        ExistingFileHelper helper = event.getExistingFileHelper();
        PackOutput pack = generator.getPackOutput();
        TagBlock block = (TagBlock)vanillaPack.addProvider(packOutput -> new TagBlock(packOutput, registries, helper));
        vanillaPack.addProvider(packOutput -> new TagItem(packOutput, registries, block.contentsGetter(), helper));
        vanillaPack.addProvider(packOutput -> new TagPoiType(packOutput, registries, helper));
        vanillaPack.addProvider(packOutput -> new TagEntityType(packOutput, registries, helper));
        vanillaPack.addProvider(packOutput -> new TagDamage(packOutput, registries, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new DataMapGenerator(pack, registries));
        generator.addProvider(event.includeServer(), (DataProvider)new AdvancementGenerator(pack, registries, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableGenerator(pack, registries));
        generator.addProvider(event.includeServer(), (DataProvider)new ModRecipeGenerator(pack, registries));
        generator.addProvider(event.includeServer(), (DataProvider)new GlobalLootModifier(pack, registries));
        generator.addProvider(event.includeClient(), (DataProvider)new ParticleDescriptionGenerator(pack, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockModelGenerator(pack, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new BlockStateGenerator(pack, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelGenerator(pack, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new SoundDefinitionsGenerator(pack, helper));
    }
}

