/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.builder;

import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.PotRecipe;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;

public class PotRecipeBuilder
implements RecipeBuilder {
    private static final String NAME = "pot";
    private int time = 200;
    private int stirFryCount = 3;
    private Ingredient carrier = Ingredient.EMPTY;
    private List<Ingredient> ingredients = Lists.newArrayList();
    private ItemStack result = ItemStack.EMPTY;

    public static PotRecipeBuilder builder() {
        return new PotRecipeBuilder();
    }

    public PotRecipeBuilder setTime(int time) {
        this.time = time;
        return this;
    }

    public PotRecipeBuilder setStirFryCount(int stirFryCount) {
        this.stirFryCount = stirFryCount;
        return this;
    }

    public PotRecipeBuilder setCarrier(Ingredient ingredient) {
        this.carrier = ingredient;
        return this;
    }

    public PotRecipeBuilder setCarrier(ItemLike itemLike) {
        this.carrier = Ingredient.of((ItemLike[])new ItemLike[]{itemLike});
        return this;
    }

    public PotRecipeBuilder setBowlCarrier() {
        this.carrier = Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL});
        return this;
    }

    public PotRecipeBuilder addInput(Object ... ingredients) {
        for (Object ingredient : ingredients) {
            if (ingredient instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)ingredient;
                this.ingredients.add(Ingredient.of((ItemLike[])new ItemLike[]{itemLike}));
                continue;
            }
            if (ingredient instanceof ItemStack) {
                ItemStack stack = (ItemStack)ingredient;
                this.ingredients.add(Ingredient.of((ItemStack[])new ItemStack[]{stack}));
                continue;
            }
            if (ingredient instanceof TagKey) {
                TagKey tagKey = (TagKey)ingredient;
                this.ingredients.add(Ingredient.of((TagKey)tagKey));
                continue;
            }
            if (ingredient instanceof Ingredient) {
                Ingredient ingredientObj = (Ingredient)ingredient;
                this.ingredients.add(ingredientObj);
                continue;
            }
            if (!(ingredient instanceof DeferredItem)) continue;
            DeferredItem deferredItem = (DeferredItem)ingredient;
            this.ingredients.add(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)deferredItem.get()}));
        }
        return this;
    }

    public PotRecipeBuilder setResult(Item result) {
        this.result = new ItemStack((ItemLike)result);
        return this;
    }

    public PotRecipeBuilder setResult(ResourceLocation result) {
        this.result = new ItemStack((ItemLike)Objects.requireNonNull((Item)BuiltInRegistries.ITEM.get(result)));
        return this;
    }

    public PotRecipeBuilder setResult(Item result, int count) {
        this.result = new ItemStack((ItemLike)result, count);
        return this;
    }

    public PotRecipeBuilder setResult(ResourceLocation result, int count) {
        this.result = new ItemStack((ItemLike)Objects.requireNonNull((Item)BuiltInRegistries.ITEM.get(result)), count);
        return this;
    }

    public PotRecipeBuilder setResult(ItemStack result) {
        this.result = result;
        return this;
    }

    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        return this;
    }

    public RecipeBuilder group(@Nullable String groupName) {
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput output) {
        String path = RecipeBuilder.getDefaultRecipeId((ItemLike)this.getResult()).getPath();
        ResourceLocation filePath = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)("pot/" + path));
        this.save(output, filePath);
    }

    public void save(RecipeOutput output, String recipeId) {
        ResourceLocation filePath = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)("pot/" + recipeId));
        this.save(output, filePath);
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation id) {
        recipeOutput.accept(id, (Recipe)new PotRecipe(this.time, this.stirFryCount, this.carrier, this.ingredients, this.result), null);
    }
}

