/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.builder;

import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.StockpotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.serializer.StockpotRecipeSerializer;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.Nullable;

public class StockpotRecipeBuilder
implements RecipeBuilder {
    private static final String NAME = "stockpot";
    private List<Ingredient> ingredients = Lists.newArrayList();
    private ItemStack result = ItemStack.EMPTY;
    private int time = 300;
    private Ingredient carrier = StockpotRecipeSerializer.DEFAULT_CARRIER;
    private ResourceLocation soupBase = StockpotRecipeSerializer.DEFAULT_SOUP_BASE;
    private ResourceLocation cookingTexture = StockpotRecipeSerializer.DEFAULT_COOKING_TEXTURE;
    private ResourceLocation finishedTexture = StockpotRecipeSerializer.DEFAULT_FINISHED_TEXTURE;
    private int cookingBubbleColor = 16772291;
    private int finishedBubbleColor = 16034443;

    public static StockpotRecipeBuilder builder() {
        return new StockpotRecipeBuilder();
    }

    public StockpotRecipeBuilder addInput(Object ... ingredients) {
        for (Object ingredient : ingredients) {
            if (ingredient instanceof ItemLike) {
                ItemLike itemLike = (ItemLike)ingredient;
                this.ingredients.add(Ingredient.of((ItemLike[])new ItemLike[]{itemLike}));
                continue;
            }
            if (ingredient instanceof ItemStack) {
                ItemStack stack = (ItemStack)ingredient;
                this.ingredients.add(Ingredient.of((ItemStack[])new ItemStack[]{stack}));
                continue;
            }
            if (ingredient instanceof TagKey) {
                TagKey tagKey = (TagKey)ingredient;
                this.ingredients.add(Ingredient.of((TagKey)tagKey));
                continue;
            }
            if (ingredient instanceof Ingredient) {
                Ingredient ingredientObj = (Ingredient)ingredient;
                this.ingredients.add(ingredientObj);
                continue;
            }
            if (!(ingredient instanceof DeferredItem)) continue;
            DeferredItem deferredItem = (DeferredItem)ingredient;
            this.ingredients.add(Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)deferredItem.get()}));
        }
        return this;
    }

    public StockpotRecipeBuilder setSoupBase(ResourceLocation soupBase) {
        this.soupBase = soupBase;
        return this;
    }

    public StockpotRecipeBuilder setResult(Item result) {
        this.result = new ItemStack((ItemLike)result, 3);
        return this;
    }

    public StockpotRecipeBuilder setResult(Item result, int count) {
        return this.setResult(new ItemStack((ItemLike)result, count));
    }

    public StockpotRecipeBuilder setResult(ResourceLocation result) {
        this.result = new ItemStack((ItemLike)Objects.requireNonNull((Item)BuiltInRegistries.ITEM.get(result)));
        return this;
    }

    public StockpotRecipeBuilder setResult(ItemStack result) {
        this.result = result;
        return this;
    }

    public StockpotRecipeBuilder setTime(int time) {
        this.time = time;
        return this;
    }

    public StockpotRecipeBuilder setCarrier(ItemLike carrier) {
        this.carrier = Ingredient.of((ItemLike[])new ItemLike[]{carrier});
        return this;
    }

    public StockpotRecipeBuilder setCookingTexture(ResourceLocation cookingTexture) {
        this.cookingTexture = cookingTexture;
        return this;
    }

    public StockpotRecipeBuilder setFinishedTexture(ResourceLocation finishedTexture) {
        this.finishedTexture = finishedTexture;
        return this;
    }

    public StockpotRecipeBuilder setCookingBubbleColor(int cookingBubbleColor) {
        this.cookingBubbleColor = cookingBubbleColor;
        return this;
    }

    public StockpotRecipeBuilder setFinishedBubbleColor(int finishedBubbleColor) {
        this.finishedBubbleColor = finishedBubbleColor;
        return this;
    }

    public StockpotRecipeBuilder setBubbleColors(int cookingBubbleColor, int finishedBubbleColor) {
        this.cookingBubbleColor = cookingBubbleColor;
        this.finishedBubbleColor = finishedBubbleColor;
        return this;
    }

    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        return this;
    }

    public RecipeBuilder group(@Nullable String groupName) {
        return this;
    }

    public Item getResult() {
        return this.result.getItem();
    }

    public void save(RecipeOutput output) {
        String path = RecipeBuilder.getDefaultRecipeId((ItemLike)this.getResult()).getPath();
        ResourceLocation filePath = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)("stockpot/" + path));
        this.save(output, filePath);
    }

    public void save(RecipeOutput output, String recipeId) {
        ResourceLocation filePath = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)("stockpot/" + recipeId));
        this.save(output, filePath);
    }

    public void save(RecipeOutput recipeOutput, ResourceLocation id) {
        recipeOutput.accept(id, (Recipe)new StockpotRecipe(this.ingredients, this.soupBase, this.result, this.time, this.carrier, this.cookingTexture, this.finishedTexture, this.cookingBubbleColor, this.finishedBubbleColor), null);
    }
}

