/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.lootable;

import com.github.ysbbbbbb.kaleidoscopecookery.block.crop.RiceCropBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.food.FoodBiteBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.EnamelBasinBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.misc.ChiliRistraBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.loot.AdvanceBlockMatchTool;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.EmptyLootItem;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ExplosionCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class BlockLootTables
extends BlockLootSubProvider {
    public final Set<Block> knownBlocks = new HashSet<Block>();
    public final HolderLookup.RegistryLookup<Enchantment> enchantment = this.registries.lookupOrThrow(Registries.ENCHANTMENT);

    public BlockLootTables(HolderLookup.Provider registries) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), registries);
    }

    public void generate() {
        this.dropSelf((Block)ModBlocks.STOVE.get());
        this.dropSelf((Block)ModBlocks.POT.get());
        this.dropSelf((Block)ModBlocks.CHOPPING_BOARD.get());
        this.dropSelf((Block)ModBlocks.OIL_POT.get());
        this.dropSelf((Block)ModBlocks.COOK_STOOL_OAK.get());
        this.dropSelf((Block)ModBlocks.COOK_STOOL_SPRUCE.get());
        this.dropSelf((Block)ModBlocks.COOK_STOOL_ACACIA.get());
        this.dropSelf((Block)ModBlocks.COOK_STOOL_BAMBOO.get());
        this.dropSelf((Block)ModBlocks.COOK_STOOL_BIRCH.get());
        this.dropSelf((Block)ModBlocks.COOK_STOOL_CHERRY.get());
        this.dropSelf((Block)ModBlocks.COOK_STOOL_CRIMSON.get());
        this.dropSelf((Block)ModBlocks.COOK_STOOL_DARK_OAK.get());
        this.dropSelf((Block)ModBlocks.COOK_STOOL_JUNGLE.get());
        this.dropSelf((Block)ModBlocks.COOK_STOOL_MANGROVE.get());
        this.dropSelf((Block)ModBlocks.COOK_STOOL_WARPED.get());
        this.dropSelf((Block)ModBlocks.CHAIR_OAK.get());
        this.dropSelf((Block)ModBlocks.CHAIR_SPRUCE.get());
        this.dropSelf((Block)ModBlocks.CHAIR_ACACIA.get());
        this.dropSelf((Block)ModBlocks.CHAIR_BAMBOO.get());
        this.dropSelf((Block)ModBlocks.CHAIR_BIRCH.get());
        this.dropSelf((Block)ModBlocks.CHAIR_CHERRY.get());
        this.dropSelf((Block)ModBlocks.CHAIR_CRIMSON.get());
        this.dropSelf((Block)ModBlocks.CHAIR_DARK_OAK.get());
        this.dropSelf((Block)ModBlocks.CHAIR_JUNGLE.get());
        this.dropSelf((Block)ModBlocks.CHAIR_MANGROVE.get());
        this.dropSelf((Block)ModBlocks.CHAIR_WARPED.get());
        this.dropSelf((Block)ModBlocks.TABLE_OAK.get());
        this.dropSelf((Block)ModBlocks.TABLE_SPRUCE.get());
        this.dropSelf((Block)ModBlocks.TABLE_ACACIA.get());
        this.dropSelf((Block)ModBlocks.TABLE_BAMBOO.get());
        this.dropSelf((Block)ModBlocks.TABLE_BIRCH.get());
        this.dropSelf((Block)ModBlocks.TABLE_CHERRY.get());
        this.dropSelf((Block)ModBlocks.TABLE_CRIMSON.get());
        this.dropSelf((Block)ModBlocks.TABLE_DARK_OAK.get());
        this.dropSelf((Block)ModBlocks.TABLE_JUNGLE.get());
        this.dropSelf((Block)ModBlocks.TABLE_MANGROVE.get());
        this.dropSelf((Block)ModBlocks.TABLE_WARPED.get());
        this.dropSelf((Block)ModBlocks.STOCKPOT.get());
        this.dropSelf((Block)ModBlocks.FRUIT_BASKET.get());
        this.dropSelf((Block)ModBlocks.KITCHENWARE_RACKS.get());
        this.dropSelf((Block)ModBlocks.STRAW_BLOCK.get());
        this.dropSelf((Block)ModBlocks.SHAWARMA_SPIT.get());
        this.dropSelf((Block)ModBlocks.OIL_BLOCK.get());
        this.add((Block)ModBlocks.TOMATO_CROP.get(), this.createCropDrops((Block)ModBlocks.TOMATO_CROP.get(), (Item)ModItems.TOMATO.get(), (Item)ModItems.TOMATO_SEED.get(), this.createCropBuilder((Block)ModBlocks.TOMATO_CROP.get())));
        LootItemCondition.Builder chiliBuilder = this.createCropBuilder((Block)ModBlocks.CHILI_CROP.get());
        LootPoolSingletonContainer.Builder greenChili = (LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.GREEN_CHILI.get())).when(LootItemRandomChanceCondition.randomChance((float)0.2f));
        this.add((Block)ModBlocks.CHILI_CROP.get(), this.createCropDrops((Block)ModBlocks.CHILI_CROP.get(), (Item)ModItems.RED_CHILI.get(), (Item)ModItems.CHILI_SEED.get(), chiliBuilder).withPool(LootPool.lootPool().when(chiliBuilder).add((LootPoolEntryContainer.Builder)greenChili)));
        LootItemCondition.Builder lettuceBuilder = this.createCropBuilder((Block)ModBlocks.LETTUCE_CROP.get());
        LootPoolSingletonContainer.Builder caterpillar = (LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.CATERPILLAR.get())).when(LootItemRandomChanceCondition.randomChance((float)0.1f));
        this.add((Block)ModBlocks.LETTUCE_CROP.get(), this.createCropDrops((Block)ModBlocks.LETTUCE_CROP.get(), (Item)ModItems.LETTUCE.get(), (Item)ModItems.LETTUCE_SEED.get(), lettuceBuilder).withPool(LootPool.lootPool().when(lettuceBuilder).add((LootPoolEntryContainer.Builder)caterpillar)));
        Item riceSeed = (Item)ModItems.WILD_RICE_SEED.get();
        LootItemCondition.Builder riceCropBuilder = this.createRiceCropBuilder();
        LootItemConditionalFunction.Builder countFunction = SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)2.0f, (float)4.0f));
        LootPool.Builder ricePanicle = LootPool.lootPool().add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.RICE_PANICLE.get())).when(riceCropBuilder)).apply((LootItemFunction.Builder)countFunction).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)riceSeed)));
        LootPool.Builder extraRiceSeeds = LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)riceSeed)).when(riceCropBuilder).apply((LootItemFunction.Builder)ApplyBonusCount.addBonusBinomialDistributionCount((Holder)this.enchantment.getOrThrow(Enchantments.FORTUNE), (float)0.5714286f, (int)3));
        this.add((Block)ModBlocks.RICE_CROP.get(), (LootTable.Builder)this.applyExplosionDecay((ItemLike)ModBlocks.RICE_CROP.get(), (FunctionUserBuilder)LootTable.lootTable().withPool(ricePanicle).withPool(extraRiceSeeds)));
        FoodBiteRegistry.FOOD_DATA_MAP.forEach(this::dropFoodBite);
        this.add((Block)ModBlocks.ENAMEL_BASIN.get(), this.createEnamelBasinLootTable());
        this.add((Block)ModBlocks.CHILI_RISTRA.get(), this.createChiliRistraLootTable());
    }

    private LootTable.Builder createChiliRistraLootTable() {
        LootPool.Builder builder = LootPool.lootPool();
        StatePropertiesPredicate.Builder isSheared = StatePropertiesPredicate.Builder.properties().hasProperty((Property)ChiliRistraBlock.SHEARED, true);
        LootItemBlockStatePropertyCondition.Builder condition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)ModBlocks.CHILI_RISTRA.get())).setProperties(isSheared);
        LootItemConditionalFunction.Builder normalDrop = SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)6.0f));
        LootItemConditionalFunction.Builder shearedDrop = SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)3.0f));
        LootPoolSingletonContainer.Builder normalLoot = LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.RED_CHILI.get())).apply((LootItemFunction.Builder)normalDrop);
        LootPoolSingletonContainer.Builder shearedLoot = LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.RED_CHILI.get())).apply((LootItemFunction.Builder)shearedDrop);
        builder.add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)shearedLoot.when((LootItemCondition.Builder)condition)).otherwise((LootPoolEntryContainer.Builder)normalLoot));
        return LootTable.lootTable().withPool(builder.when(ExplosionCondition.survivesExplosion()));
    }

    private LootTable.Builder createEnamelBasinLootTable() {
        LootPool.Builder oilDrop = LootPool.lootPool();
        for (int i = 1; i <= 12; ++i) {
            StatePropertiesPredicate.Builder property = StatePropertiesPredicate.Builder.properties().hasProperty((Property)EnamelBasinBlock.OIL_COUNT, i);
            LootItemBlockStatePropertyCondition.Builder condition = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)ModBlocks.ENAMEL_BASIN.get())).setProperties(property);
            int dropCount = i / 2;
            if (dropCount <= 0) continue;
            LootItemConditionalFunction.Builder count = SetItemCountFunction.setCount((NumberProvider)ConstantValue.exactly((float)dropCount));
            oilDrop.add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.OIL.get())).when((LootItemCondition.Builder)condition)).apply((LootItemFunction.Builder)count));
        }
        LootPool.Builder bucketDrop = LootPool.lootPool().add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.BUCKET));
        return LootTable.lootTable().withPool(oilDrop.when(ExplosionCondition.survivesExplosion())).withPool(bucketDrop.when(ExplosionCondition.survivesExplosion()));
    }

    private LootItemCondition.Builder createCropBuilder(Block cropBlock) {
        StatePropertiesPredicate.Builder property = StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlock.AGE, 7);
        return LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)cropBlock).setProperties(property);
    }

    private LootItemCondition.Builder createRiceCropBuilder() {
        StatePropertiesPredicate.Builder property = StatePropertiesPredicate.Builder.properties().hasProperty((Property)CropBlock.AGE, 7).hasProperty((Property)RiceCropBlock.LOCATION, 0);
        return LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)((Block)ModBlocks.RICE_CROP.get())).setProperties(property);
    }

    public void generate(BiConsumer<ResourceKey<LootTable>, LootTable.Builder> output) {
        super.generate(output);
        LootPoolSingletonContainer.Builder<?> tomato = this.getSeed((ItemLike)ModItems.TOMATO_SEED.get());
        LootPoolSingletonContainer.Builder<?> chili = this.getSeed((ItemLike)ModItems.CHILI_SEED.get());
        LootPoolSingletonContainer.Builder<?> lettuce = this.getSeed((ItemLike)ModItems.LETTUCE_SEED.get());
        LootPoolSingletonContainer.Builder<?> rice = this.getSeed((ItemLike)ModItems.WILD_RICE_SEED.get());
        LootTable.Builder dropSeed = LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(tomato).add(chili).add(lettuce).add(rice));
        ResourceKey id = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)this.modLoc("straw_hat_seed_drop"));
        output.accept((ResourceKey<LootTable>)id, dropSeed);
    }

    private LootPoolSingletonContainer.Builder<?> getSeed(ItemLike item) {
        ItemPredicate hasHat = ItemPredicate.Builder.item().of(TagMod.STRAW_HAT).build();
        LootItemCondition.Builder hatMatches = AdvanceBlockMatchTool.toolMatches(EquipmentSlot.HEAD, hasHat);
        return ((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)item).when(LootItemRandomChanceCondition.randomChance((float)0.125f))).when(hatMatches)).apply((LootItemFunction.Builder)ApplyBonusCount.addUniformBonusCount((Holder)this.enchantment.getOrThrow(Enchantments.FORTUNE), (int)2));
    }

    private void dropFoodBite(ResourceLocation id, FoodBiteRegistry.FoodData data) {
        Block block = (Block)BuiltInRegistries.BLOCK.get(id);
        Item food = (Item)BuiltInRegistries.ITEM.get(id);
        if (!(block instanceof FoodBiteBlock)) {
            return;
        }
        FoodBiteBlock foodBiteBlock = (FoodBiteBlock)block;
        ConstantValue exactly = ConstantValue.exactly((float)1.0f);
        StatePropertiesPredicate.Builder notBite = StatePropertiesPredicate.Builder.properties().hasProperty((Property)foodBiteBlock.getBites(), 0);
        LootItemBlockStatePropertyCondition.Builder builder = LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)foodBiteBlock).setProperties(notBite);
        LootTable.Builder lootTable = LootTable.lootTable();
        for (int i = 0; i < data.getLootItems().size(); ++i) {
            ItemLike itemLike = data.getLootItems().get(i);
            LootPool.Builder rolls = LootPool.lootPool().setRolls((NumberProvider)exactly).when(ExplosionCondition.survivesExplosion());
            if (i == 0) {
                rolls.add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.lootTableItem((ItemLike)food).when((LootItemCondition.Builder)builder)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)itemLike)));
            } else {
                rolls.add((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)EmptyLootItem.emptyItem().when((LootItemCondition.Builder)builder)).otherwise((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)itemLike)));
            }
            lootTable.withPool(rolls);
        }
        this.add(block, lootTable);
    }

    public void add(Block block, LootTable.Builder builder) {
        this.knownBlocks.add(block);
        super.add(block, builder);
    }

    public Iterable<Block> getKnownBlocks() {
        return this.knownBlocks;
    }

    public ResourceLocation modLoc(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)name);
    }
}

