/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.recipe;

import com.github.ysbbbbbb.kaleidoscopecookery.datagen.builder.PotRecipeBuilder;
import com.github.ysbbbbbb.kaleidoscopecookery.datagen.recipe.ModRecipeProvider;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.level.ItemLike;

public class SimpleCookingRecipeProvider
extends ModRecipeProvider {
    public SimpleCookingRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    @Override
    public void buildRecipes(RecipeOutput consumer) {
        this.simpleCookingRecipe((ItemLike)ModItems.RAW_LAMB_CHOPS.get(), (ItemLike)ModItems.COOKED_LAMB_CHOPS.get(), 0.35f, consumer);
        this.simpleCookingRecipe((ItemLike)ModItems.RAW_COW_OFFAL.get(), (ItemLike)ModItems.COOKED_COW_OFFAL.get(), 0.35f, consumer);
        this.simpleCookingRecipe((ItemLike)ModItems.RAW_PORK_BELLY.get(), (ItemLike)ModItems.COOKED_PORK_BELLY.get(), 0.35f, consumer);
        this.simpleCookingRecipe((ItemLike)ModItems.RAW_DONKEY_MEAT.get(), (ItemLike)ModItems.COOKED_DONKEY_MEAT.get(), 0.35f, consumer);
        this.vanillaCookingRecipe((ItemLike)ModItems.STUFFED_DOUGH_FOOD.get(), (ItemLike)ModItems.SAMSA.get(), 0.35f, consumer);
    }

    public void simpleCookingRecipe(ItemLike input, ItemLike output, float experience, RecipeOutput consumer) {
        this.vanillaCookingRecipe(input, output, experience, consumer);
        PotRecipeBuilder.builder().addInput(input).setResult(output.asItem()).save(consumer);
    }

    public void vanillaCookingRecipe(ItemLike input, ItemLike output, float experience, RecipeOutput consumer) {
        SimpleCookingRecipeProvider.simpleCookingRecipe((RecipeOutput)consumer, (String)"smoking", (RecipeSerializer)RecipeSerializer.SMOKING_RECIPE, SmokingRecipe::new, (int)100, (ItemLike)input, (ItemLike)output, (float)experience);
        SimpleCookingRecipeProvider.simpleCookingRecipe((RecipeOutput)consumer, (String)"campfire_cooking", (RecipeSerializer)RecipeSerializer.CAMPFIRE_COOKING_RECIPE, CampfireCookingRecipe::new, (int)600, (ItemLike)input, (ItemLike)output, (float)experience);
        SimpleCookingRecipeProvider.simpleCookingRecipe((RecipeOutput)consumer, (String)"smelting", (RecipeSerializer)RecipeSerializer.SMELTING_RECIPE, SmeltingRecipe::new, (int)200, (ItemLike)input, (ItemLike)output, (float)experience);
    }
}

