/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.effect;

import com.github.ysbbbbbb.kaleidoscopecookery.effect.BaseEffect;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class WarmthEffect
extends BaseEffect {
    public WarmthEffect(int color) {
        super(color);
    }

    @Override
    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 20 == 0;
    }

    @Override
    public boolean applyEffectTick(LivingEntity livingEntity, int amplifier) {
        if (livingEntity.getHealth() >= livingEntity.getMaxHealth()) {
            return true;
        }
        BlockPos.MutableBlockPos mutable = livingEntity.blockPosition().mutable();
        for (int x = -2; x <= 2; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    boolean hasLit;
                    BlockState blockState = livingEntity.level().getBlockState(mutable.offset(x, y, z));
                    boolean bl = hasLit = blockState.hasProperty((Property)BlockStateProperties.LIT) && (Boolean)blockState.getValue((Property)BlockStateProperties.LIT) != false;
                    if (!hasLit && !blockState.is(TagMod.WARMTH_HEAT_SOURCE_BLOCKS)) continue;
                    livingEntity.heal(1.0f);
                    return true;
                }
            }
        }
        if (livingEntity.level().dimension().equals(Level.NETHER) && livingEntity.getRandom().nextInt(4) == 0) {
            livingEntity.heal(0.5f);
        }
        return true;
    }
}

