/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.event;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;

@EventBusSubscriber(modid="kaleidoscope_cookery")
public class AddVillageStructuresEvent {
    private static final ResourceKey<StructureProcessorList> CROP_REPLACE_PROCESSOR_LIST_KEY = ResourceKey.create((ResourceKey)Registries.PROCESSOR_LIST, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"crop_replace"));
    private static final ResourceLocation PLAINS = ResourceLocation.parse((String)"minecraft:village/plains/houses");
    private static final ResourceLocation SNOWY = ResourceLocation.parse((String)"minecraft:village/snowy/houses");
    private static final ResourceLocation SAVANNA = ResourceLocation.parse((String)"minecraft:village/savanna/houses");
    private static final ResourceLocation DESERT = ResourceLocation.parse((String)"minecraft:village/desert/houses");
    private static final ResourceLocation TAIGA = ResourceLocation.parse((String)"minecraft:village/taiga/houses");

    @SubscribeEvent
    public static void addVillageStructures(ServerAboutToStartEvent event) {
        RegistryAccess.Frozen registryAccess = event.getServer().registryAccess();
        AddVillageStructuresEvent.addBuildingToPool((RegistryAccess)registryAccess, PLAINS, "village/houses/plains_kitchen", 4);
        AddVillageStructuresEvent.addBuildingToPool((RegistryAccess)registryAccess, SNOWY, "village/houses/snowy_kitchen", 4);
        AddVillageStructuresEvent.addBuildingToPool((RegistryAccess)registryAccess, SAVANNA, "village/houses/savanna_kitchen", 4);
        AddVillageStructuresEvent.addBuildingToPool((RegistryAccess)registryAccess, DESERT, "village/houses/desert_kitchen", 4);
        AddVillageStructuresEvent.addBuildingToPool((RegistryAccess)registryAccess, TAIGA, "village/houses/taiga_kitchen", 4);
    }

    public static void addBuildingToPool(RegistryAccess registryAccess, ResourceLocation poolId, String structId, int weight) {
        Optional templatePools = registryAccess.registry(Registries.TEMPLATE_POOL);
        if (templatePools.isEmpty()) {
            return;
        }
        Optional processorLists = registryAccess.registry(Registries.PROCESSOR_LIST);
        if (processorLists.isEmpty()) {
            return;
        }
        StructureTemplatePool pool = (StructureTemplatePool)((Registry)templatePools.get()).get(poolId);
        if (pool == null) {
            return;
        }
        Holder.Reference holder = ((Registry)processorLists.get()).getHolderOrThrow(CROP_REPLACE_PROCESSOR_LIST_KEY);
        ResourceLocation structLocation = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)structId);
        SinglePoolElement piece = (SinglePoolElement)SinglePoolElement.legacy((String)structLocation.toString(), (Holder)holder).apply(StructureTemplatePool.Projection.RIGID);
        for (int i = 0; i < weight; ++i) {
            pool.templates.add((Object)piece);
        }
        ArrayList newRawTemplates = Lists.newArrayList((Iterable)pool.rawTemplates);
        newRawTemplates.add(Pair.of((Object)piece, (Object)weight));
        pool.rawTemplates = newRawTemplates;
    }
}

