/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.event.recipe;

import com.github.ysbbbbbb.kaleidoscopecookery.api.event.MillstoneTakeItemEvent;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.MillstoneBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.item.OilPotItem;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.crafting.CompoundIngredient;
import net.neoforged.neoforge.common.crafting.DataComponentIngredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;

@EventBusSubscriber
public class MillstoneSpecialRecipeEvent {
    @SubscribeEvent
    public static void onMillstoneTakeItem(MillstoneTakeItemEvent event) {
        MillstoneBlockEntity millstone = event.getMillstone();
        ItemStack output = millstone.getOutput();
        if (output.is((Item)ModItems.OIL_POT.get())) {
            MillstoneSpecialRecipeEvent.onGetOilPot(event, millstone, output);
            return;
        }
        if (output.is((Item)ModItems.RAW_DOUGH.get())) {
            MillstoneSpecialRecipeEvent.onGetRawDough(event, millstone, output);
        }
    }

    private static void onGetRawDough(MillstoneTakeItemEvent event, MillstoneBlockEntity millstone, ItemStack output) {
        LivingEntity user = event.getUser();
        ItemStack heldItem = event.getHeldItem();
        Ingredient waterPotionIngredient = DataComponentIngredient.of((boolean)false, (DataComponentType)DataComponents.POTION_CONTENTS, (Object)new PotionContents(Potions.WATER), (ItemLike[])new ItemLike[]{Items.POTION});
        Ingredient tagIngredient = Ingredient.of(TagMod.MILLSTONE_DOUGH_CONTAINER);
        CompoundIngredient anyIngredients = new CompoundIngredient(List.of(waterPotionIngredient, tagIngredient));
        Ingredient ingredient = new Ingredient((ICustomIngredient)anyIngredients);
        if (heldItem.isEmpty() || !ingredient.test(heldItem)) {
            Component carrierName = Items.WATER_BUCKET.getDefaultInstance().getHoverName();
            millstone.sendActionBarMessage(user, "tip.kaleidoscope_cookery.pot.need_carrier", carrierName);
            event.setResult(false);
            event.setCanceled(true);
            return;
        }
        ItemUtils.getItemToLivingEntity(user, output.copy());
        Item containerItem = ItemUtils.getContainerItem(heldItem.split(1));
        if (containerItem != Items.AIR) {
            ItemUtils.getItemToLivingEntity(user, containerItem.getDefaultInstance());
        }
        millstone.resetWhenTakeout();
        event.setResult(true);
        event.setCanceled(true);
    }

    private static void onGetOilPot(MillstoneTakeItemEvent event, MillstoneBlockEntity millstone, ItemStack output) {
        LivingEntity user = event.getUser();
        ItemStack heldItem = event.getHeldItem();
        if (heldItem.isEmpty() || !heldItem.is((Item)ModItems.OIL_POT.get())) {
            Component carrierName = ((Item)ModItems.OIL_POT.get()).getDefaultInstance().getHoverName();
            millstone.sendActionBarMessage(user, "tip.kaleidoscope_cookery.pot.need_carrier", carrierName);
            event.setResult(false);
            event.setCanceled(true);
            return;
        }
        int oilCount = OilPotItem.getOilCount(heldItem);
        if (oilCount >= 8) {
            millstone.sendActionBarMessage(user, "tip.kaleidoscope_cookery.millstone.oil_pot_is_full", new Object[0]);
            event.setResult(false);
            event.setCanceled(true);
            return;
        }
        RandomSource random = user.level().getRandom();
        if (random.nextInt(8) < output.getCount()) {
            ItemStack takeItem = heldItem.split(1);
            OilPotItem.setOilCount(takeItem, oilCount + 1);
            ItemUtils.getItemToLivingEntity(user, takeItem);
        }
        millstone.resetWhenTakeout();
        event.setResult(true);
        event.setCanceled(true);
    }
}

