/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.item;

import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModDataComponents;
import com.github.ysbbbbbb.kaleidoscopecookery.inventory.tooltip.ItemContainerTooltip;
import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class FruitBasketItem
extends BlockItem {
    private static final int MAX_SLOTS = 8;

    public FruitBasketItem() {
        super((Block)ModBlocks.FRUIT_BASKET.get(), new Item.Properties().stacksTo(1));
    }

    public static ItemStackHandler getItems(ItemStack stack) {
        ItemContainer container = (ItemContainer)stack.get(ModDataComponents.FRUIT_BASKET_ITEMS);
        if (container != null) {
            return container.items();
        }
        return new ItemStackHandler(8);
    }

    public static void saveItems(ItemStack stack, ItemStackHandler items) {
        stack.set(ModDataComponents.FRUIT_BASKET_ITEMS, (Object)new ItemContainer(items));
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        ItemContainer container = (ItemContainer)stack.get(ModDataComponents.FRUIT_BASKET_ITEMS);
        if (container != null) {
            return Optional.of(new ItemContainerTooltip((IItemHandler)container.items()));
        }
        return Optional.empty();
    }

    public boolean canFitInsideContainerItems() {
        return false;
    }

    public record ItemContainer(ItemStackHandler items) {
        public static final Codec<ItemContainer> CODEC = ItemStack.OPTIONAL_CODEC.listOf().xmap(list -> {
            ItemStackHandler handler = new ItemStackHandler(8);
            for (int i = 0; i < Math.min(list.size(), handler.getSlots()); ++i) {
                handler.setStackInSlot(i, (ItemStack)list.get(i));
            }
            return new ItemContainer(handler);
        }, container -> {
            ItemStackHandler handler = container.items();
            ArrayList output = Lists.newArrayList();
            for (int i = 0; i < handler.getSlots(); ++i) {
                output.add(handler.getStackInSlot(i));
            }
            return output;
        });
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemContainer> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, ItemContainer>(){

            public ItemContainer decode(RegistryFriendlyByteBuf buffer) {
                CompoundTag compoundTag = buffer.readNbt();
                ItemStackHandler handler = new ItemStackHandler(8);
                if (compoundTag != null) {
                    handler.deserializeNBT((HolderLookup.Provider)buffer.registryAccess(), compoundTag);
                }
                return new ItemContainer(handler);
            }

            public void encode(RegistryFriendlyByteBuf buffer, ItemContainer value) {
                CompoundTag compoundTag = value.items().serializeNBT((HolderLookup.Provider)buffer.registryAccess());
                buffer.writeNbt((Tag)compoundTag);
            }
        };
    }
}

