/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.item;

import com.github.ysbbbbbb.kaleidoscopecookery.advancements.critereon.ModEventTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSounds;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class RawDoughItem
extends Item {
    public static final ResourceLocation PULL_PROPERTY = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"pull");
    private static final int MIN_USE_DURATION = 30;

    public RawDoughItem() {
        super(new Item.Properties());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getTexture(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        if (entity == null) {
            return 0.0f;
        }
        if (entity.getUseItem() != stack) {
            return 0.0f;
        }
        return (float)entity.getTicksUsingItem() / 10.0f;
    }

    public int getUseDuration(ItemStack stack, LivingEntity entity) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack pStack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        playerIn.startUsingItem(handIn);
        return InteractionResultHolder.consume((Object)stack);
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity entityLiving, int timeLeft) {
        int time = stack.getUseDuration(entityLiving) - timeLeft;
        if (time >= 30) {
            int count = stack.getCount();
            ItemStack noodles = new ItemStack((ItemLike)ModItems.RAW_NOODLES.get(), count);
            stack.setCount(0);
            ItemUtils.getItemToLivingEntity(entityLiving, noodles);
            if (worldIn.isClientSide()) {
                entityLiving.playSound((SoundEvent)ModSounds.ITEM_DOUGH_TRANSFORM.get(), 1.0f, 1.0f);
            }
            if (entityLiving instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entityLiving;
                ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger((LivingEntity)serverPlayer, "pull_the_dough");
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.raw_dough").withStyle(ChatFormatting.GRAY));
    }
}

