/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.util;

import com.github.ysbbbbbb.kaleidoscopecookery.api.item.IHasContainer;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.tuple.Pair;

public class ItemUtils {
    public static void getItemToLivingEntity(LivingEntity entity, ItemStack stack) {
        ItemUtils.getItemToLivingEntity(entity, stack, -1);
    }

    public static void getItemToLivingEntity(LivingEntity entity, ItemStack stack, int preferredSlot) {
        if (stack.isEmpty()) {
            return;
        }
        if (entity.getMainHandItem().isEmpty()) {
            RandomSource random = entity.level().random;
            entity.setItemInHand(InteractionHand.MAIN_HAND, stack);
            entity.playSound(SoundEvents.ITEM_PICKUP, 0.2f, ((random.nextFloat() - random.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        } else if (entity instanceof Player) {
            Player player = (Player)entity;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack, (int)preferredSlot);
        } else {
            ItemEntity dropItem = entity.spawnAtLocation(stack);
            if (dropItem != null) {
                dropItem.setPickUpDelay(0);
            }
        }
    }

    public static Pair<Integer, ItemStack> getLastStack(IItemHandler itemHandler) {
        for (int i = itemHandler.getSlots(); i > 0; --i) {
            int index = i - 1;
            ItemStack stack = itemHandler.getStackInSlot(index);
            if (stack.isEmpty()) continue;
            return Pair.of((Object)index, (Object)stack);
        }
        return Pair.of((Object)0, (Object)ItemStack.EMPTY);
    }

    public static Item getContainerItem(ItemStack stack) {
        if (stack.isEmpty()) {
            return Items.AIR;
        }
        FoodProperties foodProperties = (FoodProperties)stack.get(DataComponents.FOOD);
        if (foodProperties != null) {
            return foodProperties.usingConvertsTo().map(ItemStack::getItem).orElse(Items.AIR);
        }
        Item item = stack.getItem();
        ItemStack remainingItem = item.getCraftingRemainingItem(stack);
        if (!remainingItem.isEmpty()) {
            return remainingItem.getItem();
        }
        if (item instanceof IHasContainer) {
            IHasContainer hasContainer = (IHasContainer)item;
            return hasContainer.getContainerItem();
        }
        if (stack.is(TagMod.BOWL_CONTAINER)) {
            return Items.BOWL;
        }
        if (stack.is(TagMod.GLASS_BOTTLE_CONTAINER)) {
            return Items.GLASS_BOTTLE;
        }
        if (stack.is(TagMod.BUCKET_CONTAINER)) {
            return Items.BUCKET;
        }
        if (stack.is(Items.POTION)) {
            return Items.GLASS_BOTTLE;
        }
        return Items.AIR;
    }
}

