/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.decoration;

import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.decoration.TableBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.util.BlockDrop;
import com.github.ysbbbbbb.kaleidoscopecookery.util.CarpetColor;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final IntegerProperty POSITION = IntegerProperty.create((String)"position", (int)0, (int)3);
    public static final BooleanProperty HAS_CARPET = BooleanProperty.create((String)"has_carpet");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final int SINGLE = 0;
    public static final int LEFT = 1;
    public static final int MIDDLE = 2;
    public static final int RIGHT = 3;
    private static final VoxelShape FACE = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public TableBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.WOOD).noOcclusion().ignitedByLava());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.Z)).setValue((Property)POSITION, (Comparable)Integer.valueOf(0))).setValue((Property)HAS_CARPET, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemInHand = player.getItemInHand(hand);
        if (hand == InteractionHand.MAIN_HAND) {
            if (itemInHand.is(ItemTags.WOOL_CARPETS)) {
                return this.useWithCarpets(state, level, pos, player, itemInHand);
            }
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TableBlockEntity) {
                TableBlockEntity table = (TableBlockEntity)blockEntity;
                return this.useWithOther(level, pos, player, hand, table, itemInHand);
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @NotNull
    private ItemInteractionResult useWithOther(Level level, BlockPos pos, Player player, InteractionHand hand, TableBlockEntity table, ItemStack itemInHand) {
        ItemStackHandler tableItems = table.getItems();
        Pair<Integer, ItemStack> lastStack = ItemUtils.getLastStack((IItemHandler)tableItems);
        Integer tableIndex = (Integer)lastStack.getLeft();
        ItemStack tableItem = (ItemStack)lastStack.getRight();
        boolean handEmpty = itemInHand.isEmpty();
        if (handEmpty && !tableItem.isEmpty()) {
            level.playSound(player, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, player.getSoundSource(), 1.0f, 1.0f);
            BlockDrop.popResource(level, pos, 0.75, tableItem.copy());
            tableItems.setStackInSlot(tableIndex.intValue(), ItemStack.EMPTY);
            table.refresh();
            return ItemInteractionResult.SUCCESS;
        }
        if (!handEmpty && tableIndex < tableItems.getSlots() - 1) {
            ItemStack split = itemInHand.split(1);
            if (tableItem.isEmpty()) {
                tableItems.setStackInSlot(tableIndex.intValue(), split);
            } else {
                tableItems.setStackInSlot(tableIndex + 1, split);
            }
            table.refresh();
            level.playSound(player, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, player.getSoundSource(), 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    private ItemInteractionResult useWithCarpets(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemInHand) {
        TableBlockEntity tableBlockEntity;
        BlockEntity blockEntity;
        @Nullable DyeColor dyeColor = CarpetColor.getColorByCarpet(itemInHand.getItem());
        boolean hasCarpet = (Boolean)state.getValue((Property)HAS_CARPET);
        if (dyeColor == null) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!hasCarpet) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_CARPET, (Comparable)Boolean.valueOf(true)));
            blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof TableBlockEntity) {
                TableBlockEntity tableBlockEntity2 = (TableBlockEntity)blockEntity;
                level.playSound(null, pos, SoundType.WOOL.getPlaceSound(), player.getSoundSource(), 1.0f, 1.0f);
                tableBlockEntity2.setColor(dyeColor);
                tableBlockEntity2.refresh();
                itemInHand.shrink(1);
                return ItemInteractionResult.SUCCESS;
            }
        }
        if (hasCarpet && (blockEntity = level.getBlockEntity(pos)) instanceof TableBlockEntity && (tableBlockEntity = (TableBlockEntity)blockEntity).getColor() != dyeColor) {
            DyeColor originalColor = tableBlockEntity.getColor();
            ItemStack carpetItem = CarpetColor.getCarpetByColor(originalColor).getDefaultInstance();
            BlockDrop.popResource(level, pos, 0.75, carpetItem);
            level.playSound(null, pos, SoundType.WOOL.getPlaceSound(), player.getSoundSource(), 1.0f, 1.0f);
            tableBlockEntity.setColor(dyeColor);
            tableBlockEntity.refresh();
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)HAS_CARPET, (Comparable)Boolean.valueOf(true)));
            itemInHand.shrink(1);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity;
        if (!level.isClientSide && player.isCreative() && (blockEntity = level.getBlockEntity(pos)) instanceof TableBlockEntity) {
            TableBlockEntity tableBlockEntity = (TableBlockEntity)blockEntity;
            ItemStackHandler items = tableBlockEntity.getItems();
            for (int i = 0; i < items.getSlots(); ++i) {
                ItemStack stack = items.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                TableBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)stack);
                items.setStackInSlot(i, ItemStack.EMPTY);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder lootParamsBuilder) {
        List drops = super.getDrops(state, lootParamsBuilder);
        BlockEntity parameter = (BlockEntity)lootParamsBuilder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (parameter instanceof TableBlockEntity) {
            TableBlockEntity tableBlockEntity = (TableBlockEntity)parameter;
            if (((Boolean)state.getValue((Property)HAS_CARPET)).booleanValue()) {
                Item carpet = CarpetColor.getCarpetByColor(tableBlockEntity.getColor());
                drops.add(new ItemStack((ItemLike)carpet));
            }
            ItemStackHandler items = tableBlockEntity.getItems();
            for (int i = 0; i < items.getSlots(); ++i) {
                drops.add(items.getStackInSlot(i).copy());
            }
        }
        return drops;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, POSITION, HAS_CARPET, WATERLOGGED});
    }

    private BlockState checkEastWestState(LevelAccessor levelAccessor, BlockPos pos, BlockState baseState) {
        if (baseState.getValue(AXIS) == Direction.Axis.Z && (Integer)baseState.getValue((Property)POSITION) != 0) {
            return baseState;
        }
        BlockState westState = levelAccessor.getBlockState(pos.west());
        BlockState eastState = levelAccessor.getBlockState(pos.east());
        if (this.checkIfShouldLink(eastState, Direction.Axis.Z) && this.checkIfShouldLink(westState, Direction.Axis.Z)) {
            return (BlockState)((BlockState)baseState.setValue((Property)POSITION, (Comparable)Integer.valueOf(2))).setValue(AXIS, (Comparable)Direction.Axis.X);
        }
        if (this.checkIfShouldLink(eastState, Direction.Axis.Z) && !this.checkIfShouldLink(westState, Direction.Axis.Z)) {
            return (BlockState)((BlockState)baseState.setValue((Property)POSITION, (Comparable)Integer.valueOf(1))).setValue(AXIS, (Comparable)Direction.Axis.X);
        }
        if (!this.checkIfShouldLink(eastState, Direction.Axis.Z) && this.checkIfShouldLink(westState, Direction.Axis.Z)) {
            return (BlockState)((BlockState)baseState.setValue((Property)POSITION, (Comparable)Integer.valueOf(3))).setValue(AXIS, (Comparable)Direction.Axis.X);
        }
        return (BlockState)baseState.setValue((Property)POSITION, (Comparable)Integer.valueOf(0));
    }

    private BlockState checkNorthSouthState(LevelAccessor levelAccessor, BlockPos pos, BlockState baseState) {
        if (baseState.getValue(AXIS) == Direction.Axis.X && (Integer)baseState.getValue((Property)POSITION) != 0) {
            return baseState;
        }
        BlockState northState = levelAccessor.getBlockState(pos.north());
        BlockState southState = levelAccessor.getBlockState(pos.south());
        if (this.checkIfShouldLink(southState, Direction.Axis.X) && this.checkIfShouldLink(northState, Direction.Axis.X)) {
            return (BlockState)((BlockState)baseState.setValue((Property)POSITION, (Comparable)Integer.valueOf(2))).setValue(AXIS, (Comparable)Direction.Axis.Z);
        }
        if (this.checkIfShouldLink(southState, Direction.Axis.X) && !this.checkIfShouldLink(northState, Direction.Axis.X)) {
            return (BlockState)((BlockState)baseState.setValue((Property)POSITION, (Comparable)Integer.valueOf(1))).setValue(AXIS, (Comparable)Direction.Axis.Z);
        }
        if (!this.checkIfShouldLink(southState, Direction.Axis.X) && this.checkIfShouldLink(northState, Direction.Axis.X)) {
            return (BlockState)((BlockState)baseState.setValue((Property)POSITION, (Comparable)Integer.valueOf(3))).setValue(AXIS, (Comparable)Direction.Axis.Z);
        }
        return (BlockState)baseState.setValue((Property)POSITION, (Comparable)Integer.valueOf(0));
    }

    private boolean checkIfShouldLink(BlockState state, Direction.Axis axis) {
        if (!state.is((Block)this)) {
            return false;
        }
        if (state.getValue(AXIS) == axis) {
            return (Integer)state.getValue((Property)POSITION) == 0;
        }
        return true;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        if (direction.getAxis() == Direction.Axis.X) {
            return this.checkEastWestState(levelAccessor, pos, state);
        }
        if (direction.getAxis() == Direction.Axis.Z) {
            return this.checkNorthSouthState(levelAccessor, pos, state);
        }
        return state;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        BlockPos clickedPos = context.getClickedPos();
        Direction direction = context.getHorizontalDirection();
        boolean hasWater = level.getFluidState(clickedPos).getType() == Fluids.WATER;
        BlockState base = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(hasWater));
        if (direction.getAxis() == Direction.Axis.X) {
            return this.checkNorthSouthState((LevelAccessor)level, clickedPos, base);
        }
        if (direction.getAxis() == Direction.Axis.Z) {
            return this.checkEastWestState((LevelAccessor)level, clickedPos, base);
        }
        return base;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return FACE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TableBlockEntity(pos, state);
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }
}

