/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.food;

import com.github.ysbbbbbb.kaleidoscopecookery.block.food.FoodBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteAnimateTicks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class FoodBiteBlock
extends FoodBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    private final FoodProperties foodProperties;
    private final IntegerProperty bites;
    private final int maxBites;
    private FoodBiteAnimateTicks.AnimateTick animateTick = null;

    public FoodBiteBlock(FoodProperties foodProperties, int maxBites, @Nullable FoodBiteAnimateTicks.AnimateTick animateTick) {
        this.maxBites = maxBites;
        this.foodProperties = foodProperties;
        this.bites = IntegerProperty.create((String)"bites", (int)0, (int)maxBites);
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)this);
        this.createBitesBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder);
        this.stateDefinition = builder.create(Block::defaultBlockState, BlockState::new);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.bites, (Comparable)Integer.valueOf(0))).setValue((Property)FACING, (Comparable)Direction.SOUTH));
        this.animateTick = animateTick;
    }

    public FoodBiteBlock(FoodProperties foodProperties) {
        this(foodProperties, 3, null);
    }

    public IntegerProperty getBites() {
        return this.bites;
    }

    public int getMaxBites() {
        return this.maxBites;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (this.animateTick != null) {
            this.animateTick.animateTick(state, level, pos, random);
        }
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        int bites = (Integer)state.getValue((Property)this.bites);
        if (bites >= this.getMaxBites()) {
            level.destroyBlock(pos, true, (Entity)player);
            return InteractionResult.SUCCESS;
        }
        if (level.isClientSide && this.eat(level, pos, state, player).consumesAction()) {
            return InteractionResult.SUCCESS;
        }
        return this.eat(level, pos, state, player);
    }

    private InteractionResult eat(Level level, BlockPos pos, BlockState state, Player player) {
        if (!player.canEat(this.foodProperties.canAlwaysEat())) {
            return InteractionResult.PASS;
        }
        player.getFoodData().eat(this.foodProperties);
        for (FoodProperties.PossibleEffect effect : this.foodProperties.effects()) {
            if (level.isClientSide || !(level.random.nextFloat() < effect.probability())) continue;
            player.addEffect(new MobEffectInstance(effect.effect()));
        }
        level.playSound(null, pos, SoundEvents.GENERIC_EAT, SoundSource.PLAYERS, 0.5f, level.getRandom().nextFloat() * 0.1f + 0.9f);
        int bites = (Integer)state.getValue((Property)this.bites);
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        if (bites < this.getMaxBites()) {
            level.setBlock(pos, (BlockState)state.setValue((Property)this.bites, (Comparable)Integer.valueOf(bites + 1)), 3);
        }
        return InteractionResult.SUCCESS;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    private void createBitesBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.bites, FACING});
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        int value = (Integer)state.getValue((Property)this.bites);
        return (3 - value) * 5;
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    protected boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }
}

