/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.advancements.critereon.ModEventTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IMillstone;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.NinePart;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.MillstoneBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class MillstoneBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final MapCodec<MillstoneBlock> CODEC = MillstoneBlock.simpleCodec(p -> new MillstoneBlock());
    public static final EnumProperty<NinePart> PART = EnumProperty.create((String)"part", NinePart.class);
    private static final VoxelShape CENTER = Block.box((double)-2.0, (double)0.0, (double)-2.0, (double)18.0, (double)15.0, (double)18.0);
    private static final VoxelShape LEFT_UP = Shapes.or((VoxelShape)Block.box((double)11.0, (double)0.0, (double)11.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)8.0, (double)6.0, (double)8.0, (double)16.0, (double)14.0, (double)16.0));
    private static final VoxelShape UP = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)6.0, (double)8.0, (double)16.0, (double)14.0, (double)16.0));
    private static final VoxelShape RIGHT_UP = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)11.0, (double)5.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)6.0, (double)8.0, (double)8.0, (double)14.0, (double)16.0));
    private static final VoxelShape LEFT_CENTER = Shapes.or((VoxelShape)Block.box((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)8.0, (double)6.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0));
    private static final VoxelShape RIGHT_CENTER = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)6.0, (double)0.0, (double)8.0, (double)14.0, (double)16.0));
    private static final VoxelShape LEFT_DOWN = Shapes.or((VoxelShape)Block.box((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)5.0), (VoxelShape)Block.box((double)8.0, (double)6.0, (double)0.0, (double)16.0, (double)14.0, (double)8.0));
    private static final VoxelShape DOWN = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)5.0), (VoxelShape)Block.box((double)0.0, (double)6.0, (double)0.0, (double)16.0, (double)14.0, (double)8.0));
    private static final VoxelShape RIGHT_DOWN = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)6.0, (double)5.0), (VoxelShape)Block.box((double)0.0, (double)6.0, (double)0.0, (double)8.0, (double)14.0, (double)8.0));

    public MillstoneBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).instrument(NoteBlockInstrument.BASEDRUM).requiresCorrectToolForDrops().strength(1.5f, 6.0f).sound(SoundType.STONE).forceSolidOn().noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)((Object)NinePart.CENTER))).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    private static void handleRemove(Level world, BlockPos pos, BlockState state, @Nullable Player player) {
        if (world.isClientSide) {
            return;
        }
        NinePart part = (NinePart)((Object)state.getValue(PART));
        BlockPos centerPos = pos.subtract(new Vec3i(part.getPosX(), 0, part.getPosY()));
        BlockEntity te = world.getBlockEntity(centerPos);
        if (!(te instanceof MillstoneBlockEntity)) {
            return;
        }
        MillstoneBlockEntity millstone = (MillstoneBlockEntity)te;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos offsetPos = centerPos.offset(i, 0, j);
                world.setBlock(offsetPos, Blocks.AIR.defaultBlockState(), 35);
            }
        }
        if (player != null && !player.isCreative()) {
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)((Item)ModItems.MILLSTONE.get()).getDefaultInstance());
        }
        if (!millstone.getOutput().isEmpty()) {
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)millstone.getOutput());
        }
        if (!millstone.getInput().isEmpty()) {
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)millstone.getInput());
        }
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return null;
        }
        return MillstoneBlock.createTickerHelper(blockEntityType, ModBlocks.MILLSTONE_BE.get(), (levelIn, pos, stateIn, millstone) -> millstone.tick(levelIn));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        NinePart part = (NinePart)((Object)state.getValue(PART));
        BlockPos centerPos = pos.subtract(new Vec3i(part.getPosX(), 0, part.getPosY()));
        BlockEntity te = level.getBlockEntity(centerPos);
        if (!(te instanceof IMillstone)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        IMillstone millstone = (IMillstone)te;
        ItemStack mainHandItem = player.getMainHandItem();
        if (millstone.onPutItem(level, mainHandItem)) {
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void stepOn(Level pLevel, BlockPos pPos, BlockState pState, Entity pEntity) {
        if (pEntity instanceof Mob) {
            MillstoneBlockEntity millstone;
            NinePart part;
            BlockPos centerPos;
            BlockEntity blockEntity;
            Mob mob = (Mob)pEntity;
            if (!pLevel.isClientSide && pLevel.getGameTime() % 5L == 4L && (blockEntity = pLevel.getBlockEntity(centerPos = pPos.subtract(new Vec3i((part = (NinePart)((Object)pState.getValue(PART))).getPosX(), 0, part.getPosY())))) instanceof MillstoneBlockEntity && !(millstone = (MillstoneBlockEntity)blockEntity).hasEntity() && millstone.canBindEntity(mob)) {
                millstone.bindEntity(mob);
                Entity entity = mob.getFirstPassenger();
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger((LivingEntity)player, "drive_the_millstone");
                }
            }
        }
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        MillstoneBlock.handleRemove(world, pos, state, player);
        return super.playerWillDestroy(world, pos, state, player);
    }

    public void onBlockExploded(BlockState state, Level world, BlockPos pos, Explosion explosion) {
        MillstoneBlock.handleRemove(world, pos, state, null);
        super.onBlockExploded(state, world, pos, explosion);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos centerPos = context.getClickedPos();
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos searchPos = centerPos.offset(i, 0, j);
                if (context.getLevel().getBlockState(searchPos).canBeReplaced(context)) continue;
                return null;
            }
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (worldIn.isClientSide) {
            return;
        }
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                BlockPos searchPos = pos.offset(i, 0, j);
                NinePart part = NinePart.getPartByPos(i, j);
                if (part == null || part.isCenter()) continue;
                worldIn.setBlock(searchPos, (BlockState)state.setValue(PART, (Comparable)((Object)part)), 3);
            }
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{PART, FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        if (((NinePart)((Object)state.getValue(PART))).isCenter()) {
            return new MillstoneBlockEntity(pos, state);
        }
        return null;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        NinePart value = (NinePart)((Object)pState.getValue(PART));
        return switch (value) {
            default -> throw new MatchException(null, null);
            case NinePart.LEFT_UP -> LEFT_UP;
            case NinePart.UP -> UP;
            case NinePart.RIGHT_UP -> RIGHT_UP;
            case NinePart.LEFT_CENTER -> LEFT_CENTER;
            case NinePart.CENTER -> CENTER;
            case NinePart.RIGHT_CENTER -> RIGHT_CENTER;
            case NinePart.LEFT_DOWN -> LEFT_DOWN;
            case NinePart.DOWN -> DOWN;
            case NinePart.RIGHT_DOWN -> RIGHT_DOWN;
        };
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.millstone").withStyle(ChatFormatting.GRAY));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

