/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IShawarmaSpit;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.ShawarmaSpitBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShawarmaSpitBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final MapCodec<ShawarmaSpitBlock> CODEC = ShawarmaSpitBlock.simpleCodec(p -> new ShawarmaSpitBlock());
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final VoxelShape UPPER_AABB = Shapes.or((VoxelShape)Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)14.0, (double)10.0));
    public static final VoxelShape LOWER_AABB = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)7.0, (double)16.0), (VoxelShape)Block.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));

    public ShawarmaSpitBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).noOcclusion().instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).lightLevel(state -> (Boolean)state.getValue((Property)POWERED) != false ? 8 : 0).sound(SoundType.METAL));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (player.isShiftKeyDown()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof IShawarmaSpit) {
            IShawarmaSpit shawarmaSpit = (IShawarmaSpit)blockEntity;
            ItemStack heldItem = player.getItemInHand(hand);
            if (shawarmaSpit.onPutCookingItem(level, heldItem)) {
                return ItemInteractionResult.SUCCESS;
            }
            if (shawarmaSpit.onTakeCookedItem(level, (LivingEntity)player)) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return ShawarmaSpitBlock.createTickerHelper(blockEntityType, ModBlocks.SHAWARMA_SPIT_BE.get(), (levelIn, blockPos, blockState, spit) -> {
            if (((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
                spit.tick();
            }
        });
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return state.getValue(HALF) == DoubleBlockHalf.LOWER ? LOWER_AABB : UPPER_AABB;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos currentPos, BlockPos neighborPos) {
        boolean isUpperHalf;
        DoubleBlockHalf half;
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        boolean isLowerHalf = (half = (DoubleBlockHalf)state.getValue(HALF)) == DoubleBlockHalf.LOWER && direction == Direction.UP;
        boolean bl = isUpperHalf = half == DoubleBlockHalf.UPPER && direction == Direction.DOWN;
        if (direction.getAxis() == Direction.Axis.Y && (isLowerHalf || isUpperHalf)) {
            if (neighborState.is((Block)this) && neighborState.getValue(HALF) != half) {
                return (BlockState)((BlockState)state.setValue((Property)FACING, (Comparable)((Direction)neighborState.getValue((Property)FACING)))).setValue((Property)POWERED, (Comparable)((Boolean)neighborState.getValue((Property)POWERED)));
            }
            return Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, direction, neighborState, levelAccessor, currentPos, neighborPos);
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered;
        Direction direction = state.getValue(HALF) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN;
        boolean bl = powered = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.relative(direction));
        if (!state.is(block) && powered != (Boolean)state.getValue((Property)POWERED)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
        }
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        if (!level.isClientSide && player.isCreative()) {
            if (state.getValue(HALF) == DoubleBlockHalf.UPPER) {
                BlockPos below = pos.below();
                BlockState belowState = level.getBlockState(below);
                if (belowState.is(state.getBlock()) && belowState.getValue(HALF) == DoubleBlockHalf.LOWER) {
                    this.dropCookItems(level, below);
                    BlockState airBlockState = belowState.getFluidState().is((Fluid)Fluids.WATER) ? Blocks.WATER.defaultBlockState() : Blocks.AIR.defaultBlockState();
                    level.setBlock(below, airBlockState, 35);
                    level.levelEvent(player, 2001, below, Block.getId((BlockState)belowState));
                }
            } else {
                this.dropCookItems(level, pos);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    private void dropCookItems(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ShawarmaSpitBlockEntity) {
            ShawarmaSpitBlockEntity shawarmaSpit = (ShawarmaSpitBlockEntity)blockEntity;
            if (!shawarmaSpit.cookingItem.isEmpty()) {
                ShawarmaSpitBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)shawarmaSpit.cookingItem.copy());
                shawarmaSpit.cookingItem = ItemStack.EMPTY;
            } else if (!shawarmaSpit.cookedItem.isEmpty()) {
                ShawarmaSpitBlock.popResource((Level)level, (BlockPos)pos, (ItemStack)shawarmaSpit.cookedItem.copy());
                shawarmaSpit.cookedItem = ItemStack.EMPTY;
            }
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        FluidState fluidState = context.getLevel().getFluidState(pos);
        if (pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(context)) {
            boolean isPowered = level.hasNeighborSignal(pos) || level.hasNeighborSignal(pos.above());
            return (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(isPowered))).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        }
        return null;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        FluidState fluidState = level.getFluidState(pos);
        BlockState blockState = (BlockState)((BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        level.setBlockAndUpdate(pos.above(), blockState);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF, WATERLOGGED, POWERED});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new ShawarmaSpitBlockEntity(pos, state);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder lootParamsBuilder) {
        List drops = state.getValue(HALF) == DoubleBlockHalf.LOWER ? super.getDrops(state, lootParamsBuilder) : Lists.newArrayList();
        BlockEntity parameter = (BlockEntity)lootParamsBuilder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
        if (parameter instanceof ShawarmaSpitBlockEntity) {
            ShawarmaSpitBlockEntity shawarmaSpit = (ShawarmaSpitBlockEntity)parameter;
            if (!shawarmaSpit.cookingItem.isEmpty()) {
                drops.add(shawarmaSpit.cookingItem.copy());
            } else if (!shawarmaSpit.cookedItem.isEmpty()) {
                drops.add(shawarmaSpit.cookedItem.copy());
            }
        }
        return drops;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.shawarma_spit").withStyle(ChatFormatting.GRAY));
    }
}

