/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.advancements.critereon.ModEventTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.ISteamer;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.SteamerBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.item.SteamerItem;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SteamerBlock
extends FallingBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<SteamerBlock> CODEC = SteamerBlock.simpleCodec(p -> new SteamerBlock());
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty HALF = BooleanProperty.create((String)"half");
    public static final BooleanProperty HAS_LID = BooleanProperty.create((String)"has_lid");
    public static final BooleanProperty HAS_BASE = BooleanProperty.create((String)"has_base");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape HALF_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0);
    private static final VoxelShape FULL_AABB = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public SteamerBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).instrument(NoteBlockInstrument.BASEDRUM).instabreak().noOcclusion().pushReaction(PushReaction.DESTROY).sound(SoundType.BAMBOO));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HALF, (Comparable)Boolean.valueOf(true))).setValue((Property)HAS_LID, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_BASE, (Comparable)Boolean.valueOf(false))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return SteamerBlock.createTickerHelper(blockEntityType, ModBlocks.STEAMER_BE.get(), (levelIn, blockPos, blockState, steamer) -> steamer.tick(levelIn));
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof ServerPlayer) {
            ISteamer steamer;
            ServerPlayer player = (ServerPlayer)placer;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ISteamer && (steamer = (ISteamer)blockEntity).hasHeatSource(level)) {
                ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger((LivingEntity)player, "use_steamer");
            }
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockState below = level.getBlockState(pos.below());
        if (SteamerBlock.isFree((BlockState)below) && pos.getY() >= level.getMinBuildHeight()) {
            CompoundTag blockEntityTag = null;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof SteamerBlockEntity) {
                SteamerBlockEntity steamer = (SteamerBlockEntity)blockEntity;
                blockEntityTag = steamer.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
            }
            FallingBlockEntity fall = FallingBlockEntity.fall((Level)level, (BlockPos)pos, (BlockState)((BlockState)state.setValue((Property)HAS_BASE, (Comparable)Boolean.valueOf(false))));
            fall.blockData = blockEntityTag;
            this.falling(fall);
        }
    }

    protected MapCodec<? extends FallingBlock> codec() {
        return CODEC;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        levelAccessor.scheduleTick(pos, (Block)this, this.getDelayAfterPlace());
        if (direction == Direction.DOWN) {
            state = SteamerBlock.isFree((BlockState)neighborState) ? (BlockState)state.setValue((Property)HAS_BASE, (Comparable)Boolean.valueOf(false)) : (BlockState)state.setValue((Property)HAS_BASE, (Comparable)Boolean.valueOf(this.shouldHasBase(levelAccessor, pos)));
        }
        if (direction == Direction.UP && neighborState.is((Block)this)) {
            state = (BlockState)state.setValue((Property)HAS_LID, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        ItemStack itemInHand = player.getItemInHand(hand);
        Boolean hasLid = (Boolean)state.getValue((Property)HAS_LID);
        if (itemInHand.isEmpty() && player.isSecondaryUseActive() && (hasLid.booleanValue() || !level.getBlockState(pos.above()).is((Block)this))) {
            level.setBlock(pos, (BlockState)state.setValue((Property)HAS_LID, (Comparable)Boolean.valueOf(hasLid == false)), 3);
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        if (itemInHand.is(this.asItem())) {
            Item item;
            if (((Boolean)state.getValue((Property)HALF)).booleanValue() && (item = itemInHand.getItem()) instanceof SteamerItem) {
                SteamerItem steamerItem = (SteamerItem)item;
                InteractionResult place = steamerItem.place(new BlockPlaceContext(player, hand, itemInHand, hitResult));
                if (place.consumesAction()) {
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ISteamer) {
            ISteamer steamer = (ISteamer)blockEntity;
            if (steamer.placeFood(level, (LivingEntity)player, itemInHand)) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            if (steamer.takeFood(level, (LivingEntity)player)) {
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockPos clickedPos = context.getClickedPos();
        BlockState blockState = context.getLevel().getBlockState(clickedPos);
        FluidState fluidState = context.getLevel().getFluidState(clickedPos);
        BlockState resultState = blockState.is((Block)this) ? (BlockState)blockState.setValue((Property)HALF, (Comparable)Boolean.valueOf(false)) : (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        if (SteamerBlock.isFree((BlockState)context.getLevel().getBlockState(clickedPos.below()))) {
            return (BlockState)resultState.setValue((Property)HAS_BASE, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)resultState.setValue((Property)HAS_BASE, (Comparable)Boolean.valueOf(this.shouldHasBase((LevelAccessor)context.getLevel(), clickedPos)));
    }

    private boolean shouldHasBase(LevelAccessor level, BlockPos pos) {
        BlockState belowState = level.getBlockState(pos.below());
        if (belowState.is((Block)this)) {
            return false;
        }
        if (belowState.hasProperty((Property)BlockStateProperties.LIT)) {
            return true;
        }
        if (belowState.is(TagMod.HEAT_SOURCE_BLOCKS_WITHOUT_LIT)) {
            return true;
        }
        return !belowState.isFaceSturdy((BlockGetter)level, pos.below(), Direction.UP);
    }

    public void onLand(Level level, BlockPos pos, BlockState state, BlockState replaceableState, FallingBlockEntity fallingBlock) {
        if (this.shouldHasBase((LevelAccessor)level, pos)) {
            level.setBlock(pos, (BlockState)state.setValue((Property)HAS_BASE, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext context) {
        ItemStack itemInHand = context.getItemInHand();
        return (Boolean)state.getValue((Property)HALF) != false && itemInHand.is(this.asItem());
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF, HAS_LID, HAS_BASE, WATERLOGGED});
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        return (Boolean)state.getValue((Property)HALF) != false ? HALF_AABB : FULL_AABB;
    }

    public BlockState rotate(BlockState pState, Rotation pRot) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRot.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new SteamerBlockEntity(pos, state);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder lootParamsBuilder) {
        SteamerBlockEntity steamer;
        BlockEntity parameter = (BlockEntity)lootParamsBuilder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (parameter instanceof SteamerBlockEntity && (steamer = (SteamerBlockEntity)parameter).getLevel() != null) {
            return steamer.dropAsItem(steamer.getLevel());
        }
        return super.getDrops(state, lootParamsBuilder);
    }
}

