/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.advancements.critereon.ModEventTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IStockpot;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.StockpotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoundType;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class StockpotBlock
extends HorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<StockpotBlock> CODEC = StockpotBlock.simpleCodec(p -> new StockpotBlock());
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty HAS_LID = BooleanProperty.create((String)"has_lid");
    public static final BooleanProperty HAS_BASE = BooleanProperty.create((String)"has_base");
    public static final BooleanProperty HAS_CHAINS = BooleanProperty.create((String)"has_chains");
    private static final VoxelShape AABB = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)5.0, (double)14.0), (VoxelShape)Block.box((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0));
    private static final VoxelShape AABB_WITH_LID = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0), (VoxelShape)Block.box((double)1.0, (double)5.0, (double)1.0, (double)15.0, (double)7.0, (double)15.0));

    public StockpotBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.METAL).sound(ModSoundType.POT).noOcclusion().strength(1.5f, 6.0f));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.SOUTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_LID, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_BASE, (Comparable)Boolean.valueOf(false))).setValue((Property)HAS_CHAINS, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> serverType, BlockEntityType<E> clientType, BlockEntityTicker<? super E> ticker) {
        return clientType == serverType ? ticker : null;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (placer instanceof Player) {
            IStockpot stockpot;
            Player player = (Player)placer;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof IStockpot && (stockpot = (IStockpot)blockEntity).hasHeatSource(level)) {
                ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger((LivingEntity)player, "place_stockpot_on_heat_source");
            }
        }
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        if (direction == Direction.DOWN && !((Boolean)state.getValue((Property)HAS_CHAINS)).booleanValue()) {
            return (BlockState)((BlockState)state.setValue((Property)HAS_CHAINS, (Comparable)Boolean.valueOf(StockpotBlock.canSupportCenter((LevelReader)levelAccessor, (BlockPos)pos.above(), (Direction)Direction.DOWN)))).setValue((Property)HAS_BASE, (Comparable)Boolean.valueOf(!neighborState.isFaceSturdy((BlockGetter)levelAccessor, neighborPos, Direction.UP)));
        }
        if (direction == Direction.UP && !((Boolean)state.getValue((Property)HAS_BASE)).booleanValue()) {
            BlockState belowState = levelAccessor.getBlockState(pos.below());
            return (BlockState)((BlockState)state.setValue((Property)HAS_CHAINS, (Comparable)Boolean.valueOf(StockpotBlock.canSupportCenter((LevelReader)levelAccessor, (BlockPos)neighborPos, (Direction)Direction.DOWN)))).setValue((Property)HAS_BASE, (Comparable)Boolean.valueOf(!belowState.isFaceSturdy((BlockGetter)levelAccessor, pos.below(), Direction.UP)));
        }
        return super.updateShape(state, direction, neighborState, levelAccessor, pos, neighborPos);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (!(blockEntity instanceof IStockpot)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        IStockpot stockpot = (IStockpot)blockEntity;
        ItemStack mainHandItem = player.getMainHandItem();
        if (stockpot.onLitClick(level, (LivingEntity)player, mainHandItem)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (stockpot.addSoupBase(level, (LivingEntity)player, mainHandItem)) {
            ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger((LivingEntity)player, "put_soup_base_in_stockpot");
            return ItemInteractionResult.SUCCESS;
        }
        if (stockpot.removeSoupBase(level, (LivingEntity)player, mainHandItem)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (!mainHandItem.isEmpty() && stockpot.addIngredient(level, (LivingEntity)player, mainHandItem)) {
            return ItemInteractionResult.SUCCESS;
        }
        if ((mainHandItem.isEmpty() || mainHandItem.is(TagMod.INGREDIENT_CONTAINER)) && stockpot.removeIngredient(level, (LivingEntity)player)) {
            return ItemInteractionResult.SUCCESS;
        }
        if (stockpot.takeOutProduct(level, (LivingEntity)player, mainHandItem)) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new StockpotBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        if (level.isClientSide) {
            return StockpotBlock.createTickerHelper(blockEntityType, ModBlocks.STOCKPOT_BE.get(), (lvl, blockPos, blockState, pot) -> pot.clientTick());
        }
        return StockpotBlock.createTickerHelper(blockEntityType, ModBlocks.STOCKPOT_BE.get(), (lvl, blockPos, blockState, pot) -> pot.tick(lvl));
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level level = context.getLevel();
        FluidState fluidState = level.getFluidState(context.getClickedPos());
        Direction clickFace = context.getClickedFace();
        BlockState blockState = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        BlockPos abovePos = context.getClickedPos().above();
        if (clickFace == Direction.DOWN && StockpotBlock.canSupportCenter((LevelReader)level, (BlockPos)abovePos, (Direction)Direction.DOWN)) {
            return (BlockState)blockState.setValue((Property)HAS_CHAINS, (Comparable)Boolean.valueOf(true));
        }
        BlockPos belowPos = context.getClickedPos().below();
        BlockState belowState = level.getBlockState(belowPos);
        if (!belowState.isFaceSturdy((BlockGetter)level, belowPos, Direction.UP)) {
            return (BlockState)blockState.setValue((Property)HAS_BASE, (Comparable)Boolean.valueOf(true));
        }
        return blockState;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, HAS_LID, HAS_BASE, HAS_CHAINS});
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext collisionContext) {
        if (((Boolean)state.getValue((Property)HAS_LID)).booleanValue()) {
            return AABB_WITH_LID;
        }
        return AABB;
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder lootParamsBuilder) {
        StockpotBlockEntity stockpotBlock;
        BlockEntity parameter;
        List drops = super.getDrops(state, lootParamsBuilder);
        if (((Boolean)state.getValue((Property)HAS_LID)).booleanValue()) {
            StockpotBlockEntity stockpot;
            parameter = (BlockEntity)lootParamsBuilder.getOptionalParameter(LootContextParams.BLOCK_ENTITY);
            if (parameter instanceof StockpotBlockEntity && !(stockpot = (StockpotBlockEntity)parameter).getLidItem().isEmpty()) {
                drops.add(stockpot.getLidItem().copy());
            } else {
                drops.add(new ItemStack((ItemLike)ModItems.STOCKPOT_LID.get()));
            }
        }
        if ((parameter = (BlockEntity)lootParamsBuilder.getParameter(LootContextParams.BLOCK_ENTITY)) instanceof StockpotBlockEntity && (stockpotBlock = (StockpotBlockEntity)parameter).getStatus() == 1) {
            stockpotBlock.getInputs().forEach(stack -> {
                if (!stack.isEmpty()) {
                    drops.add(stack);
                }
            });
        }
        return drops;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.stockpot").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.stockpot.fail").withStyle(ChatFormatting.GRAY));
    }
}

