/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.block.misc;

import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.decoration.RecipeBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoundType;
import com.mojang.serialization.MapCodec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class RecipeBlock
extends FaceAttachedHorizontalDirectionalBlock
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<RecipeBlock> CODEC = RecipeBlock.simpleCodec(p -> new RecipeBlock());
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape CEILING_AABB_X = Block.box((double)1.5, (double)15.75, (double)3.0, (double)14.5, (double)16.0, (double)13.0);
    private static final VoxelShape CEILING_AABB_Z = Block.box((double)3.0, (double)15.75, (double)1.5, (double)13.0, (double)16.0, (double)14.5);
    private static final VoxelShape FLOOR_AABB_X = Block.box((double)1.5, (double)0.0, (double)3.0, (double)14.5, (double)0.25, (double)13.0);
    private static final VoxelShape FLOOR_AABB_Z = Block.box((double)3.0, (double)0.0, (double)1.5, (double)13.0, (double)0.25, (double)14.5);
    private static final VoxelShape NORTH_AABB = Block.box((double)3.0, (double)1.5, (double)15.75, (double)13.0, (double)14.5, (double)16.0);
    private static final VoxelShape SOUTH_AABB = Block.box((double)3.0, (double)1.5, (double)0.0, (double)13.0, (double)14.5, (double)0.25);
    private static final VoxelShape WEST_AABB = Block.box((double)15.75, (double)1.5, (double)3.0, (double)16.0, (double)14.5, (double)13.0);
    private static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)1.5, (double)3.0, (double)0.25, (double)14.5, (double)13.0);

    public RecipeBlock() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_YELLOW).instabreak().noOcclusion().sound(ModSoundType.RECIPE_BLOCK));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)FACE, (Comparable)AttachFace.WALL)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand != InteractionHand.MAIN_HAND) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        if (!mainHandItem.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (level.isClientSide) {
            return ItemInteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RecipeBlockEntity) {
            RecipeBlockEntity recipeBlockEntity = (RecipeBlockEntity)blockEntity;
            ItemStack itemStack = recipeBlockEntity.getItems().getStackInSlot(0);
            if (itemStack.isEmpty()) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            player.setItemInHand(hand, itemStack.copy());
            level.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
            level.playSound(null, pos, ModSoundType.RECIPE_BLOCK.getBreakSound(), player.getSoundSource(), 1.0f, 1.0f);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(state, direction, neighborState, levelAccessor, pos, neighborPos);
    }

    public VoxelShape getShape(BlockState state, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        return switch ((AttachFace)state.getValue((Property)FACE)) {
            case AttachFace.FLOOR -> {
                if (facing.getAxis() == Direction.Axis.X) {
                    yield FLOOR_AABB_X;
                }
                yield FLOOR_AABB_Z;
            }
            case AttachFace.WALL -> {
                switch (facing) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case EAST: {
                        yield EAST_AABB;
                    }
                    case WEST: {
                        yield WEST_AABB;
                    }
                    case SOUTH: {
                        yield SOUTH_AABB;
                    }
                    case NORTH: 
                    case UP: 
                    case DOWN: 
                }
                yield NORTH_AABB;
            }
            default -> facing.getAxis() == Direction.Axis.X ? CEILING_AABB_X : CEILING_AABB_Z;
        };
    }

    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidState = context.getLevel().getFluidState(context.getClickedPos());
        BlockState stateForPlacement = super.getStateForPlacement(context);
        if (stateForPlacement != null) {
            return (BlockState)stateForPlacement.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.getType() == Fluids.WATER));
        }
        return null;
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity livingEntity, ItemStack stack) {
        BlockEntity blockEntity;
        if (!pLevel.isClientSide && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof RecipeBlockEntity) {
            RecipeBlockEntity recipeBlockEntity = (RecipeBlockEntity)blockEntity;
            recipeBlockEntity.getItems().setStackInSlot(0, stack.copyWithCount(1));
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        RecipeBlockEntity recipeBlockEntity;
        ItemStack itemStack;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof RecipeBlockEntity && !(itemStack = (recipeBlockEntity = (RecipeBlockEntity)blockEntity).getItems().getStackInSlot(0)).isEmpty()) {
            return itemStack.copy();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACING, FACE, WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder lootParamsBuilder) {
        List drops = super.getDrops(state, lootParamsBuilder);
        BlockEntity parameter = (BlockEntity)lootParamsBuilder.getParameter(LootContextParams.BLOCK_ENTITY);
        if (parameter instanceof RecipeBlockEntity) {
            RecipeBlockEntity recipeBlock = (RecipeBlockEntity)parameter;
            drops.add(recipeBlock.getItems().getStackInSlot(0).copyWithCount(1));
        }
        return drops;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new RecipeBlockEntity(pPos, pState);
    }
}

