/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.decoration;

import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.OilPotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.inventory.itemhandler.OilPotHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;

public class OilPotBlockEntity
extends BaseBlockEntity {
    public static final int MAX_OIL_COUNT = 256;
    private static final String OIL_COUNT = "OilCount";
    private final OilPotHandler invHandler = new OilPotHandler(this);
    private int oilCount = 0;

    public OilPotBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlocks.OIL_POT_BE.get(), pos, state);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        tag.putInt(OIL_COUNT, this.oilCount);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        if (tag.contains(OIL_COUNT)) {
            this.oilCount = tag.getInt(OIL_COUNT);
        }
    }

    public int getOilCount() {
        return this.oilCount;
    }

    public void setOilCount(int oilCount) {
        this.oilCount = oilCount;
        this.refresh();
        if (this.level == null) {
            return;
        }
        BlockState state = this.getBlockState();
        boolean hasOil = (Boolean)state.getValue((Property)OilPotBlock.HAS_OIL);
        if (!hasOil && oilCount > 0) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)OilPotBlock.HAS_OIL, (Comparable)Boolean.valueOf(true)), 3);
            return;
        }
        if (hasOil && oilCount <= 0) {
            this.level.setBlock(this.worldPosition, (BlockState)state.setValue((Property)OilPotBlock.HAS_OIL, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    @Nullable
    public IItemHandler createHandler() {
        BlockState state = this.getBlockState();
        if (state.getBlock() instanceof OilPotBlock) {
            return this.invHandler;
        }
        return null;
    }
}

