/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen;

import com.github.ysbbbbbb.kaleidoscopecookery.advancements.critereon.ModEventTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.api.blockentity.IPot;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.PotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.BaseBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.container.SimpleInput;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.PotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModParticles;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModRecipes;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModTrigger;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagCommon;
import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import com.github.ysbbbbbb.kaleidoscopecookery.item.KitchenShovelItem;
import com.github.ysbbbbbb.kaleidoscopecookery.item.OilPotItem;
import com.github.ysbbbbbb.kaleidoscopecookery.util.ItemUtils;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class PotBlockEntity
extends BaseBlockEntity
implements IPot {
    private static final int PUT_INGREDIENT_TIME = 1200;
    private static final int TAKEOUT_TIME = 800;
    private static final int BURNT_TIME = 400;
    private static final String INPUTS = "Inputs";
    private static final String CARRIER = "Carrier";
    private static final String RESULT = "Result";
    private static final String STATUS = "Status";
    private static final String CURRENT_TICK = "CurrentTick";
    private static final String STIR_FRY_COUNT = "StirFryCount";
    private static final String SEED = "Seed";
    private NonNullList<ItemStack> inputs = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
    private Ingredient carrier = Ingredient.EMPTY;
    private ItemStack result = ItemStack.EMPTY;
    private int status = 0;
    private int currentTick = 0;
    private int stirFryCount = 0;
    public long seed;
    public StirFryAnimationData animationData = new StirFryAnimationData();

    public PotBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(ModBlocks.POT_BE.get(), pPos, pBlockState);
        this.seed = System.currentTimeMillis();
    }

    @Override
    public boolean hasHeatSource(Level level) {
        BlockState belowState = level.getBlockState(this.worldPosition.below());
        if (belowState.hasProperty((Property)BlockStateProperties.LIT) && ((Boolean)belowState.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            return true;
        }
        return belowState.is(TagMod.HEAT_SOURCE_BLOCKS_WITHOUT_LIT);
    }

    public void tick(Level level) {
        if (!this.hasHeatSource(level)) {
            return;
        }
        RandomSource random = level.random;
        if (this.currentTick > 0) {
            --this.currentTick;
            if (this.currentTick % 5 == 0) {
                this.refresh();
            }
            if (this.currentTick % 20 == 0) {
                level.playSound(null, this.worldPosition, SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 0.5f + random.nextFloat() / 0.5f, 0.8f + random.nextFloat() / 0.5f);
            }
        }
        if (this.status == 0) {
            this.tickPutIngredient(level, random);
            return;
        }
        if (this.status == 1) {
            this.tickCooking(level, random);
            return;
        }
        if (this.status == 2) {
            this.tickFinished(random);
            return;
        }
        if (this.status == 3) {
            this.tickBurnt(level, random);
        }
    }

    private void tickBurnt(Level level, RandomSource random) {
        ServerLevel serverLevel;
        Level level2;
        int particleCount = 10 - this.currentTick / 5;
        if (this.currentTick % 2 == 0 && (level2 = this.level) instanceof ServerLevel) {
            serverLevel = (ServerLevel)level2;
            serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)this.worldPosition.getX() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)this.worldPosition.getY() + 0.25 + random.nextDouble() / 3.0, (double)this.worldPosition.getZ() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), particleCount, 0.0, 0.0, 0.0, 0.05);
        }
        if (this.currentTick == 0) {
            this.reset();
            level.playSound(null, this.worldPosition, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.8f);
            if (level instanceof ServerLevel) {
                serverLevel = (ServerLevel)level;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, (double)this.worldPosition.getX() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)this.worldPosition.getY() + 0.25 + random.nextDouble() / 3.0, (double)this.worldPosition.getZ() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 8, 0.0, 0.0, 0.0, 0.05);
                int count = 1 + random.nextInt(3);
                Block.popResource((Level)level, (BlockPos)this.worldPosition, (ItemStack)new ItemStack((ItemLike)Items.CHARCOAL, count));
            }
        }
    }

    private void tickFinished(RandomSource random) {
        Level level;
        if (this.currentTick % 10 == 0 && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.1 + random.nextDouble() / 2.0, (double)this.worldPosition.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.currentTick == 0) {
            this.status = 3;
            this.currentTick = 400;
            this.setChanged();
        }
    }

    private void tickCooking(Level level, RandomSource random) {
        if (this.currentTick == 0) {
            level.playSound(null, this.worldPosition, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.8f);
            this.status = 2;
            if (this.stirFryCount > 0) {
                this.result = FoodBiteRegistry.getItem(FoodBiteRegistry.SUSPICIOUS_STIR_FRY).getDefaultInstance();
                this.carrier = Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL});
            }
            this.currentTick = 800;
            this.setChanged();
            BlockState state = level.getBlockState(this.worldPosition);
            level.setBlockAndUpdate(this.worldPosition, (BlockState)state.setValue((Property)PotBlock.SHOW_OIL, (Comparable)Boolean.valueOf(false)));
        }
    }

    private void tickPutIngredient(Level level, RandomSource random) {
        ServerLevel serverLevel;
        if (this.currentTick % 10 == 0 && level instanceof ServerLevel) {
            serverLevel = (ServerLevel)level;
            serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.worldPosition.getX() + 0.5 + random.nextDouble() / 5.0 * (double)(random.nextBoolean() ? 1 : -1), (double)this.worldPosition.getY() + 0.1 + random.nextDouble() / 3.0, (double)this.worldPosition.getZ() + 0.5 + random.nextDouble() / 5.0 * (double)(random.nextBoolean() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.currentTick == 0) {
            if (this.isEmpty()) {
                this.reset();
                level.playSound(null, this.worldPosition, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.8f);
                Level level2 = this.level;
                if (level2 instanceof ServerLevel) {
                    serverLevel = (ServerLevel)level2;
                    serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.worldPosition.getX() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)this.worldPosition.getY() + 0.1 + random.nextDouble() / 3.0, (double)this.worldPosition.getZ() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 8, 0.0, 0.0, 0.0, 0.05);
                }
            } else {
                this.startCooking(level);
            }
        }
    }

    @Override
    public boolean onPlaceOil(Level level, LivingEntity user, ItemStack stack) {
        if (stack.is(TagMod.OIL)) {
            this.placeOil(level, user, level.random);
            stack.shrink(1);
            ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger(user, "put_oil_in_pot");
            return true;
        }
        if (stack.is((Item)ModItems.KITCHEN_SHOVEL.get()) && KitchenShovelItem.hasOil(stack)) {
            this.placeOil(level, user, level.random);
            KitchenShovelItem.setHasOil(stack, false);
            ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger(user, "put_oil_in_pot");
            return true;
        }
        if (stack.is((Item)ModItems.OIL_POT.get()) && OilPotItem.hasOil(stack)) {
            this.placeOil(level, user, level.random);
            OilPotItem.shrinkOilCount(stack);
            ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger(user, "put_oil_in_pot");
            return true;
        }
        return false;
    }

    private void placeOil(Level level, LivingEntity user, RandomSource random) {
        this.currentTick = 1200;
        BlockState state = level.getBlockState(this.worldPosition);
        level.setBlockAndUpdate(this.worldPosition, (BlockState)((BlockState)state.setValue((Property)PotBlock.HAS_OIL, (Comparable)Boolean.valueOf(true))).setValue((Property)PotBlock.SHOW_OIL, (Comparable)Boolean.valueOf(true)));
        level.playSound((Entity)user, this.worldPosition, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.0f, (random.nextFloat() - random.nextFloat()) * 0.8f);
        for (int i = 0; i < 10; ++i) {
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)this.worldPosition.getX() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)this.worldPosition.getY() + 0.25 + random.nextDouble() / 3.0, (double)this.worldPosition.getZ() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.05, 0.0);
        }
    }

    @Override
    public void onShovelHit(Level level, LivingEntity user, ItemStack shovel) {
        Level level2;
        if (!level.isClientSide) {
            this.seed = System.currentTimeMillis();
            this.refresh();
        }
        if ((level2 = this.level) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level2;
            RandomSource random = serverLevel.random;
            serverLevel.sendParticles((ParticleOptions)((SimpleParticleType)ModParticles.COOKING.get()), (double)this.worldPosition.getX() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)this.worldPosition.getY() + 0.1 + random.nextDouble() / 3.0, (double)this.worldPosition.getZ() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 1, 0.0, 0.0, 0.0, 0.05);
        }
        if (this.status == 0 && !this.isEmpty()) {
            this.startCooking(level);
            ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger(user, "stir_fry_in_pot");
        }
        if (this.status == 1 && this.stirFryCount > 0) {
            --this.stirFryCount;
            ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger(user, "stir_fry_in_pot");
        }
    }

    private void startCooking(Level level) {
        SimpleInput simpleInput = new SimpleInput((List<ItemStack>)this.inputs);
        level.getRecipeManager().getRecipeFor(ModRecipes.POT_RECIPE, (RecipeInput)simpleInput, level).ifPresentOrElse(recipe -> {
            PotRecipe value = (PotRecipe)recipe.value();
            this.carrier = value.carrier();
            this.result = value.assemble(simpleInput, (HolderLookup.Provider)level.registryAccess());
            this.currentTick = value.time();
            this.stirFryCount = value.stirFryCount();
        }, () -> {
            this.carrier = Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL});
            this.result = FoodBiteRegistry.getItem(FoodBiteRegistry.SUSPICIOUS_STIR_FRY).getDefaultInstance();
            this.currentTick = 200;
            this.stirFryCount = 0;
        });
        this.status = 1;
        this.refresh();
    }

    @Override
    public boolean takeOutProduct(Level level, LivingEntity user, ItemStack stack) {
        ItemStack finallyResult;
        if (this.status != 2 && this.status != 3) {
            return false;
        }
        ItemStack itemStack = finallyResult = this.status == 2 ? this.result : FoodBiteRegistry.getItem(FoodBiteRegistry.DARK_CUISINE).getDefaultInstance();
        if (finallyResult.is(FoodBiteRegistry.getItem(FoodBiteRegistry.SUSPICIOUS_STIR_FRY)) && stack.is(TagCommon.COOKED_RICE)) {
            stack.shrink(1);
            ItemUtils.getItemToLivingEntity(user, ((Item)ModItems.SUSPICIOUS_STIR_FRY_RICE_BOWL.get()).getDefaultInstance());
            this.reset();
            return true;
        }
        if (!this.carrier.isEmpty()) {
            return this.takeOutWithCarrier(level, user, stack, finallyResult);
        }
        return this.takeOutWithoutCarrier(level, user, stack, finallyResult);
    }

    private boolean takeOutWithoutCarrier(Level level, LivingEntity user, ItemStack stack, ItemStack finallyResult) {
        if (stack.is(TagMod.KITCHEN_SHOVEL)) {
            Player player;
            if (user instanceof Player && !(player = (Player)user).isSecondaryUseActive()) {
                return false;
            }
            ItemUtils.getItemToLivingEntity(user, finallyResult);
            this.reset();
            return true;
        }
        if (this.hasHeatSource(level)) {
            user.hurt(level.damageSources().inFire(), 1.0f);
            ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger(user, "hurt_when_takeout_from_pot");
        }
        this.sendActionBarMessage(user, "need_kitchen_shovel", new Object[0]);
        return false;
    }

    private boolean takeOutWithCarrier(Level level, LivingEntity user, ItemStack mainHandItem, ItemStack finallyResult) {
        Component carrierName = this.carrier.getItems()[0].getHoverName();
        if (this.carrier.test(mainHandItem)) {
            if (mainHandItem.getCount() < finallyResult.getCount()) {
                this.sendActionBarMessage(user, "carrier_count_not_enough", finallyResult.getCount(), carrierName);
                return false;
            }
            mainHandItem.shrink(finallyResult.getCount());
            ItemUtils.getItemToLivingEntity(user, finallyResult);
            this.reset();
            return true;
        }
        if (!mainHandItem.is(TagMod.KITCHEN_SHOVEL)) {
            if (this.hasHeatSource(level)) {
                user.hurt(level.damageSources().inFire(), 1.0f);
                ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger(user, "hurt_when_takeout_from_pot");
            }
            this.sendActionBarMessage(user, "need_carrier", carrierName);
        }
        return false;
    }

    private void sendActionBarMessage(LivingEntity user, String type, Object ... args) {
        if (user instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)user;
            String key = "tip.kaleidoscope_cookery.pot." + type;
            MutableComponent message = Component.translatable((String)key, (Object[])args);
            serverPlayer.connection.send((Packet)new ClientboundSetActionBarTextPacket((Component)message));
        }
    }

    public void addAllIngredients(List<ItemStack> ingredients, LivingEntity user) {
        if (this.level == null) {
            return;
        }
        if (this.status != 0) {
            return;
        }
        for (int i = 0; i < Math.min(ingredients.size(), this.inputs.size()); ++i) {
            ItemStack stack = ingredients.get(i);
            if (stack.isEmpty()) continue;
            Item containerItem = ItemUtils.getContainerItem(stack);
            if (containerItem != Items.AIR) {
                ItemUtils.getItemToLivingEntity(user, containerItem.getDefaultInstance());
            }
            this.inputs.set(i, (Object)stack.copyWithCount(1));
        }
        this.level.playSound(null, this.worldPosition, SoundEvents.LANTERN_PLACE, SoundSource.BLOCKS, 1.0f, 0.5f);
        this.refresh();
    }

    @Override
    public boolean addIngredient(Level level, LivingEntity user, ItemStack itemStack) {
        if (this.status != 0) {
            return false;
        }
        if (!itemStack.has(DataComponents.FOOD) && !itemStack.is(TagMod.POT_INGREDIENT)) {
            return false;
        }
        for (int i = 0; i < this.inputs.size(); ++i) {
            ItemStack item = (ItemStack)this.inputs.get(i);
            if (!item.isEmpty()) continue;
            Item containerItem = ItemUtils.getContainerItem(itemStack);
            if (containerItem != Items.AIR) {
                ItemUtils.getItemToLivingEntity(user, containerItem.getDefaultInstance());
            }
            this.inputs.set(i, (Object)itemStack.split(1));
            level.playSound(null, this.worldPosition, SoundEvents.LANTERN_PLACE, SoundSource.BLOCKS, 1.0f, 0.5f);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeIngredient(Level level, LivingEntity user) {
        if (this.status != 0) {
            return false;
        }
        for (int i = this.inputs.size() - 1; i >= 0; --i) {
            ItemStack stack = (ItemStack)this.inputs.get(i);
            if (stack.isEmpty()) continue;
            if (!this.containerIsMatch(user, stack)) {
                return false;
            }
            this.inputs.set(i, (Object)ItemStack.EMPTY);
            ItemUtils.getItemToLivingEntity(user, stack);
            if (this.hasHeatSource(level)) {
                user.hurt(level.damageSources().inFire(), 1.0f);
                ((ModEventTrigger)((Object)ModTrigger.EVENT.get())).trigger(user, "hurt_when_takeout_from_pot");
            }
            return true;
        }
        return false;
    }

    private boolean containerIsMatch(LivingEntity user, ItemStack stack) {
        Item containerItem = ItemUtils.getContainerItem(stack);
        if (containerItem == Items.AIR) {
            return true;
        }
        if (user.getMainHandItem().is(containerItem)) {
            user.getMainHandItem().shrink(1);
            return true;
        }
        if (user instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)user;
            player.sendSystemMessage((Component)Component.translatable((String)"tip.kaleidoscope_cookery.kitchen.remove_ingredient.need_container", (Object[])new Object[]{containerItem.getDefaultInstance().getHoverName()}));
        }
        return false;
    }

    public void reset() {
        this.inputs.clear();
        this.carrier = Ingredient.EMPTY;
        this.result = ItemStack.EMPTY;
        this.status = 0;
        this.currentTick = 0;
        this.stirFryCount = 0;
        this.setChanged();
        if (this.level != null) {
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)((BlockState)state.setValue((Property)PotBlock.HAS_OIL, (Comparable)Boolean.valueOf(false))).setValue((Property)PotBlock.SHOW_OIL, (Comparable)Boolean.valueOf(false)));
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.put(INPUTS, (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.inputs, (HolderLookup.Provider)registries));
        tag.put(CARRIER, (Tag)Ingredient.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.carrier).getOrThrow());
        tag.put(RESULT, this.result.saveOptional(registries));
        tag.putInt(STATUS, this.status);
        tag.putInt(CURRENT_TICK, this.currentTick);
        tag.putInt(STIR_FRY_COUNT, this.stirFryCount);
        tag.putLong(SEED, this.seed);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inputs = NonNullList.withSize((int)9, (Object)ItemStack.EMPTY);
        if (tag.contains(INPUTS, 10)) {
            ContainerHelper.loadAllItems((CompoundTag)tag.getCompound(INPUTS), this.inputs, (HolderLookup.Provider)registries);
        }
        if (tag.contains(CARRIER, 10)) {
            CompoundTag compound = tag.getCompound(CARRIER);
            this.carrier = (Ingredient)((Pair)Ingredient.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)compound).getOrThrow()).getFirst();
        }
        if (tag.contains(RESULT, 10)) {
            this.result = ItemStack.parseOptional((HolderLookup.Provider)registries, (CompoundTag)tag.getCompound(RESULT));
        }
        this.status = tag.getInt(STATUS);
        this.currentTick = tag.getInt(CURRENT_TICK);
        this.stirFryCount = tag.getInt(STIR_FRY_COUNT);
        this.seed = tag.getLong(SEED);
    }

    public List<ItemStack> getInputs() {
        return this.inputs;
    }

    public SimpleInput getContainer() {
        return new SimpleInput((List<ItemStack>)this.inputs);
    }

    public boolean isEmpty() {
        for (ItemStack stack : this.inputs) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public boolean hasCarrier() {
        return !this.carrier.isEmpty();
    }

    public ItemStack getResult() {
        return this.result;
    }

    public long getSeed() {
        return this.seed;
    }

    public int getCurrentTick() {
        return this.currentTick;
    }

    public static class StirFryAnimationData {
        public long preSeed = -1L;
        public long timestamp = -1L;
        public float[] randomHeights = new float[0];
    }
}

