/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.render.block;

import com.github.ysbbbbbb.kaleidoscopecookery.api.client.render.ISoupBaseRender;
import com.github.ysbbbbbb.kaleidoscopecookery.api.recipe.soupbase.ISoupBase;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.StockpotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.StockpotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.client.resources.ItemRenderReplacer;
import com.github.ysbbbbbb.kaleidoscopecookery.client.resources.ItemRenderReplacerReloadListener;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.StockpotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.soupbase.SoupBaseManager;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;

public class StockpotBlockEntityRender
implements BlockEntityRenderer<StockpotBlockEntity> {
    private final BlockEntityRendererProvider.Context context;
    private final Function<ResourceLocation, ISoupBaseRender> soupBaseRender;

    public StockpotBlockEntityRender(BlockEntityRendererProvider.Context context) {
        this.context = context;
        this.soupBaseRender = Util.memoize(id -> {
            ISoupBase soupBase = SoupBaseManager.getSoupBase(id);
            if (soupBase != null) {
                return soupBase.getRender();
            }
            return null;
        });
    }

    public void render(StockpotBlockEntity stockpot, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        if (((Boolean)stockpot.getBlockState().getValue((Property)StockpotBlock.HAS_LID)).booleanValue()) {
            return;
        }
        int status = stockpot.getStatus();
        ISoupBaseRender soupBase = this.soupBaseRender.apply(stockpot.getSoupBaseId());
        if (status == 1) {
            soupBase.renderWhenPutIngredient(stockpot, partialTick, poseStack, buffer, packedLight, packedOverlay, 0.38f);
            this.renderItems(stockpot, poseStack, buffer, packedLight, packedOverlay, false);
        } else if (status == 2) {
            soupBase.renderWhenCooking(stockpot, partialTick, poseStack, buffer, packedLight, packedOverlay, ((StockpotRecipe)stockpot.recipe.value()).cookingTexture(), 0.38f);
            this.renderItems(stockpot, poseStack, buffer, packedLight, packedOverlay, true);
        } else if (status == 3) {
            int takeoutCount = stockpot.getTakeoutCount();
            int maxCount = Math.min(stockpot.getResult().getCount(), 9);
            float soupHeight = 0.065f + 0.315f / (float)maxCount * (float)takeoutCount;
            soupBase.renderWhenFinished(stockpot, partialTick, poseStack, buffer, packedLight, packedOverlay, ((StockpotRecipe)stockpot.recipe.value()).finishedTexture(), soupHeight);
        }
    }

    private void renderItems(StockpotBlockEntity stockpot, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay, boolean isFinished) {
        NonNullList<ItemStack> items = stockpot.getInputs();
        items.forEach(stack -> {
            if (!stack.isEmpty()) {
                int random = stack.hashCode();
                long time = (long)random + System.currentTimeMillis();
                float offsetX = (float)(random % 100) * 0.002f;
                float offsetZ = (float)(Math.sin((double)time * 5.0E-4) * 0.2);
                float offsetY = (float)(random % 50) * 0.004f;
                float yRot = (random % 2 == 0 ? -1 : 1) * 20 + random % 10;
                BakedModel model = isFinished ? ItemRenderReplacer.getModel(stockpot.getLevel(), stack, ItemRenderReplacerReloadListener.INSTANCE.stockpotFinished()) : ItemRenderReplacer.getModel(stockpot.getLevel(), stack, ItemRenderReplacerReloadListener.INSTANCE.stockpotCooking());
                poseStack.pushPose();
                poseStack.mulPose(Axis.XP.rotationDegrees((float)(85 + random % 10)));
                poseStack.scale(0.5f, 0.5f, 0.5f);
                poseStack.translate(0.9 + (double)offsetX, 0.9 + (double)offsetY, -0.5 + (double)offsetZ);
                poseStack.mulPose(Axis.YP.rotationDegrees(yRot));
                poseStack.mulPose(Axis.ZP.rotationDegrees((float)(random % 360)));
                this.context.getItemRenderer().render(stack, ItemDisplayContext.FIXED, false, poseStack, buffer, packedLight, packedOverlay, model);
                poseStack.popPose();
            }
        });
    }
}

