/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.resources;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public record ItemRenderReplacer(Map<ResourceLocation, Object> pot, Map<ResourceLocation, Object> stockpotCooking, Map<ResourceLocation, Object> stockpotFinished, Map<ResourceLocation, Object> millstone, Map<ResourceLocation, Object> steamer) {
    public static final Codec<Object> RL_CODEC = Codec.STRING.comapFlatMap(ItemRenderReplacer::toLocation, ItemRenderReplacer::fromLocation).stable();
    public static final Codec<ItemRenderReplacer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, RL_CODEC).fieldOf("pot").forGetter(ItemRenderReplacer::pot), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, RL_CODEC).fieldOf("stockpot_cooking").forGetter(ItemRenderReplacer::stockpotCooking), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, RL_CODEC).fieldOf("stockpot_finished").forGetter(ItemRenderReplacer::stockpotFinished), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, RL_CODEC).fieldOf("millstone").forGetter(ItemRenderReplacer::millstone), (App)Codec.unboundedMap((Codec)ResourceLocation.CODEC, RL_CODEC).fieldOf("steamer").forGetter(ItemRenderReplacer::steamer)).apply((Applicative)instance, ItemRenderReplacer::new));
    private static Function<Object, BakedModel> CACHE = ItemRenderReplacer.createNewCache();

    public ItemRenderReplacer() {
        this(Maps.newHashMap(), Maps.newHashMap(), Maps.newHashMap(), Maps.newHashMap(), Maps.newHashMap());
    }

    private static Function<Object, BakedModel> createNewCache() {
        return Util.memoize(id -> {
            ModelManager modelManager = Minecraft.getInstance().getItemRenderer().getItemModelShaper().getModelManager();
            if (id instanceof ModelResourceLocation) {
                ModelResourceLocation modelRl = (ModelResourceLocation)id;
                return modelManager.getModel(modelRl);
            }
            if (id instanceof ResourceLocation) {
                ResourceLocation rl = (ResourceLocation)id;
                return modelManager.getModel(ModelResourceLocation.standalone((ResourceLocation)rl));
            }
            return modelManager.getMissingModel();
        });
    }

    public static void resetCache() {
        CACHE = ItemRenderReplacer.createNewCache();
    }

    public static BakedModel getModel(@Nullable Level level, ItemStack stack, Map<ResourceLocation, Object> models) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ResourceLocation key = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        Object location = models.get(key);
        if (location == null) {
            return itemRenderer.getModel(stack, level, null, 0);
        }
        return CACHE.apply(location);
    }

    private static DataResult<Object> toLocation(String input) {
        String[] split = input.split("#");
        if (split.length > 1) {
            return DataResult.success((Object)new ModelResourceLocation(ResourceLocation.parse((String)split[0]), split[1]));
        }
        return DataResult.success((Object)ResourceLocation.parse((String)input));
    }

    private static String fromLocation(Object input) {
        return input.toString();
    }

    public void addAll(ItemRenderReplacer other) {
        this.pot.putAll(other.pot);
        this.stockpotCooking.putAll(other.stockpotCooking);
        this.stockpotFinished.putAll(other.stockpotFinished);
        this.millstone.putAll(other.millstone);
        this.steamer.putAll(other.steamer);
    }
}

