/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.client.resources;

import com.github.ysbbbbbb.kaleidoscopecookery.KaleidoscopeCookery;
import com.github.ysbbbbbb.kaleidoscopecookery.client.resources.ItemRenderReplacer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;

public class ItemRenderReplacerReloadListener
implements ResourceManagerReloadListener {
    public static final ItemRenderReplacer INSTANCE = new ItemRenderReplacer();
    private static final ResourceLocation FILE_PATH = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"models/item_render_replacer.json");

    public void onResourceManagerReload(ResourceManager resourceManager) {
        resourceManager.listPacks().forEach(packResources -> {
            IoSupplier resource = packResources.getResource(PackType.CLIENT_RESOURCES, FILE_PATH);
            if (resource == null) {
                return;
            }
            try (InputStream inputStream = (InputStream)resource.get();
                 InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                DataResult result = ItemRenderReplacer.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement);
                if (result.result().isPresent()) {
                    INSTANCE.addAll((ItemRenderReplacer)result.result().get());
                    KaleidoscopeCookery.LOGGER.info("Successfully loaded item render replacer data");
                } else if (result.error().isPresent()) {
                    KaleidoscopeCookery.LOGGER.error("Failed to parse item render replacer data: {}", (Object)((DataResult.Error)result.error().get()).message());
                }
            }
            catch (Exception e) {
                KaleidoscopeCookery.LOGGER.error("Failed to load item render replacer resource", (Throwable)e);
            }
        });
    }
}

