/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.compat.farmersdelight;

import com.github.ysbbbbbb.kaleidoscopecookery.api.event.StockpotMatchRecipeEvent;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.StockpotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.crafting.serializer.StockpotRecipeSerializer;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.RecipeWrapper;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;

public class CookingPotCompat {
    static void getTransformRecipeForJei(Level level, List<RecipeHolder<StockpotRecipe>> recipes) {
        if (level == null) {
            return;
        }
        RecipeManager recipeManager = level.getRecipeManager();
        recipeManager.getAllRecipesFor((RecipeType)ModRecipeTypes.COOKING.get()).forEach(recipe -> recipes.add(CookingPotCompat.transformRecipe((RecipeHolder<CookingPotRecipe>)recipe, level)));
    }

    static RecipeHolder<StockpotRecipe> transformRecipe(RecipeHolder<CookingPotRecipe> holder, Level level) {
        CookingPotRecipe cookingPotRecipe = (CookingPotRecipe)holder.value();
        StockpotRecipe recipe = new StockpotRecipe((NonNullList<Ingredient>)cookingPotRecipe.getIngredients(), cookingPotRecipe.getResultItem((HolderLookup.Provider)level.registryAccess()), cookingPotRecipe.getCookTime(), cookingPotRecipe.getOutputContainer());
        return new RecipeHolder(holder.id(), (Recipe)recipe);
    }

    @SubscribeEvent
    static void afterStockpotRecipeMatch(StockpotMatchRecipeEvent.Post event) {
        RecipeHolder<StockpotRecipe> rawOutput = event.getRawOutput();
        RecipeManager recipeManager = event.getLevel().getRecipeManager();
        if (rawOutput.id() != StockpotRecipeSerializer.EMPTY_ID) {
            return;
        }
        List<ItemStack> items = event.getInput().getInputs();
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandler)new ItemStackHandler(NonNullList.copyOf(items)));
        recipeManager.getRecipeFor((RecipeType)ModRecipeTypes.COOKING.get(), (RecipeInput)wrapper, event.getLevel()).ifPresent(recipe -> event.setOutput(CookingPotCompat.transformRecipe((RecipeHolder<CookingPotRecipe>)recipe, event.getLevel())));
    }
}

