/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.compat.jade.block;

import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.ChoppingBoardBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.compat.jade.ModPlugin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum ChoppingBoardComponentProvider implements IBlockComponentProvider
{
    INSTANCE;


    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig pluginConfig) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (!(blockEntity instanceof ChoppingBoardBlockEntity)) {
            return;
        }
        ChoppingBoardBlockEntity choppingBoard = (ChoppingBoardBlockEntity)blockEntity;
        ItemStack cutStack = choppingBoard.getCurrentCutStack();
        if (cutStack.isEmpty()) {
            return;
        }
        IElement icon = IElementHelper.get().smallItem(cutStack);
        MutableComponent stackName = IDisplayHelper.get().stripColor(cutStack.getHoverName());
        MutableComponent info = Component.translatable((String)"jade.kaleidoscope_cookery.chopping_board.cut_count", (Object[])new Object[]{choppingBoard.getCurrentCutCount(), choppingBoard.getMaxCutCount()});
        tooltip.add(icon);
        tooltip.append(IElementHelper.get().spacer(2, 1));
        tooltip.append((Component)stackName);
        tooltip.add((Component)info);
    }

    public ResourceLocation getUid() {
        return ModPlugin.CHOPPING_BOARD;
    }
}

