/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe;

import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeInput;

public interface BaseRecipe<C extends RecipeInput>
extends Recipe<C> {
    public static final int RECIPES_SIZE = 9;

    public static Ingredient[] fillInputs(List<Ingredient> inputs) {
        Ingredient[] newInputs = new Ingredient[9];
        for (int i = 0; i < 9; ++i) {
            newInputs[i] = i < inputs.size() ? inputs.get(i) : Ingredient.EMPTY;
        }
        return newInputs;
    }

    default public ItemStack assemble(C container, HolderLookup.Provider registryAccess) {
        return this.getResultItem(registryAccess).copy();
    }

    default public boolean isSpecial() {
        return true;
    }

    default public boolean canCraftInDimensions(int width, int height) {
        return false;
    }
}

