/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.crafting.serializer;

import com.github.ysbbbbbb.kaleidoscopecookery.crafting.recipe.StockpotRecipe;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModSoupBases;
import com.github.ysbbbbbb.kaleidoscopecookery.util.StreamCodecUtil;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class StockpotRecipeSerializer
implements RecipeSerializer<StockpotRecipe> {
    public static final int DEFAULT_TIME = 300;
    public static final int DEFAULT_COOKING_BUBBLE_COLOR = 16772291;
    public static final int DEFAULT_FINISHED_BUBBLE_COLOR = 16034443;
    public static final Ingredient DEFAULT_CARRIER = Ingredient.of((ItemLike[])new ItemLike[]{Items.BOWL});
    public static final ResourceLocation DEFAULT_SOUP_BASE = ModSoupBases.WATER;
    public static final ResourceLocation EMPTY_ID = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"stockpot/empty");
    public static final ResourceLocation DEFAULT_COOKING_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"stockpot/default_cooking");
    public static final ResourceLocation DEFAULT_FINISHED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"stockpot/default_finished");
    public static final MapCodec<StockpotRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.listOf().fieldOf("ingredients").xmap(list -> list, list -> list.stream().filter(i -> !i.isEmpty()).toList()).forGetter(StockpotRecipe::getIngredients), (App)ResourceLocation.CODEC.optionalFieldOf("soup_base", (Object)DEFAULT_SOUP_BASE).forGetter(StockpotRecipe::soupBase), (App)ItemStack.CODEC.fieldOf("result").forGetter(StockpotRecipe::result), (App)Codec.INT.optionalFieldOf("time", (Object)300).forGetter(StockpotRecipe::time), (App)Ingredient.CODEC.optionalFieldOf("carrier", (Object)DEFAULT_CARRIER).forGetter(StockpotRecipe::carrier), (App)ResourceLocation.CODEC.optionalFieldOf("cooking_texture", (Object)DEFAULT_COOKING_TEXTURE).forGetter(StockpotRecipe::cookingTexture), (App)ResourceLocation.CODEC.optionalFieldOf("finished_texture", (Object)DEFAULT_FINISHED_TEXTURE).forGetter(StockpotRecipe::finishedTexture), (App)Codec.INT.optionalFieldOf("cooking_bubble_color", (Object)16772291).forGetter(StockpotRecipe::cookingBubbleColor), (App)Codec.INT.optionalFieldOf("finished_bubble_color", (Object)16034443).forGetter(StockpotRecipe::finishedBubbleColor)).apply((Applicative)instance, StockpotRecipe::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, StockpotRecipe> STREAM_CODEC = StreamCodecUtil.composite(Ingredient.CONTENTS_STREAM_CODEC.apply(ByteBufCodecs.list()), StockpotRecipe::getIngredients, ResourceLocation.STREAM_CODEC, StockpotRecipe::soupBase, ItemStack.STREAM_CODEC, StockpotRecipe::result, ByteBufCodecs.INT, StockpotRecipe::time, Ingredient.CONTENTS_STREAM_CODEC, StockpotRecipe::carrier, ResourceLocation.STREAM_CODEC, StockpotRecipe::cookingTexture, ResourceLocation.STREAM_CODEC, StockpotRecipe::finishedTexture, ByteBufCodecs.INT, StockpotRecipe::cookingBubbleColor, ByteBufCodecs.INT, StockpotRecipe::finishedBubbleColor, StockpotRecipe::new);

    public static RecipeHolder<StockpotRecipe> getEmptyRecipe() {
        StockpotRecipe stockpotRecipe = new StockpotRecipe(Lists.newArrayList(), DEFAULT_SOUP_BASE, ItemStack.EMPTY, 300, DEFAULT_CARRIER, DEFAULT_COOKING_TEXTURE, DEFAULT_FINISHED_TEXTURE, 16772291, 16034443);
        return new RecipeHolder(EMPTY_ID, (Recipe)stockpotRecipe);
    }

    public MapCodec<StockpotRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, StockpotRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

