/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.datagen.model;

import com.github.ysbbbbbb.kaleidoscopecookery.block.crop.RiceCropBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.decoration.TableBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.food.FoodBiteBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.EnamelBasinBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.OilPotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.PotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.ShawarmaSpitBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.SteamerBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.StockpotBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.kitchen.StoveBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.block.misc.ChiliRistraBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModBlocks;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.FoodBiteRegistry;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;

public class BlockStateGenerator
extends BlockStateProvider {
    public BlockStateGenerator(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "kaleidoscope_cookery", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.horizontalBlock((Block)ModBlocks.STOVE.get(), blockState -> {
            if (((Boolean)blockState.getValue((Property)StoveBlock.LIT)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/stove_lit"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/stove"));
        });
        this.horizontalBlock((Block)ModBlocks.POT.get(), blockState -> {
            if (((Boolean)blockState.getValue((Property)PotBlock.HAS_OIL)).booleanValue() && ((Boolean)blockState.getValue((Property)PotBlock.SHOW_OIL)).booleanValue()) {
                if (((Boolean)blockState.getValue((Property)PotBlock.HAS_BASE)).booleanValue()) {
                    return new ModelFile.UncheckedModelFile(this.modLoc("block/pot_base_has_oil"));
                }
                return new ModelFile.UncheckedModelFile(this.modLoc("block/pot_has_oil"));
            }
            if (((Boolean)blockState.getValue((Property)PotBlock.HAS_BASE)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/pot_base"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/pot"));
        });
        this.horizontalBlock((Block)ModBlocks.STOCKPOT.get(), blockState -> {
            if (((Boolean)blockState.getValue((Property)StockpotBlock.HAS_LID)).booleanValue()) {
                if (((Boolean)blockState.getValue((Property)StockpotBlock.HAS_BASE)).booleanValue()) {
                    return new ModelFile.UncheckedModelFile(this.modLoc("block/stockpot_base_has_lid"));
                }
                if (((Boolean)blockState.getValue((Property)StockpotBlock.HAS_CHAINS)).booleanValue()) {
                    return new ModelFile.UncheckedModelFile(this.modLoc("block/stockpot_chains_has_lid"));
                }
                return new ModelFile.UncheckedModelFile(this.modLoc("block/stockpot_has_lid"));
            }
            if (((Boolean)blockState.getValue((Property)StockpotBlock.HAS_BASE)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/stockpot_base"));
            }
            if (((Boolean)blockState.getValue((Property)StockpotBlock.HAS_CHAINS)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/stockpot_chains"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/stockpot"));
        });
        this.horizontalBlock((Block)ModBlocks.SHAWARMA_SPIT.get(), blockState -> {
            if (((Boolean)blockState.getValue((Property)ShawarmaSpitBlock.POWERED)).booleanValue()) {
                if (blockState.getValue(ShawarmaSpitBlock.HALF) == DoubleBlockHalf.LOWER) {
                    return new ModelFile.UncheckedModelFile(this.modLoc("block/shawarma_spit_powered_lower"));
                }
                return new ModelFile.UncheckedModelFile(this.modLoc("block/shawarma_spit_powered_upper"));
            }
            if (blockState.getValue(ShawarmaSpitBlock.HALF) == DoubleBlockHalf.LOWER) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/shawarma_spit_lower"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/shawarma_spit_upper"));
        });
        this.horizontalBlock((Block)ModBlocks.OIL_POT.get(), blockState -> {
            if (((Boolean)blockState.getValue((Property)OilPotBlock.HAS_OIL)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/oil_pot_with_oil"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/oil_pot"));
        });
        this.horizontalBlock((Block)ModBlocks.STEAMER.get(), blockState -> {
            boolean hasLid = (Boolean)blockState.getValue((Property)SteamerBlock.HAS_LID);
            boolean hasBase = (Boolean)blockState.getValue((Property)SteamerBlock.HAS_BASE);
            boolean half = (Boolean)blockState.getValue((Property)SteamerBlock.HALF);
            if (hasLid && hasBase && half) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/steamer_half_lid_base"));
            }
            if (hasLid && hasBase) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/steamer_full_lid_base"));
            }
            if (hasLid && half) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/steamer_half_lid"));
            }
            if (hasLid) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/steamer_full_lid"));
            }
            if (hasBase && half) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/steamer_half_base"));
            }
            if (hasBase) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/steamer_full_base"));
            }
            if (half) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/steamer_half"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/steamer_full"));
        });
        FoodBiteRegistry.FOOD_DATA_MAP.forEach((key, value) -> {
            Block block = (Block)BuiltInRegistries.BLOCK.get(key);
            this.addFoodBiteBlock(block, (ResourceLocation)key);
        });
        this.horizontalBlock((Block)ModBlocks.FRUIT_BASKET.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/fruit_basket")));
        this.horizontalBlock((Block)ModBlocks.CHOPPING_BOARD.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/chopping_board")));
        this.horizontalBlock((Block)ModBlocks.KITCHENWARE_RACKS.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/kitchenware_racks")));
        this.cookStool(ModBlocks.COOK_STOOL_OAK, "oak");
        this.cookStool(ModBlocks.COOK_STOOL_SPRUCE, "spruce");
        this.cookStool(ModBlocks.COOK_STOOL_ACACIA, "acacia");
        this.cookStool(ModBlocks.COOK_STOOL_BAMBOO, "bamboo");
        this.cookStool(ModBlocks.COOK_STOOL_BIRCH, "birch");
        this.cookStool(ModBlocks.COOK_STOOL_CHERRY, "cherry");
        this.cookStool(ModBlocks.COOK_STOOL_CRIMSON, "crimson");
        this.cookStool(ModBlocks.COOK_STOOL_DARK_OAK, "dark_oak");
        this.cookStool(ModBlocks.COOK_STOOL_JUNGLE, "jungle");
        this.cookStool(ModBlocks.COOK_STOOL_MANGROVE, "mangrove");
        this.cookStool(ModBlocks.COOK_STOOL_WARPED, "warped");
        this.chair(ModBlocks.CHAIR_OAK, "oak");
        this.chair(ModBlocks.CHAIR_SPRUCE, "spruce");
        this.chair(ModBlocks.CHAIR_ACACIA, "acacia");
        this.chair(ModBlocks.CHAIR_BAMBOO, "bamboo");
        this.chair(ModBlocks.CHAIR_BIRCH, "birch");
        this.chair(ModBlocks.CHAIR_CHERRY, "cherry");
        this.chair(ModBlocks.CHAIR_CRIMSON, "crimson");
        this.chair(ModBlocks.CHAIR_DARK_OAK, "dark_oak");
        this.chair(ModBlocks.CHAIR_JUNGLE, "jungle");
        this.chair(ModBlocks.CHAIR_MANGROVE, "mangrove");
        this.chair(ModBlocks.CHAIR_WARPED, "warped");
        this.table(ModBlocks.TABLE_OAK, "oak");
        this.table(ModBlocks.TABLE_SPRUCE, "spruce");
        this.table(ModBlocks.TABLE_ACACIA, "acacia");
        this.table(ModBlocks.TABLE_BAMBOO, "bamboo");
        this.table(ModBlocks.TABLE_BIRCH, "birch");
        this.table(ModBlocks.TABLE_CHERRY, "cherry");
        this.table(ModBlocks.TABLE_CRIMSON, "crimson");
        this.table(ModBlocks.TABLE_DARK_OAK, "dark_oak");
        this.table(ModBlocks.TABLE_JUNGLE, "jungle");
        this.table(ModBlocks.TABLE_MANGROVE, "mangrove");
        this.table(ModBlocks.TABLE_WARPED, "warped");
        this.simpleBlock((Block)ModBlocks.OIL_BLOCK.get());
        this.crop(ModBlocks.TOMATO_CROP, "tomato");
        this.crop(ModBlocks.CHILI_CROP, "chili");
        this.crop(ModBlocks.LETTUCE_CROP, "lettuce");
        this.axisBlock((RotatedPillarBlock)ModBlocks.STRAW_BLOCK.get());
        this.horizontalFaceBlock((Block)ModBlocks.RECIPE_BLOCK.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/recipe_block")));
        this.riceCrop();
        this.variantBlock((Block)ModBlocks.ENAMEL_BASIN.get(), blockState -> {
            if (((Boolean)blockState.getValue((Property)EnamelBasinBlock.HAS_LID)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/enamel_basin/base"));
            }
            int oilCount = (Integer)blockState.getValue((Property)EnamelBasinBlock.OIL_COUNT);
            if (oilCount <= 0) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/enamel_basin/empty"));
            }
            if (oilCount <= 10) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/enamel_basin/low"));
            }
            if (oilCount <= 20) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/enamel_basin/middle"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/enamel_basin/high"));
        });
        this.variantBlock((Block)ModBlocks.CHILI_RISTRA.get(), blockState -> {
            if (((Boolean)blockState.getValue((Property)ChiliRistraBlock.IS_HEAD)).booleanValue()) {
                if (((Boolean)blockState.getValue((Property)ChiliRistraBlock.SHEARED)).booleanValue()) {
                    return new ModelFile.UncheckedModelFile(this.modLoc("block/chili_ristra/head_sheared"));
                }
                return new ModelFile.UncheckedModelFile(this.modLoc("block/chili_ristra/head"));
            }
            if (((Boolean)blockState.getValue((Property)ChiliRistraBlock.SHEARED)).booleanValue()) {
                return new ModelFile.UncheckedModelFile(this.modLoc("block/chili_ristra/body_sheared"));
            }
            return new ModelFile.UncheckedModelFile(this.modLoc("block/chili_ristra/body"));
        });
    }

    public void variantBlock(Block block, Function<BlockState, ModelFile> modelFunc) {
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).build());
    }

    public void crop(DeferredBlock<Block> block, String name) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            int age = (Integer)state.getValue((Property)CropBlock.AGE);
            ResourceLocation file = this.modLoc("block/crop/%s/stage%d".formatted(name, age));
            return ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(file)).build();
        });
    }

    public void riceCrop() {
        this.getVariantBuilder((Block)ModBlocks.RICE_CROP.get()).forAllStates(state -> {
            int age = (Integer)state.getValue((Property)CropBlock.AGE);
            int location = (Integer)state.getValue((Property)RiceCropBlock.LOCATION);
            ResourceLocation file = location == 0 ? this.modLoc("block/crop/rice/stage%d_down".formatted(age)) : (location == 1 ? this.modLoc("block/crop/rice/stage%d_middle".formatted(age)) : this.modLoc("block/crop/rice/stage%d_up".formatted(age)));
            return ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(file)).build();
        });
    }

    public void cookStool(DeferredBlock<Block> block, String name) {
        this.horizontalBlock((Block)block.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/cook_stool/" + name)));
    }

    public void chair(DeferredBlock<Block> block, String name) {
        this.horizontalBlock((Block)block.get(), (ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/chair/" + name)));
    }

    private void table(DeferredBlock<Block> block, String name) {
        ModelFile.UncheckedModelFile leftModel = new ModelFile.UncheckedModelFile(this.modLoc("block/table/%s_left".formatted(name)));
        ModelFile.UncheckedModelFile rightModel = new ModelFile.UncheckedModelFile(this.modLoc("block/table/%s_right".formatted(name)));
        this.getVariantBuilder((Block)block.get()).forAllStates(blockState -> {
            int rotation;
            int position = (Integer)blockState.getValue((Property)TableBlock.POSITION);
            if (position == 0) {
                return ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/table/%s_single".formatted(name)))).build();
            }
            int n = rotation = blockState.getValue(TableBlock.AXIS) == Direction.Axis.X ? 180 : 270;
            if (position == 1) {
                return ConfiguredModel.builder().modelFile((ModelFile)leftModel).rotationY(rotation).build();
            }
            if (position == 3) {
                return ConfiguredModel.builder().modelFile((ModelFile)rightModel).rotationY(rotation).build();
            }
            return ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(this.modLoc("block/table/%s_middle".formatted(name)))).rotationY(rotation).build();
        });
    }

    public void addFoodBiteBlock(Block block, ResourceLocation id) {
        this.horizontalBlock(block, blockState -> {
            Block patt0$temp = blockState.getBlock();
            if (!(patt0$temp instanceof FoodBiteBlock)) {
                throw new IllegalArgumentException("Block must be an instance of FoodBiteBlock");
            }
            FoodBiteBlock foodBiteBlock = (FoodBiteBlock)patt0$temp;
            int bites = (Integer)blockState.getValue((Property)foodBiteBlock.getBites());
            ResourceLocation model = ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)"block/food/%s/%s_%d".formatted(id.getPath(), id.getPath(), bites));
            return new ModelFile.UncheckedModelFile(model);
        });
    }
}

