/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.entity;

import com.github.ysbbbbbb.kaleidoscopecookery.init.tag.TagMod;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SitEntity
extends Entity {
    public static final EntityType<SitEntity> TYPE = EntityType.Builder.of(SitEntity::new, (MobCategory)MobCategory.MISC).sized(0.5f, 0.1f).clientTrackingRange(10).noSave().noSummon().build("sit");
    private int passengerTick = 0;

    public SitEntity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public SitEntity(Level worldIn, BlockPos pos) {
        this(TYPE, worldIn);
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.4375, (double)pos.getZ() + 0.5);
    }

    public SitEntity(Level worldIn, BlockPos pos, double y) {
        this(TYPE, worldIn);
        this.setPos((double)pos.getX() + 0.5, (double)pos.getY() + y, (double)pos.getZ() + 0.5);
    }

    public Vec3 getPassengerRidingPosition(Entity entity) {
        return super.getPassengerRidingPosition(entity).add(0.0, -0.0625, 0.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
    }

    public void tick() {
        if (!this.level().isClientSide) {
            BlockState blockState;
            this.checkBelowWorld();
            this.checkPassengers();
            if (this.tickCount % 20 == 0 && !(blockState = this.level().getBlockState(this.blockPosition())).is(TagMod.SITTABLE)) {
                this.discard();
            }
        }
    }

    private void checkPassengers() {
        this.passengerTick = this.getPassengers().isEmpty() ? ++this.passengerTick : 0;
        if (this.passengerTick > 10) {
            this.discard();
        }
    }

    public boolean skipAttackInteraction(Entity targetEntity) {
        return true;
    }

    public boolean hurt(DamageSource damageSource, float damageAmount) {
        return false;
    }

    public void move(MoverType moverType, Vec3 movement) {
    }

    public void push(Entity pushedEntity) {
    }

    public void push(double x, double y, double z) {
    }

    protected boolean repositionEntityAfterLoad() {
        return false;
    }

    public void thunderHit(ServerLevel serverLevel, LightningBolt lightningBolt) {
    }

    public void refreshDimensions() {
    }

    public boolean canCollideWith(Entity entity) {
        return false;
    }
}

