/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.event;

import com.github.ysbbbbbb.kaleidoscopecookery.api.event.RecipeItemEvent;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModItems;
import com.github.ysbbbbbb.kaleidoscopecookery.item.FruitBasketItem;
import com.github.ysbbbbbb.kaleidoscopecookery.item.TransmutationLunchBagItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

@EventBusSubscriber(modid="kaleidoscope_cookery")
public class SpecialRecipeItemEvent {
    @SubscribeEvent
    public static void onCheckItemEvent(RecipeItemEvent.CheckItem event) {
        ItemStack stack = event.getStack();
        if (stack.is((Item)ModItems.FRUIT_BASKET.get())) {
            ItemStackHandler items = FruitBasketItem.getItems(stack);
            SpecialRecipeItemEvent.addItems(event, (IItemHandler)items);
            FruitBasketItem.saveItems(stack, items);
            return;
        }
        if (stack.is((Item)ModItems.TRANSMUTATION_LUNCH_BAG.get())) {
            ItemStackHandler items = TransmutationLunchBagItem.getItems(stack);
            SpecialRecipeItemEvent.addItems(event, (IItemHandler)items);
            TransmutationLunchBagItem.setItems(stack, items);
            return;
        }
        IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (handler != null) {
            SpecialRecipeItemEvent.addItems(event, handler);
        }
    }

    @SubscribeEvent
    public static void onDeductItemEvent(RecipeItemEvent.DeductItem event) {
        ItemStack stack = event.getStack();
        if (stack.is((Item)ModItems.FRUIT_BASKET.get())) {
            ItemStackHandler items = FruitBasketItem.getItems(stack);
            SpecialRecipeItemEvent.deductItems(event, (IItemHandler)items);
            FruitBasketItem.saveItems(stack, items);
            return;
        }
        if (stack.is((Item)ModItems.TRANSMUTATION_LUNCH_BAG.get())) {
            ItemStackHandler items = TransmutationLunchBagItem.getItems(stack);
            SpecialRecipeItemEvent.deductItems(event, (IItemHandler)items);
            TransmutationLunchBagItem.setItems(stack, items);
            return;
        }
        IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (handler != null) {
            SpecialRecipeItemEvent.deductItems(event, handler);
        }
    }

    private static void addItems(RecipeItemEvent.CheckItem event, IItemHandler items) {
        for (int i = 0; i < items.getSlots(); ++i) {
            ItemStack slotStack = items.getStackInSlot(i);
            if (slotStack.isEmpty()) continue;
            event.addItem(slotStack.getItem(), slotStack.getCount());
        }
    }

    private static void deductItems(RecipeItemEvent.DeductItem event, IItemHandler items) {
        Item needItem = event.getNeedItem();
        for (int i = 0; i < items.getSlots(); ++i) {
            int needCount = event.getNeedCount();
            if (needCount <= 0) {
                return;
            }
            ItemStack slotStack = items.getStackInSlot(i);
            if (!slotStack.is(needItem)) continue;
            ItemStack extractItem = items.extractItem(i, needCount, false);
            event.deduct(extractItem.getCount());
        }
    }
}

