/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.item;

import com.github.ysbbbbbb.kaleidoscopecookery.api.item.IHasContainer;
import com.github.ysbbbbbb.kaleidoscopecookery.block.food.FoodBiteBlock;
import com.github.ysbbbbbb.kaleidoscopecookery.init.registry.CompatRegistry;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class BowlFoodBlockItem
extends BlockItem
implements IHasContainer {
    private final List<MobEffectInstance> effectInstances = Lists.newArrayList();

    public BowlFoodBlockItem(Block block, FoodProperties properties) {
        super(block, new Item.Properties().stacksTo(16).food(new FoodProperties(properties.nutrition(), properties.saturation(), properties.canAlwaysEat(), properties.eatSeconds(), Optional.of(Items.BOWL.getDefaultInstance()), properties.effects())));
        properties.effects().forEach(effect -> {
            if (effect.probability() >= 1.0f) {
                this.effectInstances.add(effect.effect());
            }
        });
    }

    public ItemStack finishUsingItem(ItemStack stack, Level level, LivingEntity entity) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block block = this.getBlock();
            if (block instanceof FoodBiteBlock) {
                FoodBiteBlock foodBiteBlock = (FoodBiteBlock)block;
                LootParams.Builder builder = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)entity.blockPosition())).withParameter(LootContextParams.TOOL, (Object)ItemStack.EMPTY).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)entity).withOptionalParameter(LootContextParams.BLOCK_ENTITY, null);
                BlockState state = (BlockState)foodBiteBlock.defaultBlockState().setValue((Property)foodBiteBlock.getBites(), (Comparable)Integer.valueOf(foodBiteBlock.getMaxBites()));
                List<ItemStack> drops = this.getDrops(state, builder);
                drops.forEach(itemStack -> {
                    if (itemStack.isEmpty()) {
                        return;
                    }
                    if (entity instanceof Player) {
                        Player player = (Player)entity;
                        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)itemStack);
                    } else {
                        ItemEntity itemEntity = new ItemEntity(level, entity.getX(), entity.getY(), entity.getZ(), itemStack);
                        level.addFreshEntity((Entity)itemEntity);
                    }
                });
            }
        }
        return super.finishUsingItem(stack, level, entity);
    }

    private List<ItemStack> getDrops(BlockState state, LootParams.Builder params) {
        ResourceKey resourcekey = state.getBlock().getLootTable();
        if (resourcekey == BuiltInLootTables.EMPTY) {
            return Collections.emptyList();
        }
        LootParams lootParams = params.withParameter(LootContextParams.BLOCK_STATE, (Object)state).create(LootContextParamSets.BLOCK);
        ServerLevel serverLevel = lootParams.getLevel();
        LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(resourcekey);
        return lootTable.getRandomItems(lootParams);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)stack.getItem());
        if (id != null) {
            String key = "tooltip.%s.%s.maxim".formatted(id.getNamespace(), id.getPath());
            tooltip.add((Component)Component.translatable((String)key).withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
        }
        if (!this.effectInstances.isEmpty() && CompatRegistry.SHOW_POTION_EFFECT_TOOLTIPS) {
            tooltip.add((Component)CommonComponents.space());
            PotionContents.addPotionTooltip(this.effectInstances, tooltip::add, (float)1.0f, (float)context.tickRate());
        }
    }

    @Override
    public Item getContainerItem() {
        return Items.BOWL;
    }
}

