/*
 * Decompiled with CFR 0.152.
 */
package com.github.ysbbbbbb.kaleidoscopecookery.item;

import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.PotBlockEntity;
import com.github.ysbbbbbb.kaleidoscopecookery.init.ModDataComponents;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class KitchenShovelItem
extends ShovelItem {
    public static final ResourceLocation HAS_OIL_PROPERTY = ResourceLocation.fromNamespaceAndPath((String)"kaleidoscope_cookery", (String)"has_oil");
    private static final int NO_OIL = 0;
    private static final int HAS_OIL = 1;

    public KitchenShovelItem() {
        super((Tier)Tiers.IRON, new Item.Properties().attributes(ShovelItem.createAttributes((Tier)Tiers.IRON, (float)-1.0f, (float)-2.0f)));
    }

    public static void setHasOil(ItemStack stack, boolean hasOil) {
        stack.set(ModDataComponents.KITCHEN_SHOVEL_HAS_OIL, (Object)hasOil);
    }

    public static boolean hasOil(ItemStack stack) {
        if (stack.has(ModDataComponents.KITCHEN_SHOVEL_HAS_OIL)) {
            return Boolean.TRUE.equals(stack.get(ModDataComponents.KITCHEN_SHOVEL_HAS_OIL));
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static float getTexture(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
        if (KitchenShovelItem.hasOil(stack)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public InteractionResult useOn(UseOnContext context) {
        InteractionResult result = super.useOn(context);
        if (result.indicateItemUse() && KitchenShovelItem.hasOil(context.getItemInHand())) {
            KitchenShovelItem.setHasOil(context.getItemInHand(), false);
        }
        return result;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        BlockPos clickedPos = context.getClickedPos();
        Level level = context.getLevel();
        Player player = context.getPlayer();
        BlockEntity blockEntity = level.getBlockEntity(clickedPos);
        if (blockEntity instanceof PotBlockEntity) {
            PotBlockEntity potBlockEntity = (PotBlockEntity)blockEntity;
            if (player != null && player.isSecondaryUseActive() && potBlockEntity.getStatus() == 2 && !potBlockEntity.hasCarrier()) {
                potBlockEntity.takeOutProduct(level, (LivingEntity)player, stack);
                return InteractionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(stack, context);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"tooltip.kaleidoscope_cookery.kitchen_shovel").withStyle(ChatFormatting.GRAY));
    }
}

